Liferay.Loader.define("app-builder-web@1.0.2/js/pages/entry/ViewEntry.es", ['module', 'exports', 'require', 'frontend-js-web/liferay/toast/commands/OpenToast.es', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/control-menu/ControlMenu.es', '../../components/loading/Loading.es', '../../hooks/useQuery.es', '../../utils/client.es', './FieldPreview.es', './ViewEntryUpperToolbar.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _OpenToast = _interopRequireDefault(require("frontend-js-web/liferay/toast/commands/OpenToast.es"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _ControlMenu = _interopRequireDefault(require("../../components/control-menu/ControlMenu.es"));

  var _Loading = require("../../components/loading/Loading.es");

  var _useQuery3 = _interopRequireWildcard(require("../../hooks/useQuery.es"));

  var _client = require("../../utils/client.es");

  var _FieldPreview = _interopRequireDefault(require("./FieldPreview.es"));

  var _ViewEntryUpperToolbar = _interopRequireDefault(require("./ViewEntryUpperToolbar.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var ViewDataLayoutPageValues = function ViewDataLayoutPageValues(_ref) {
    var dataDefinition = _ref.dataDefinition,
        dataLayoutPage = _ref.dataLayoutPage,
        dataRecordValues = _ref.dataRecordValues;
    var dataLayoutRows = dataLayoutPage.dataLayoutRows;
    return dataLayoutRows.reduce(function (fields, _ref2) {
      var _ref2$dataLayoutColum = _ref2.dataLayoutColumns,
          dataLayoutColumns = _ref2$dataLayoutColum === void 0 ? [] : _ref2$dataLayoutColum;
      return [].concat(_toConsumableArray(fields), _toConsumableArray(dataLayoutColumns.reduce(function (fields, _ref3) {
        var _ref3$fieldNames = _ref3.fieldNames,
            fieldNames = _ref3$fieldNames === void 0 ? [] : _ref3$fieldNames;
        return [].concat(_toConsumableArray(fields), _toConsumableArray(fieldNames));
      }, [])));
    }, []).map(function (fieldName) {
      return _react["default"].createElement(_FieldPreview["default"], {
        dataDefinition: dataDefinition,
        dataRecordValues: dataRecordValues,
        fieldName: fieldName,
        key: fieldName
      });
    });
  };

  var _default = (0, _reactRouterDom.withRouter)(function (_ref4) {
    var history = _ref4.history,
        entryIndex = _ref4.match.params.entryIndex;

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        appId = _useContext.appId,
        basePortletURL = _useContext.basePortletURL;

    var _useState = (0, _react.useState)(true),
        _useState2 = _slicedToArray(_useState, 2),
        isLoading = _useState2[0],
        setLoading = _useState2[1];

    var _useState3 = (0, _react.useState)(),
        _useState4 = _slicedToArray(_useState3, 2),
        dataDefinition = _useState4[0],
        setDataDefinition = _useState4[1];

    var _useState5 = (0, _react.useState)({}),
        _useState6 = _slicedToArray(_useState5, 2),
        dataLayout = _useState6[0],
        setDataLayout = _useState6[1];

    var _useState7 = (0, _react.useState)({
      dataRecord: {},
      page: 1,
      total: 0
    }),
        _useState8 = _slicedToArray(_useState7, 2),
        _useState8$ = _useState8[0],
        dataRecord = _useState8$.dataRecord,
        page = _useState8$.page,
        total = _useState8$.total,
        setResults = _useState8[1];

    var _useQuery = (0, _useQuery3["default"])(history, {
      keywords: '',
      page: 1,
      sort: ''
    }),
        _useQuery2 = _slicedToArray(_useQuery, 1),
        query = _useQuery2[0];

    (0, _react.useEffect)(function () {
      (0, _client.getItem)("/o/app-builder/v1.0/apps/".concat(appId)).then(function (_ref5) {
        var dataDefinitionId = _ref5.dataDefinitionId,
            dataLayoutId = _ref5.dataLayoutId;
        Promise.all([(0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-records"), _objectSpread({}, query, {
          page: entryIndex,
          pageSize: 1
        })).then(function (_ref6) {
          var _ref6$items = _ref6.items,
              items = _ref6$items === void 0 ? [] : _ref6$items,
              page = _ref6.page,
              totalCount = _ref6.totalCount;

          if (items.length > 0) {
            setResults({
              dataRecord: items.pop(),
              page: page,
              total: totalCount
            });
          }
        }), (0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId)).then(function (dataDefinition) {
          return setDataDefinition(dataDefinition);
        }), (0, _client.getItem)("/o/data-engine/v2.0/data-layouts/".concat(dataLayoutId)).then(function (dataLayout) {
          return setDataLayout(dataLayout);
        })]).then(function () {
          return setLoading(false);
        });
      });
    }, [appId, entryIndex, query]);
    var _dataRecord$dataRecor = dataRecord.dataRecordValues,
        dataRecordValues = _dataRecord$dataRecor === void 0 ? {} : _dataRecord$dataRecor;
    var dataLayoutPages = dataLayout.dataLayoutPages;

    return _react["default"].createElement("div", {
      className: "view-entry"
    }, _react["default"].createElement(_ControlMenu["default"], {
      backURL: "../../",
      title: Liferay.Language.get('details-view')
    }), _react["default"].createElement(_ViewEntryUpperToolbar["default"], {
      onDelete: function onDelete() {
        (0, _client.confirmDelete)('/o/data-engine/v2.0/data-records/')({
          id: dataRecord.id
        }).then(function (confirmed) {
          if (confirmed) {
            (0, _OpenToast["default"])({
              message: Liferay.Language.get('an-entry-was-deleted'),
              title: Liferay.Language.get('success'),
              type: 'success'
            });
            history.push('/');
          }
        });
      },
      onEdit: function onEdit() {
        Liferay.Util.navigate(Liferay.Util.PortletURL.createRenderURL(basePortletURL, {
          dataDefinitionId: dataDefinition.id,
          dataLayoutId: dataLayout.id,
          dataRecordId: dataRecord.id,
          mvcPath: '/edit_entry.jsp',
          redirect: location.href
        }));
      },
      onNext: function onNext() {
        var nextIndex = Math.min(parseInt(entryIndex, 10) + 1, total);
        setLoading(true);
        history.push("/entries/".concat(nextIndex, "?").concat((0, _useQuery3.toQueryString)(query)));
      },
      onPrev: function onPrev() {
        var prevIndex = Math.max(parseInt(entryIndex, 10) - 1, 1);
        setLoading(true);
        history.push("/entries/".concat(prevIndex, "?").concat((0, _useQuery3.toQueryString)(query)));
      },
      page: page,
      total: total
    }), _react["default"].createElement(_Loading.Loading, {
      isLoading: isLoading
    }, _react["default"].createElement("div", {
      className: "container"
    }, _react["default"].createElement("div", {
      className: "justify-content-center row"
    }, _react["default"].createElement("div", {
      className: "col-lg-8"
    }, dataLayoutPages && dataRecordValues && dataLayoutPages.map(function (dataLayoutPage, index) {
      return _react["default"].createElement("div", {
        className: "sheet",
        key: index
      }, _react["default"].createElement(ViewDataLayoutPageValues, {
        dataDefinition: dataDefinition,
        dataLayoutPage: dataLayoutPage,
        dataRecordValues: dataRecordValues,
        key: index
      }));
    }))))));
  });

  exports["default"] = _default;
  //# sourceMappingURL=ViewEntry.es.js.map
});
//# sourceMappingURL=ViewEntry.es.js.map