Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/CustomObjectFieldsList.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../components/field-types/FieldTypeList.es', '../../utils/dataLayoutVisitor.es', '../../utils/dragTypes.es', './DataLayoutBuilderContext.es', './FormViewContext.es', './actions.es', './useDeleteDefinitionField.es', './useDeleteDefinitionFieldModal.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _FieldTypeList = _interopRequireDefault(require("../../components/field-types/FieldTypeList.es"));

  var _dataLayoutVisitor = require("../../utils/dataLayoutVisitor.es");

  var _dragTypes = require("../../utils/dragTypes.es");

  var _DataLayoutBuilderContext = _interopRequireDefault(require("./DataLayoutBuilderContext.es"));

  var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

  var _actions = require("./actions.es");

  var _useDeleteDefinitionField = _interopRequireDefault(require("./useDeleteDefinitionField.es"));

  var _useDeleteDefinitionFieldModal = _interopRequireDefault(require("./useDeleteDefinitionFieldModal.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var getFieldTypes = function getFieldTypes(_ref) {
    var dataDefinition = _ref.dataDefinition,
        dataLayout = _ref.dataLayout,
        fieldTypes = _ref.fieldTypes,
        focusedCustomObjectField = _ref.focusedCustomObjectField;
    var dataDefinitionFields = dataDefinition.dataDefinitionFields;
    var dataLayoutPages = dataLayout.dataLayoutPages;
    return dataDefinitionFields.map(function (_ref2) {
      var fieldType = _ref2.fieldType,
          label = _ref2.label,
          name = _ref2.name;
      var fieldTypeSettings = fieldTypes.find(function (_ref3) {
        var name = _ref3.name;
        return name === fieldType;
      });
      return {
        active: name === focusedCustomObjectField.name,
        className: 'custom-object-field',
        description: fieldTypeSettings.label,
        disabled: (0, _dataLayoutVisitor.containsField)(dataLayoutPages, name),
        dragAlignment: 'right',
        dragType: _dragTypes.DRAG_CUSTOM_OBJECT_FIELD,
        icon: fieldTypeSettings.icon,
        label: label.en_US,
        name: name
      };
    });
  };

  var _default = function _default(_ref4) {
    var keywords = _ref4.keywords;

    var _useContext = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        dataLayoutBuilder = _useContext2[0];

    var _useContext3 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 2),
        state = _useContext4[0],
        dispatch = _useContext4[1];

    var dataDefinition = state.dataDefinition;
    var dataDefinitionFields = dataDefinition.dataDefinitionFields;
    var fieldTypes = getFieldTypes(state);

    var deleteField = (0, _useDeleteDefinitionField["default"])({
      dataLayoutBuilder: dataLayoutBuilder
    });
    var onDeleteDefinitionField = (0, _useDeleteDefinitionFieldModal["default"])(function (fieldName) {
      return deleteField(fieldName);
    });
    return _react["default"].createElement(_FieldTypeList["default"], {
      deleteLabel: Liferay.Language.get('delete-from-object'),
      fieldTypes: fieldTypes,
      keywords: keywords,
      onClick: function onClick(_ref5) {
        var name = _ref5.name;
        var dataDefinitionField = dataDefinitionFields.find(function (_ref6) {
          var currentName = _ref6.name;
          return currentName === name;
        });
        dispatch({
          payload: {
            dataDefinitionField: dataDefinitionField
          },
          type: _actions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD
        });
      },
      onDelete: onDeleteDefinitionField,
      onDoubleClick: function onDoubleClick(_ref7) {
        var name = _ref7.name;

        var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
            activePage = _dataLayoutBuilder$ge.activePage,
            pages = _dataLayoutBuilder$ge.pages;

        dataLayoutBuilder.dispatch('fieldAdded', (0, _actions.dropCustomObjectField)({
          addedToPlaceholder: true,
          dataDefinition: dataDefinition,
          dataDefinitionFieldName: name,
          dataLayoutBuilder: dataLayoutBuilder,
          indexes: {
            columnIndex: 0,
            pageIndex: activePage,
            rowIndex: pages[activePage].rows.length
          },
          skipFieldNameGeneration: true
        }));
      }
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=CustomObjectFieldsList.es.js.map
});
//# sourceMappingURL=CustomObjectFieldsList.es.js.map