Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/CustomObjectSidebar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../components/management-toolbar/search/SearchInput.es', '../../components/sidebar/Sidebar.es', '../../hooks/index.es', '../../utils/clickOutside.es', './CustomObjectFieldsList.es', './FormViewContext.es', './actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = require("@frontend-taglib-clay$clayui/button");

  var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

  var _form = _interopRequireDefault(require("@frontend-taglib-clay$clayui/form"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _SearchInput = _interopRequireDefault(require("../../components/management-toolbar/search/SearchInput.es"));

  var _Sidebar = _interopRequireDefault(require("../../components/sidebar/Sidebar.es"));

  var _index = require("../../hooks/index.es");

  var _clickOutside = _interopRequireDefault(require("../../utils/clickOutside.es"));

  var _CustomObjectFieldsList = _interopRequireDefault(require("./CustomObjectFieldsList.es"));

  var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

  var _actions = require("./actions.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var DropDown = function DropDown() {
    var _useContext = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 2),
        fieldTypes = _useContext2[0].fieldTypes,
        dispatch = _useContext2[1];

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        active = _useState2[0],
        setActive = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        showFieldTypes = _useState4[0],
        setShowFieldTypes = _useState4[1];

    var onClickFieldType = function onClickFieldType(fieldTypeName) {
      setActive(false);
      dispatch({
        payload: {
          fieldTypeName: fieldTypeName
        },
        type: _actions.ADD_CUSTOM_OBJECT_FIELD
      });
    };

    (0, _react.useLayoutEffect)(function () {
      if (active) {
        var _document$querySelect = document.querySelector('.custom-object-dropdown-list'),
            parentElement = _document$querySelect.parentElement;

        parentElement.classList.add('custom-object-dropdown-menu');
      }
    }, [active]);
    var filteredFieldTypes = fieldTypes.filter(function (_ref) {
      var group = _ref.group;
      return group === 'basic';
    });
    filteredFieldTypes.sort(function (_ref2, _ref3) {
      var a = _ref2.displayOrder;
      var b = _ref3.displayOrder;
      return a - b;
    });
    return _react["default"].createElement(_dropDown["default"], {
      active: active,
      alignmentPosition: _dropDown.Align.BottomRight,
      className: "custom-object-dropdown",
      onActiveChange: function onActiveChange(newVal) {
        setActive(newVal);
        setShowFieldTypes(false);
      },
      trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
        displayType: "unstyled",
        symbol: "plus"
      })
    }, _react["default"].createElement(_dropDown["default"].ItemList, {
      className: "custom-object-dropdown-list"
    }, showFieldTypes ? filteredFieldTypes.map(function (_ref4) {
      var icon = _ref4.icon,
          label = _ref4.label,
          name = _ref4.name;
      return _react["default"].createElement(_dropDown["default"].Item, {
        key: name,
        onClick: function onClick() {
          return onClickFieldType(name);
        },
        symbolLeft: icon
      }, label);
    }) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_dropDown["default"].Item, {
      key: 'add',
      onClick: function onClick() {
        return setShowFieldTypes(true);
      }
    }, Liferay.Language.get('add-field-to-object')), _react["default"].createElement(_dropDown["default"].Item, {
      key: 'import'
    }, Liferay.Language.get('import-fields-from-spreadsheet')))));
  };

  var Header = function Header(_ref5) {
    var onCloseSearch = _ref5.onCloseSearch,
        onSearch = _ref5.onSearch,
        searchText = _ref5.searchText;

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        searchMode = _useState6[0],
        setSearchMode = _useState6[1];

    var closeSearch = (0, _react.useCallback)(function () {
      setSearchMode(false);
      onCloseSearch();
    }, [onCloseSearch, setSearchMode]);

    (0, _index.useKeyDown)(function () {
      if (searchMode) {
        closeSearch();
      }
    }, 27);
    var searchInputRef = (0, _react.useRef)();
    (0, _react.useEffect)(function () {
      if (searchMode && searchInputRef.current) {
        searchInputRef.current.focus();
      }
    }, [searchInputRef, searchMode]);

    var _useContext3 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 1),
        dataDefinition = _useContext4[0].dataDefinition;

    var _dataDefinition$name$ = dataDefinition.name.en_US,
        dataDefinitionName = _dataDefinition$name$ === void 0 ? '' : _dataDefinition$name$;
    return _react["default"].createElement(_form["default"], {
      onSubmit: function onSubmit(event) {
        return event.preventDefault();
      }
    }, _react["default"].createElement("div", {
      className: (0, _classnames["default"])('custom-object-sidebar-header', 'mt-4', 'p-2', {
        'ml-4': !searchMode
      })
    }, _react["default"].createElement("div", {
      className: "autofit-row autofit-row-center"
    }, searchMode ? _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
      className: "autofit-col autofit-col-expand"
    }, _react["default"].createElement(_SearchInput["default"], {
      clearButton: false,
      onChange: function onChange(searchText) {
        return onSearch(searchText);
      },
      ref: searchInputRef,
      searchText: searchText
    })), _react["default"].createElement("div", {
      className: "autofit-col ml-2",
      key: "closeButton"
    }, _react["default"].createElement(_button.ClayButtonWithIcon, {
      displayType: "unstyled",
      onClick: function onClickClose() {
        return closeSearch();
      },
      symbol: "times"
    }))) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
      className: "autofit-col autofit-col-expand"
    }, _react["default"].createElement("h3", null, dataDefinitionName)), _react["default"].createElement("div", {
      className: "autofit-col",
      key: "searchButton"
    }, _react["default"].createElement(_button.ClayButtonWithIcon, {
      displayType: "unstyled",
      onClick: function onClickSearch() {
        return setSearchMode(true);
      },
      symbol: "search"
    })), _react["default"].createElement("div", {
      className: "autofit-col",
      key: "dropdown"
    }, _react["default"].createElement(DropDown, null))))));
  };

  var _default = function _default() {
    var _useContext5 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext6 = _slicedToArray(_useContext5, 2),
        _useContext6$ = _useContext6[0],
        dataDefinitionFields = _useContext6$.dataDefinition.dataDefinitionFields,
        focusedCustomObjectField = _useContext6$.focusedCustomObjectField,
        dispatch = _useContext6[1];

    var _useState7 = (0, _react.useState)(''),
        _useState8 = _slicedToArray(_useState7, 2),
        searchText = _useState8[0],
        setSearchText = _useState8[1];

    var sidebarRef = (0, _react.useRef)();
    (0, _index.useKeyDown)(function () {
      if (Object.keys(focusedCustomObjectField).length > 0) {
        dispatch({
          payload: {
            dataDefinitionField: {}
          },
          type: _actions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD
        });
      }
    }, 27);
    (0, _react.useEffect)(function () {
      var eventHandler = function eventHandler(_ref6) {
        var target = _ref6.target;

        if ((0, _clickOutside["default"])(target, '.app-builder-sidebar', '.dropdown-menu')) {
          dispatch({
            payload: {
              dataDefinitionField: {}
            },
            type: _actions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD
          });
        }
      };

      window.addEventListener('click', eventHandler);
      return function () {
        return window.removeEventListener('click', eventHandler);
      };
    }, [dispatch]);
    var empty = dataDefinitionFields.length === 0;
    return _react["default"].createElement(_Sidebar["default"], {
      closeable: false,
      ref: sidebarRef
    }, _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(Header, {
      onCloseSearch: function onCloseSearch() {
        return setSearchText('');
      },
      onSearch: function onSearch(searchText) {
        return setSearchText(searchText);
      },
      searchText: searchText
    }), _react["default"].createElement(_Sidebar["default"].Body, {
      className: (0, _classnames["default"])({
        empty: empty
      })
    }, empty ? _react["default"].createElement("div", {
      className: "custom-object-sidebar-empty"
    }, _react["default"].createElement(_icon["default"], {
      symbol: "custom-field"
    }), _react["default"].createElement("h3", null, Liferay.Language.get('there-are-no-fields-yet')), _react["default"].createElement("p", null, Liferay.Language.get('any-field-added-to-the-object-or-to-a-form-view-appears-here'))) : _react["default"].createElement(_CustomObjectFieldsList["default"], {
      keywords: searchText
    }))));
  };

  exports["default"] = _default;
  //# sourceMappingURL=CustomObjectSidebar.es.js.map
});
//# sourceMappingURL=CustomObjectSidebar.es.js.map