Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/DataLayoutBuilderColumn.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../../utils/dragTypes.es', './DataLayoutBuilderContext.es', './FormViewContext.es', './actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _FormSupport = require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _react = require("frontend-js-react-web$react");

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _dragTypes = require("../../utils/dragTypes.es");

  var _DataLayoutBuilderContext = _interopRequireDefault(require("./DataLayoutBuilderContext.es"));

  var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

  var _actions = require("./actions.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var replaceColumn = function replaceColumn(node) {
    if (node.parentNode) {
      node.parentNode.replaceChild(node.cloneNode(true), node);
    }
  };

  var _default = function _default(_ref) {
    var node = _ref.node;

    var _useContext = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        dataDefinition = _useContext2[0].dataDefinition;

    var _useContext3 = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 1),
        dataLayoutBuilder = _useContext4[0];

    var onDrop = (0, _react.useCallback)(function (_ref2) {
      var data = _ref2.data,
          type = _ref2.type;
      var addedToPlaceholder = !!_metalDom["default"].closest(node, '.placeholder');
      var indexes = (0, _FormSupport.getIndexes)(node.parentElement);

      if (type === _dragTypes.DRAG_FIELD_TYPE) {
        dataLayoutBuilder.dispatch('fieldAdded', (0, _actions.dropLayoutBuilderField)({
          addedToPlaceholder: addedToPlaceholder,
          dataLayoutBuilder: dataLayoutBuilder,
          fieldTypeName: data.name,
          indexes: indexes
        }));
      } else if (type === _dragTypes.DRAG_CUSTOM_OBJECT_FIELD) {
        dataLayoutBuilder.dispatch('fieldAdded', (0, _actions.dropCustomObjectField)({
          addedToPlaceholder: addedToPlaceholder,
          dataDefinition: dataDefinition,
          dataDefinitionFieldName: data.name,
          dataLayoutBuilder: dataLayoutBuilder,
          indexes: indexes,
          skipFieldNameGeneration: true
        }));
      }
    }, [dataDefinition, dataLayoutBuilder, node]);

    var _useDrop = (0, _reactDnd.useDrop)({
      accept: [_dragTypes.DRAG_CUSTOM_OBJECT_FIELD, _dragTypes.DRAG_FIELD_TYPE],
      collect: function collect(monitor) {
        return {
          canDrop: monitor.canDrop(),
          overTarget: monitor.isOver()
        };
      },
      drop: onDrop
    }),
        _useDrop2 = _slicedToArray(_useDrop, 2),
        _useDrop2$ = _useDrop2[0],
        canDrop = _useDrop2$.canDrop,
        overTarget = _useDrop2$.overTarget,
        dropColumn = _useDrop2[1];

    (0, _react.useEffect)(function () {
      dropColumn(node);
      return function () {
        return replaceColumn(node);
      };
    }, [dropColumn, node]);
    (0, _react.useEffect)(function () {
      var classList = node.classList;

      if (canDrop && classList.contains('ddm-empty-page')) {
        classList.add('target-droppable');
      } else {
        classList.remove('target-droppable');
      }

      if (overTarget) {
        classList.add('target-over');
      } else {
        classList.remove('target-over');
      }
    }, [canDrop, node, overTarget]);
    return null;
  };

  exports["default"] = _default;
  //# sourceMappingURL=DataLayoutBuilderColumn.es.js.map
});
//# sourceMappingURL=DataLayoutBuilderColumn.es.js.map