Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/DataLayoutBuilderContextProvider.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../utils/dataLayoutVisitor.es', '../../utils/generateDataDefinitionFieldName.es', './DataLayoutBuilderContext.es', './FormViewContext.es', './actions.es', './useDeleteDefinitionField.es', './useDeleteDefinitionFieldModal.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _dataLayoutVisitor = require("../../utils/dataLayoutVisitor.es");

  var _generateDataDefinitionFieldName = _interopRequireDefault(require("../../utils/generateDataDefinitionFieldName.es"));

  var _DataLayoutBuilderContext = _interopRequireDefault(require("./DataLayoutBuilderContext.es"));

  var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

  var _actions = require("./actions.es");

  var _useDeleteDefinitionField = _interopRequireDefault(require("./useDeleteDefinitionField.es"));

  var _useDeleteDefinitionFieldModal = _interopRequireDefault(require("./useDeleteDefinitionFieldModal.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var _default = function _default(_ref) {
    var children = _ref.children,
        dataLayoutBuilder = _ref.dataLayoutBuilder;

    var _useContext = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 2),
        _useContext2$ = _useContext2[0],
        dataDefinition = _useContext2$.dataDefinition,
        dataLayout = _useContext2$.dataLayout,
        dispatch = _useContext2[1];

    var deleteDefinitionField = (0, _useDeleteDefinitionField["default"])({
      dataLayoutBuilder: dataLayoutBuilder
    });
    var onDeleteDefinitionField = (0, _useDeleteDefinitionFieldModal["default"])(function (fieldName) {
      deleteDefinitionField(fieldName);
    });
    (0, _react.useEffect)(function () {
      var provider = dataLayoutBuilder.getProvider();
      provider.props.fieldActions = [{
        action: function action(indexes) {
          return dataLayoutBuilder.dispatch('fieldDuplicated', {
            indexes: indexes
          });
        },
        label: Liferay.Language.get('duplicate')
      }, {
        action: function action(indexes) {
          var fieldName = (0, _dataLayoutVisitor.getFieldNameFromIndexes)(dataLayout, indexes);
          dispatch({
            payload: {
              fieldName: fieldName
            },
            type: _actions.DELETE_DATA_LAYOUT_FIELD
          });
          dataLayoutBuilder.dispatch('fieldDeleted', {
            indexes: indexes
          });
        },
        label: Liferay.Language.get('remove'),
        separator: true
      }, {
        action: function action(indexes) {
          var fieldName = (0, _dataLayoutVisitor.getFieldNameFromIndexes)(dataLayout, indexes);
          onDeleteDefinitionField(fieldName);
        },
        label: Liferay.Language.get('delete-from-object'),
        style: 'danger'
      }];
    }, [dataLayout, dataLayoutBuilder, dispatch, onDeleteDefinitionField]);
    (0, _react.useEffect)(function () {
      var provider = dataLayoutBuilder.getProvider();

      provider.props.fieldNameGenerator = function (desiredFieldName) {
        return (0, _generateDataDefinitionFieldName["default"])(dataDefinition, desiredFieldName);
      };
    }, [dataDefinition, dataLayoutBuilder]);
    (0, _react.useEffect)(function () {
      var provider = dataLayoutBuilder.getProvider();
      var eventHandler = provider.on('focusedFieldChanged', function (_ref2) {
        var newVal = _ref2.newVal;
        provider.once('rendered', function () {
          dispatch({
            payload: {
              focusedField: newVal
            },
            type: _actions.UPDATE_FOCUSED_FIELD
          });
        });
      });
      return function () {
        return eventHandler.removeListener();
      };
    }, [dataLayoutBuilder, dispatch]);
    (0, _react.useEffect)(function () {
      var provider = dataLayoutBuilder.getProvider();
      var eventHandler = provider.on('pagesChanged', function (_ref3) {
        var newVal = _ref3.newVal;
        provider.once('rendered', function () {
          dispatch({
            payload: {
              pages: newVal
            },
            type: _actions.UPDATE_PAGES
          });
        });
      });
      return function () {
        return eventHandler.removeListener();
      };
    }, [dataLayoutBuilder, dispatch]);
    (0, _react.useEffect)(function () {
      var fieldTypes = dataLayoutBuilder.getFieldTypes();
      dispatch({
        payload: {
          fieldTypes: fieldTypes
        },
        type: _actions.UPDATE_FIELD_TYPES
      });
    }, [dataLayoutBuilder, dispatch]);
    return _react["default"].createElement(_DataLayoutBuilderContext["default"].Provider, {
      value: [dataLayoutBuilder, dataLayoutBuilder.dispatch]
    }, children);
  };

  exports["default"] = _default;
  //# sourceMappingURL=DataLayoutBuilderContextProvider.es.js.map
});
//# sourceMappingURL=DataLayoutBuilderContextProvider.es.js.map