Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/DataLayoutBuilderDragAndDrop.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$react', '../../components/drag-and-drop/DragLayer.es', './DataLayoutBuilderColumn.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _FormSupport = require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _DragLayer = _interopRequireDefault(require("../../components/drag-and-drop/DragLayer.es"));

  var _DataLayoutBuilderColumn = _interopRequireDefault(require("./DataLayoutBuilderColumn.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var getColumns = function getColumns() {
    return _toConsumableArray(document.querySelectorAll('.col-empty .ddm-target'));
  };

  var getColumnKey = function getColumnKey(node) {
    var _getIndexes = (0, _FormSupport.getIndexes)(node.parentElement),
        columnIndex = _getIndexes.columnIndex,
        pageIndex = _getIndexes.pageIndex,
        rowIndex = _getIndexes.rowIndex;

    var placeholder = !!_metalDom["default"].closest(node, '.placeholder');
    return "column_".concat(pageIndex, "_").concat(rowIndex, "_").concat(columnIndex, "_").concat(placeholder);
  };

  var _default = function _default(_ref) {
    var dataLayoutBuilder = _ref.dataLayoutBuilder;

    var _useState = (0, _react.useState)(getColumns()),
        _useState2 = _slicedToArray(_useState, 2),
        columns = _useState2[0],
        setColumns = _useState2[1];

    (0, _react.useEffect)(function () {
      var provider = dataLayoutBuilder.getProvider();
      var eventHandler = provider.on('rendered', function () {
        return setColumns(getColumns());
      });
      return function () {
        return eventHandler.removeListener();
      };
    }, [dataLayoutBuilder]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_DragLayer["default"], null), columns.map(function (node, index) {
      return node.parentElement && _react["default"].createElement(_DataLayoutBuilderColumn["default"], {
        key: getColumnKey(node, index),
        node: node
      });
    }));
  };

  exports["default"] = _default;
  //# sourceMappingURL=DataLayoutBuilderDragAndDrop.es.js.map
});
//# sourceMappingURL=DataLayoutBuilderDragAndDrop.es.js.map