Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/DataLayoutBuilderSidebar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', 'frontend-js-react-web$react', '../../components/button/Button.es', '../../components/field-types/FieldTypeList.es', '../../components/sidebar/Sidebar.es', '../../hooks/index.es', '../../utils/clickOutside.es', './DataLayoutBuilderContext.es', './FormViewContext.es', './actions.es', './renderSettingsForm.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _FormSupport = require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es");

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _FieldTypeList = _interopRequireDefault(require("../../components/field-types/FieldTypeList.es"));

  var _Sidebar = _interopRequireDefault(require("../../components/sidebar/Sidebar.es"));

  var _index = require("../../hooks/index.es");

  var _clickOutside = _interopRequireDefault(require("../../utils/clickOutside.es"));

  var _DataLayoutBuilderContext = _interopRequireDefault(require("./DataLayoutBuilderContext.es"));

  var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

  var _actions = require("./actions.es");

  var _renderSettingsForm = _interopRequireWildcard(require("./renderSettingsForm.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var DefaultSidebarBody = function DefaultSidebarBody(_ref) {
    var keywords = _ref.keywords;

    var _useContext = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        dataLayoutBuilder = _useContext2[0];

    var fieldTypes = dataLayoutBuilder.getFieldTypes().filter(function (_ref3) {
      var group = _ref3.group;
      return group === 'basic';
    });
    fieldTypes.sort(function (_ref4, _ref5) {
      var a = _ref4.displayOrder;
      var b = _ref5.displayOrder;
      return a - b;
    });
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_Sidebar["default"].Tab, {
      tabs: [{
        active: true,
        label: Liferay.Language.get('fields')
      }]
    }), _react["default"].createElement(_Sidebar["default"].TabContent, null, _react["default"].createElement(_FieldTypeList["default"], {
      fieldTypes: fieldTypes,
      keywords: keywords,
      onDoubleClick: function onDoubleClick(_ref2) {
        var name = _ref2.name;

        var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
            activePage = _dataLayoutBuilder$ge.activePage,
            pages = _dataLayoutBuilder$ge.pages;

        dataLayoutBuilder.dispatch('fieldAdded', (0, _actions.dropLayoutBuilderField)({
          addedToPlaceholder: true,
          dataLayoutBuilder: dataLayoutBuilder,
          fieldTypeName: name,
          indexes: {
            columnIndex: 0,
            pageIndex: activePage,
            rowIndex: pages[activePage].rows.reduce(function (lastEmptyRowIndex, row, rowIndex) {
              if ((0, _FormSupport.isEmptyRow)(pages, activePage, rowIndex)) {
                return rowIndex;
              }

              return lastEmptyRowIndex;
            }, pages[activePage].rows.length)
          }
        }));
      }
    })));
  };

  var SettingsSidebarBody = function SettingsSidebarBody() {
    var _useContext3 = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 1),
        dataLayoutBuilder = _useContext4[0];

    var _useContext5 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext6 = _slicedToArray(_useContext5, 2),
        state = _useContext6[0],
        dispatch = _useContext6[1];

    var focusedCustomObjectField = state.focusedCustomObjectField,
        focusedField = state.focusedField;
    var customObjectFieldSettingsContext = focusedCustomObjectField.settingsContext;
    var fieldSettingsContext = focusedField.settingsContext;
    var formRef = (0, _react.useRef)();

    var _useState = (0, _react.useState)(null),
        _useState2 = _slicedToArray(_useState, 2),
        form = _useState2[0],
        setForm = _useState2[1];

    var hasFocusedCustomObjectField = !!customObjectFieldSettingsContext;
    var settingsContext = hasFocusedCustomObjectField ? customObjectFieldSettingsContext : fieldSettingsContext;
    (0, _react.useEffect)(function () {
      var filteredSettingsContext = (0, _renderSettingsForm.getFilteredSettingsContext)(settingsContext);

      if (form === null || form.isDisposed()) {
        var dispatchEvent = function dispatchEvent(type, payload) {
          if (hasFocusedCustomObjectField && type === 'fieldEdited') {
            dispatch({
              payload: payload,
              type: _actions.EDIT_CUSTOM_OBJECT_FIELD
            });
          } else if (!hasFocusedCustomObjectField) {
            dataLayoutBuilder.dispatch(type, payload);
          }
        };

        setForm((0, _renderSettingsForm["default"])({
          dispatchEvent: dispatchEvent,
          settingsContext: filteredSettingsContext
        }, formRef.current));
      } else {
        var pages = filteredSettingsContext.pages;
        form.setState({
          pages: pages
        }, function () {
          var evaluableForm = false;
          var visitor = new _visitors.PagesVisitor(pages);
          visitor.mapFields(function (_ref6) {
            var evaluable = _ref6.evaluable;

            if (evaluable) {
              evaluableForm = true;
            }
          });

          if (evaluableForm) {
            form.evaluate().then(function (pages) {
              if (form.isDisposed()) {
                return;
              }

              form.setState({
                pages: pages
              });
            })["catch"](function (error) {
              return dispatch(_actions.EVALUATION_ERROR, error);
            });
          }
        });
      }
    }, [dataLayoutBuilder, dispatch, form, formRef, hasFocusedCustomObjectField, settingsContext]);
    (0, _react.useEffect)(function () {
      return function () {
        return form && form.dispose();
      };
    }, [form, hasFocusedCustomObjectField]);
    var focusedFieldName = hasFocusedCustomObjectField ? focusedCustomObjectField.name : focusedField.name;
    (0, _react.useLayoutEffect)(function () {
      if (!form) {
        return;
      }

      form.once('rendered', function () {
        var firstInput = form.element.querySelector('input');

        if (firstInput && !form.element.contains(document.activeElement)) {
          firstInput.focus();

          if (firstInput.select) {
            firstInput.select();
          }
        }
      });
    }, [focusedFieldName, form]);
    return _react["default"].createElement("form", {
      onSubmit: function onSubmit(event) {
        return event.preventDefault();
      },
      ref: formRef
    });
  };

  var SettingsSidebarHeader = function SettingsSidebarHeader() {
    var _useContext7 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext8 = _slicedToArray(_useContext7, 1),
        _useContext8$ = _useContext8[0],
        fieldTypes = _useContext8$.fieldTypes,
        focusedCustomObjectField = _useContext8$.focusedCustomObjectField,
        focusedField = _useContext8$.focusedField;

    var settingsContext = focusedField.settingsContext;

    if (focusedCustomObjectField.settingsContext) {
      settingsContext = focusedCustomObjectField.settingsContext;
    }

    var visitor = new _visitors.PagesVisitor(settingsContext.pages);
    var typeField = visitor.findField(function (field) {
      return field.fieldName === 'type';
    });
    var fieldType = fieldTypes.find(function (_ref7) {
      var name = _ref7.name;
      return name === typeField.value;
    });

    var _useContext9 = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext10 = _slicedToArray(_useContext9, 1),
        dataLayoutBuilder = _useContext10[0];

    if (!fieldType) return null;
    return _react["default"].createElement(_Sidebar["default"].Header, {
      className: "d-flex"
    }, _react["default"].createElement(_Button["default"], {
      className: "mr-2",
      displayType: "secondary",
      monospaced: false,
      onClick: function handleFocusedFieldBlur() {
        dataLayoutBuilder.dispatch('sidebarFieldBlurred');
      },
      symbol: "angle-left"
    }), _react["default"].createElement(_dropDown["default"], {
      className: "d-inline-flex flex-grow-1",
      onActiveChange: function onActiveChange() {},
      trigger: _react["default"].createElement(_Button["default"], {
        className: "d-inline-flex flex-grow-1",
        disabled: true,
        displayType: "secondary"
      }, _react["default"].createElement(_icon["default"], {
        className: "mr-2 mt-1",
        symbol: fieldType.icon
      }), fieldType.label, _react["default"].createElement("span", {
        className: "d-inline-flex ml-auto navbar-breakpoint-down-d-none pt-2"
      }, _react["default"].createElement(_icon["default"], {
        className: "inline-item inline-item-after",
        symbol: "caret-bottom"
      })))
    }));
  };

  var _default = function _default(_ref8) {
    var dataLayoutBuilderElementId = _ref8.dataLayoutBuilderElementId;

    var _useContext11 = (0, _react.useContext)(_DataLayoutBuilderContext["default"]),
        _useContext12 = _slicedToArray(_useContext11, 1),
        dataLayoutBuilder = _useContext12[0];

    var _useContext13 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext14 = _slicedToArray(_useContext13, 1),
        _useContext14$ = _useContext14[0],
        focusedCustomObjectField = _useContext14$.focusedCustomObjectField,
        focusedField = _useContext14$.focusedField;

    var _useState3 = (0, _react.useState)(''),
        _useState4 = _slicedToArray(_useState3, 2),
        keywords = _useState4[0],
        setKeywords = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        sidebarClosed = _useState6[0],
        setSidebarClosed = _useState6[1];

    var builderElementRef = (0, _react.useRef)(document.querySelector("#".concat(dataLayoutBuilderElementId)));
    (0, _index.useSidebarContent)(builderElementRef, sidebarClosed);
    var sidebarRef = (0, _react.useRef)();
    (0, _react.useEffect)(function () {
      var eventHandler = function eventHandler(_ref9) {
        var target = _ref9.target;

        if ((0, _clickOutside["default"])(target, sidebarRef.current, '.dropdown-menu')) {
          dataLayoutBuilder.dispatch('sidebarFieldBlurred');
        }
      };

      window.addEventListener('click', eventHandler, true);
      return function () {
        return window.removeEventListener('click', eventHandler);
      };
    }, [dataLayoutBuilder, sidebarRef]);
    (0, _react.useEffect)(function () {
      var productMenuToggle = document.querySelector('.product-menu-toggle');

      if (productMenuToggle) {
        var sidenav = Liferay.SideNavigation.instance(productMenuToggle);

        if (!sidebarClosed) {
          sidenav.hide();
        }
      }
    }, [sidebarClosed]);
    (0, _react.useLayoutEffect)(function () {
      var productMenuToggle = document.querySelector('.product-menu-toggle');

      if (productMenuToggle) {
        Liferay.SideNavigation.hide(productMenuToggle);
        var sidenav = Liferay.SideNavigation.instance(productMenuToggle);
        var openEventListener = sidenav.on('openStart.lexicon.sidenav', function () {
          setSidebarClosed(true);
        });
        return function () {
          openEventListener.removeListener();
        };
      }
    }, []);
    var hasFocusedField = Object.keys(focusedField).length > 0;
    var hasFocusedCustomObjectField = Object.keys(focusedCustomObjectField).length > 0;
    var displaySettings = hasFocusedCustomObjectField || hasFocusedField;
    return _react["default"].createElement(_Sidebar["default"], {
      closeable: !displaySettings || sidebarClosed,
      closed: sidebarClosed,
      onSearch: displaySettings ? false : setKeywords,
      onToggle: function onToggle(closed) {
        return setSidebarClosed(closed);
      },
      ref: sidebarRef
    }, _react["default"].createElement(_react["default"].Fragment, null, displaySettings && _react["default"].createElement(SettingsSidebarHeader, null), _react["default"].createElement(_Sidebar["default"].Body, null, displaySettings ? _react["default"].createElement(SettingsSidebarBody, null) : _react["default"].createElement(DefaultSidebarBody, {
      keywords: keywords
    }))));
  };

  exports["default"] = _default;
  //# sourceMappingURL=DataLayoutBuilderSidebar.es.js.map
});
//# sourceMappingURL=DataLayoutBuilderSidebar.es.js.map