Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/FormViewContext.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', 'frontend-js-react-web$react', '../../utils/dataLayoutVisitor.es', '../../utils/generateDataDefinitionFieldName.es', './actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.createReducer = exports.initialState = exports["default"] = void 0;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _react = require("frontend-js-react-web$react");

  var DataLayoutVisistor = _interopRequireWildcard(require("../../utils/dataLayoutVisitor.es"));

  var _generateDataDefinitionFieldName = _interopRequireDefault(require("../../utils/generateDataDefinitionFieldName.es"));

  var _actions = require("./actions.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var FormViewContext = (0, _react.createContext)();
  var initialState = {
    dataDefinition: {
      dataDefinitionFields: [],
      name: {}
    },
    dataDefinitionId: 0,
    dataLayout: {
      dataLayoutPages: [],
      name: {},
      paginationMode: 'wizard'
    },
    dataLayoutId: 0,
    fieldTypes: [],
    focusedCustomObjectField: {},
    focusedField: {}
  };
  exports.initialState = initialState;

  var addCustomObjectField = function addCustomObjectField(_ref) {
    var dataDefinition = _ref.dataDefinition,
        dataLayoutBuilder = _ref.dataLayoutBuilder,
        fieldTypeName = _ref.fieldTypeName,
        fieldTypes = _ref.fieldTypes;
    var fieldType = fieldTypes.find(function (_ref2) {
      var name = _ref2.name;
      return name === fieldTypeName;
    });
    var dataDefinitionField = dataLayoutBuilder.getDefinitionField(fieldType);
    return _objectSpread({}, dataDefinitionField, {
      label: _defineProperty({}, themeDisplay.getLanguageId(), fieldType.label),
      name: (0, _generateDataDefinitionFieldName["default"])(dataDefinition, fieldType.label)
    });
  };

  var deleteDataDefinitionField = function deleteDataDefinitionField(dataDefinition, fieldName) {
    return _objectSpread({}, dataDefinition, {
      dataDefinitionFields: dataDefinition.dataDefinitionFields.filter(function (field) {
        return field.name !== fieldName;
      })
    });
  };

  var deleteDataLayoutField = function deleteDataLayoutField(dataLayout, fieldName) {
    return _objectSpread({}, dataLayout, {
      dataLayoutPages: DataLayoutVisistor.deleteField(dataLayout.dataLayoutPages, fieldName)
    });
  };

  var editFocusedCustomObjectField = function editFocusedCustomObjectField(_ref3) {
    var _objectSpread3;

    var focusedCustomObjectField = _ref3.focusedCustomObjectField,
        propertyName = _ref3.propertyName,
        propertyValue = _ref3.propertyValue;
    var localizableProperty = false;
    var settingsContext = focusedCustomObjectField.settingsContext;
    var visitor = new _visitors.PagesVisitor(settingsContext.pages);

    var newSettingsContext = _objectSpread({}, settingsContext, {
      pages: visitor.mapFields(function (field) {
        var fieldName = field.fieldName,
            localizable = field.localizable;

        if (fieldName === propertyName) {
          localizableProperty = localizable;
          return _objectSpread({}, field, {
            localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, themeDisplay.getLanguageId(), propertyValue)),
            value: propertyValue
          });
        }

        return field;
      })
    });

    if (localizableProperty) {
      propertyValue = _defineProperty({}, themeDisplay.getLanguageId(), propertyValue);
    }

    return _objectSpread({}, focusedCustomObjectField, (_objectSpread3 = {}, _defineProperty(_objectSpread3, propertyName, propertyValue), _defineProperty(_objectSpread3, "settingsContext", newSettingsContext), _objectSpread3));
  };

  var setDataDefinitionFields = function setDataDefinitionFields(dataLayoutBuilder, dataDefinition, dataLayout) {
    var dataDefinitionFields = dataDefinition.dataDefinitionFields;
    var dataLayoutPages = dataLayout.dataLayoutPages;

    var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
        pages = _dataLayoutBuilder$ge.pages;

    var visitor = new _visitors.PagesVisitor(pages);
    var newFields = [];
    visitor.mapFields(function (field) {
      var definitionField = dataLayoutBuilder.getDefinitionField(field);
      newFields.push(definitionField);
    });
    return newFields.concat(dataDefinitionFields.filter(function (field) {
      return !DataLayoutVisistor.containsField(dataLayoutPages, field.name) && !newFields.some(function (_ref4) {
        var name = _ref4.name;
        return name === field.name;
      });
    }));
  };

  var setDataLayout = function setDataLayout(dataLayoutBuilder) {
    var _dataLayoutBuilder$ge2 = dataLayoutBuilder.getStore(),
        pages = _dataLayoutBuilder$ge2.pages;

    var _dataLayoutBuilder$ge3 = dataLayoutBuilder.getDefinitionAndLayout(pages),
        layout = _dataLayoutBuilder$ge3.layout;

    return layout;
  };

  var createReducer = function createReducer(dataLayoutBuilder) {
    return function () {
      var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
      var action = arguments.length > 1 ? arguments[1] : undefined;

      switch (action.type) {
        case _actions.ADD_CUSTOM_OBJECT_FIELD:
          {
            var fieldTypeName = action.payload.fieldTypeName;
            var dataDefinition = state.dataDefinition,
                fieldTypes = state.fieldTypes;
            var newCustomObjectField = addCustomObjectField({
              dataDefinition: dataDefinition,
              dataLayoutBuilder: dataLayoutBuilder,
              fieldTypeName: fieldTypeName,
              fieldTypes: fieldTypes
            });
            return _objectSpread({}, state, {
              dataDefinition: _objectSpread({}, dataDefinition, {
                dataDefinitionFields: [].concat(_toConsumableArray(dataDefinition.dataDefinitionFields), [newCustomObjectField])
              }),
              focusedCustomObjectField: _objectSpread({}, newCustomObjectField, {
                settingsContext: dataLayoutBuilder.getFieldSettingsContext(newCustomObjectField)
              })
            });
          }

        case _actions.DELETE_DATA_DEFINITION_FIELD:
          {
            var fieldName = action.payload.fieldName;
            var _dataDefinition = state.dataDefinition;
            return _objectSpread({}, state, {
              dataDefinition: deleteDataDefinitionField(_dataDefinition, fieldName)
            });
          }

        case _actions.DELETE_DATA_LAYOUT_FIELD:
          {
            var _fieldName = action.payload.fieldName;
            var dataLayout = state.dataLayout;
            return _objectSpread({}, state, {
              dataLayout: deleteDataLayoutField(dataLayout, _fieldName)
            });
          }

        case _actions.EDIT_CUSTOM_OBJECT_FIELD:
          {
            var _dataDefinition2 = state.dataDefinition,
                focusedCustomObjectField = state.focusedCustomObjectField;
            var editedFocusedCustomObjectField = editFocusedCustomObjectField(_objectSpread({}, action.payload, {
              focusedCustomObjectField: focusedCustomObjectField
            }));
            var settingsContext = editedFocusedCustomObjectField.settingsContext;
            return _objectSpread({}, state, {
              dataDefinition: _objectSpread({}, _dataDefinition2, {
                dataDefinitionFields: _dataDefinition2.dataDefinitionFields.map(function (dataDefinitionField) {
                  if (dataDefinitionField.name === focusedCustomObjectField.name) {
                    return dataLayoutBuilder.getDefinitionField(editedFocusedCustomObjectField);
                  }

                  return dataDefinitionField;
                })
              }),
              focusedCustomObjectField: _objectSpread({}, editedFocusedCustomObjectField, {
                settingsContext: settingsContext
              })
            });
          }

        case _actions.UPDATE_DATA_DEFINITION:
          {
            var _dataDefinition3 = action.payload.dataDefinition;
            return _objectSpread({}, state, {
              dataDefinition: _objectSpread({}, state.dataDefinition, {}, _dataDefinition3)
            });
          }

        case _actions.UPDATE_DATA_LAYOUT:
          {
            var _dataLayout = action.payload.dataLayout;
            return _objectSpread({}, state, {
              dataLayout: _objectSpread({}, state.dataLayout, {}, _dataLayout)
            });
          }

        case _actions.UPDATE_DATA_LAYOUT_NAME:
          {
            var name = action.payload.name;
            return _objectSpread({}, state, {
              dataLayout: _objectSpread({}, state.dataLayout, {
                name: name
              })
            });
          }

        case _actions.UPDATE_FIELD_TYPES:
          {
            var _fieldTypes = action.payload.fieldTypes;
            return _objectSpread({}, state, {
              fieldTypes: _fieldTypes.filter(function (_ref5) {
                var system = _ref5.system;
                return !system;
              })
            });
          }

        case _actions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD:
          {
            var dataDefinitionField = action.payload.dataDefinitionField;
            var _focusedCustomObjectField = {};

            if (Object.keys(dataDefinitionField).length > 0) {
              _focusedCustomObjectField = _objectSpread({}, dataDefinitionField, {
                settingsContext: dataLayoutBuilder.getFieldSettingsContext(dataDefinitionField)
              });
              return _objectSpread({}, state, {
                focusedCustomObjectField: _focusedCustomObjectField,
                focusedField: {}
              });
            }

            return _objectSpread({}, state, {
              focusedCustomObjectField: {}
            });
          }

        case _actions.UPDATE_FOCUSED_FIELD:
          {
            var focusedField = action.payload.focusedField;

            if (Object.keys(focusedField).length > 0) {
              return _objectSpread({}, state, {
                focusedCustomObjectField: {},
                focusedField: focusedField
              });
            }

            return _objectSpread({}, state, {
              focusedField: {}
            });
          }

        case _actions.UPDATE_IDS:
          {
            var _action$payload = action.payload,
                dataDefinitionId = _action$payload.dataDefinitionId,
                dataLayoutId = _action$payload.dataLayoutId;
            return _objectSpread({}, state, {
              dataDefinitionId: dataDefinitionId,
              dataLayoutId: dataLayoutId
            });
          }

        case _actions.UPDATE_PAGES:
          {
            var _dataDefinition4 = state.dataDefinition,
                _dataLayout2 = state.dataLayout;
            return _objectSpread({}, state, {
              dataDefinition: _objectSpread({}, _dataDefinition4, {
                dataDefinitionFields: setDataDefinitionFields(dataLayoutBuilder, _dataDefinition4, _dataLayout2)
              }),
              dataLayout: _objectSpread({}, _dataLayout2, {}, setDataLayout(dataLayoutBuilder))
            });
          }

        default:
          return state;
      }
    };
  };

  exports.createReducer = createReducer;
  var _default = FormViewContext;
  exports["default"] = _default;
  //# sourceMappingURL=FormViewContext.es.js.map
});
//# sourceMappingURL=FormViewContext.es.js.map