Liferay.Loader.define("app-builder-web@1.0.2/js/pages/form-view/renderSettingsForm.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/containers/Form/Form.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.getFilteredSettingsContext = void 0;

  var _Form = _interopRequireDefault(require("dynamic-data-mapping-form-renderer/js/containers/Form/Form.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var spritemap = "".concat(Liferay.ThemeDisplay.getPathThemeImages(), "/lexicon/icons.svg");
  var UNIMPLIMENTED_PROPERTIES = ['fieldNamespace', 'indexType', 'localizable', 'readOnly', 'type', 'validation', 'visibilityExpression'];

  var getFilteredSettingsContext = function getFilteredSettingsContext(settingsContext) {
    var visitor = new _visitors.PagesVisitor(settingsContext.pages);
    return _objectSpread({}, settingsContext, {
      pages: visitor.mapColumns(function (column) {
        return _objectSpread({}, column, {
          fields: column.fields.filter(function (_ref) {
            var fieldName = _ref.fieldName;
            return UNIMPLIMENTED_PROPERTIES.indexOf(fieldName) === -1;
          }).map(function (field) {
            if (field.fieldName === 'dataSourceType') {
              field = _objectSpread({}, field, {
                predefinedValue: '["manual"]',
                readOnly: true
              });
            }

            return _objectSpread({}, field, {
              defaultLanguageId: themeDisplay.getLanguageId(),
              editingLanguageId: themeDisplay.getLanguageId()
            });
          })
        });
      })
    });
  };

  exports.getFilteredSettingsContext = getFilteredSettingsContext;

  var _default = function _default(_ref2, container) {
    var dispatchEvent = _ref2.dispatchEvent,
        settingsContext = _ref2.settingsContext;

    return new _Form["default"](_objectSpread({}, settingsContext, {
      editable: true,
      events: {
        attached: function handleFormAttached() {
          this.evaluate();
        },
        fieldBlurred: function handleFieldBlurred(_ref3) {
          var fieldInstance = _ref3.fieldInstance,
              value = _ref3.value;

          if (fieldInstance && !fieldInstance.isDisposed()) {
            var fieldName = fieldInstance.fieldName;
            dispatchEvent('fieldBlurred', {
              editingLanguageId: themeDisplay.getLanguageId(),
              propertyName: fieldName,
              propertyValue: value
            });
          }
        },
        fieldEdited: function handleFieldEdited(_ref4) {
          var fieldInstance = _ref4.fieldInstance,
              value = _ref4.value;

          if (fieldInstance && !fieldInstance.isDisposed()) {
            var fieldName = fieldInstance.fieldName;
            dispatchEvent('fieldEdited', {
              editingLanguageId: themeDisplay.getLanguageId(),
              propertyName: fieldName,
              propertyValue: value
            });
          }
        }
      },
      spritemap: spritemap
    }), container);
  };

  exports["default"] = _default;
  //# sourceMappingURL=renderSettingsForm.es.js.map
});
//# sourceMappingURL=renderSettingsForm.es.js.map