Liferay.Loader.define("app-builder-web@1.0.2/js/pages/table-view/DropZone.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', '../../components/table/Table.es', '../../utils/dragTypes.es', './ColumnOverlay.es', './DropZonePlaceholder.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _Table = _interopRequireDefault(require("../../components/table/Table.es"));

  var _dragTypes = require("../../utils/dragTypes.es");

  var _ColumnOverlay = _interopRequireDefault(require("./ColumnOverlay.es"));

  var _DropZonePlaceholder = _interopRequireDefault(require("./DropZonePlaceholder.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var generateItems = function generateItems(columns) {
    var rows = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 10;
    var items = [];

    for (var i = 0; i < rows; i++) {
      items.push(generateItem(columns, i));
    }

    return items;
  };

  var generateItem = function generateItem(columns) {
    return columns.reduce(function (acc, column) {
      return _objectSpread({}, acc, _defineProperty({}, column, "-"));
    }, {});
  };

  var DropZone = function DropZone(_ref) {
    var fields = _ref.fields,
        onAddFieldName = _ref.onAddFieldName,
        onRemoveFieldName = _ref.onRemoveFieldName;

    var _useDrop = (0, _reactDnd.useDrop)({
      accept: _dragTypes.DRAG_FIELD_TYPE,
      collect: function collect(monitor) {
        return {
          canDrop: monitor.canDrop(),
          overTarget: monitor.isOver()
        };
      },
      drop: function drop(_ref2) {
        var name = _ref2.data.name;
        onAddFieldName(name);
      }
    }),
        _useDrop2 = _slicedToArray(_useDrop, 2),
        _useDrop2$ = _useDrop2[0],
        canDrop = _useDrop2$.canDrop,
        overTarget = _useDrop2$.overTarget,
        drop = _useDrop2[1];

    var _useState = (0, _react.useState)(),
        _useState2 = _slicedToArray(_useState, 2),
        container = _useState2[0],
        setContainer = _useState2[1];

    var containerRef = (0, _react.useRef)();
    var empty = fields.length === 0;
    (0, _react.useLayoutEffect)(function () {
      if (containerRef.current) {
        setContainer(containerRef.current);
      }
    }, [empty]);

    if (empty) {
      return _react["default"].createElement("div", {
        className: "p-4 sheet"
      }, _react["default"].createElement("div", {
        className: "empty-drop-zone-header"
      }), _react["default"].createElement("div", {
        className: (0, _classnames["default"])('empty-drop-zone', {
          'target-droppable': canDrop,
          'target-over': overTarget
        }),
        ref: drop
      }, _react["default"].createElement("p", {
        className: "m-0"
      }, Liferay.Language.get('drag-columns-from-the-sidebar-and-drop-here'))));
    }

    return _react["default"].createElement("div", {
      ref: containerRef
    }, _react["default"].createElement(_Table["default"], {
      actions: [],
      checkable: true,
      columns: fields.map(function (_ref3) {
        var label = _ref3.label;
        return {
          key: label,
          value: _react["default"].createElement("div", {
            className: "container p-0"
          }, _react["default"].createElement("div", {
            className: "align-items-center row"
          }, _react["default"].createElement("div", {
            className: "col"
          }, label ? label.en_US : '')))
        };
      }),
      items: generateItems(fields.map(function (_ref4) {
        var label = _ref4.label;
        return label ? label.en_US : '';
      })),
      ref: drop
    }), container && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_DropZonePlaceholder["default"], {
      container: container,
      fields: fields,
      onAddFieldName: onAddFieldName
    }), _react["default"].createElement(_ColumnOverlay["default"], {
      container: container,
      fields: fields,
      onRemoveFieldName: onRemoveFieldName
    })));
  };

  var _default = DropZone;
  exports["default"] = _default;
  //# sourceMappingURL=DropZone.es.js.map
});
//# sourceMappingURL=DropZone.es.js.map