Liferay.Loader.define("app-builder-web@1.0.2/js/pages/table-view/TableViewSidebar.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../components/button/Button.es', '../../components/field-types/FieldType.es', '../../components/field-types/FieldTypeList.es', '../../components/sidebar/Sidebar.es', '../../utils/dataDefinition.es', './EditTableViewContext.es', './TableViewFilters.es', './utils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _FieldType = _interopRequireDefault(require("../../components/field-types/FieldType.es"));

  var _FieldTypeList = _interopRequireDefault(require("../../components/field-types/FieldTypeList.es"));

  var _Sidebar = _interopRequireDefault(require("../../components/sidebar/Sidebar.es"));

  var _dataDefinition = require("../../utils/dataDefinition.es");

  var _EditTableViewContext = _interopRequireWildcard(require("./EditTableViewContext.es"));

  var _TableViewFilters = _interopRequireDefault(require("./TableViewFilters.es"));

  var _utils = require("./utils.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var FiltersSidebarHeader = function FiltersSidebarHeader() {
    var _useContext = (0, _react.useContext)(_EditTableViewContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 2),
        _useContext2$ = _useContext2[0],
        dataDefinition = _useContext2$.dataDefinition,
        fieldTypes = _useContext2$.fieldTypes,
        focusedColumn = _useContext2$.focusedColumn,
        dispatch = _useContext2[1];

    var _getDataDefinitionFie = (0, _dataDefinition.getDataDefinitionField)(dataDefinition, focusedColumn),
        fieldType = _getDataDefinitionFie.fieldType;

    return _react["default"].createElement(_Sidebar["default"].Header, {
      className: "d-flex table-view-filters-sidebar-header"
    }, _react["default"].createElement(_Button["default"], {
      className: "mr-2",
      displayType: "secondary",
      monospaced: false,
      onClick: function onClickBack() {
        dispatch({
          payload: {
            fieldName: null
          },
          type: _EditTableViewContext.UPDATE_FOCUSED_COLUMN
        });
      },
      symbol: "angle-left"
    }), _react["default"].createElement(_FieldType["default"], {
      description: (0, _utils.getFieldTypeLabel)(fieldTypes, fieldType),
      dragAlignment: "none",
      draggable: false,
      icon: fieldType,
      label: (0, _dataDefinition.getFieldLabel)(dataDefinition, focusedColumn),
      name: focusedColumn
    }));
  };

  var FieldsTabContent = function FieldsTabContent(_ref) {
    var keywords = _ref.keywords,
        onAddFieldName = _ref.onAddFieldName;

    var _useContext3 = (0, _react.useContext)(_EditTableViewContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 1),
        _useContext4$ = _useContext4[0],
        dataDefinitionFields = _useContext4$.dataDefinition.dataDefinitionFields,
        fieldNames = _useContext4$.dataListView.fieldNames,
        fieldTypes = _useContext4$.fieldTypes;

    return _react["default"].createElement(_FieldTypeList["default"], {
      fieldTypes: dataDefinitionFields.map(function (_ref2) {
        var fieldType = _ref2.fieldType,
            label = _ref2.label.en_US,
            name = _ref2.name;
        return {
          description: (0, _utils.getFieldTypeLabel)(fieldTypes, fieldType),
          disabled: fieldNames.some(function (fieldName) {
            return fieldName === name;
          }),
          icon: fieldType,
          label: label,
          name: name
        };
      }),
      keywords: keywords,
      onDoubleClick: function onDoubleClick(_ref3) {
        var name = _ref3.name;
        return onAddFieldName(name, fieldNames.length);
      }
    });
  };

  var SidebarContent = function SidebarContent(_ref4) {
    var activeTabIndex = _ref4.activeTabIndex,
        keywords = _ref4.keywords,
        onAddFieldName = _ref4.onAddFieldName;

    switch (activeTabIndex) {
      case 0:
        return _react["default"].createElement(FieldsTabContent, {
          keywords: keywords,
          onAddFieldName: onAddFieldName
        });

      case 1:
        return _react["default"].createElement(_TableViewFilters["default"], null);

      default:
        return null;
    }
  };

  var _default = function _default(_ref5) {
    var onAddFieldName = _ref5.onAddFieldName,
        onClose = _ref5.onClose;

    var _useContext5 = (0, _react.useContext)(_EditTableViewContext["default"]),
        _useContext6 = _slicedToArray(_useContext5, 1),
        focusedColumn = _useContext6[0].focusedColumn;

    var _useState = (0, _react.useState)(0),
        _useState2 = _slicedToArray(_useState, 2),
        activeTabIndex = _useState2[0],
        setActiveTabIndex = _useState2[1];

    var _useState3 = (0, _react.useState)(''),
        _useState4 = _slicedToArray(_useState3, 2),
        keywords = _useState4[0],
        setKeywords = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        sidebarClosed = _useState6[0],
        setSidebarClosed = _useState6[1];

    var onClickTab = function onClickTab(tabIndex) {
      return setActiveTabIndex(tabIndex);
    };

    var displayFieldFilters = !!focusedColumn;
    return _react["default"].createElement(_Sidebar["default"], {
      closeable: !displayFieldFilters || sidebarClosed,
      closed: sidebarClosed,
      onSearch: displayFieldFilters ? false : setKeywords,
      onToggle: function onSidebarToggle(closed) {
        setSidebarClosed(closed);
        onClose(closed);
      }
    }, displayFieldFilters && _react["default"].createElement(FiltersSidebarHeader, null), _react["default"].createElement(_Sidebar["default"].Body, null, !displayFieldFilters && _react["default"].createElement(_Sidebar["default"].Tab, {
      tabs: [{
        active: activeTabIndex === 0,
        label: Liferay.Language.get('columns'),
        onClick: onClickTab
      }, {
        active: activeTabIndex === 1,
        label: Liferay.Language.get('filters'),
        onClick: onClickTab
      }]
    }), _react["default"].createElement(_Sidebar["default"].TabContent, null, _react["default"].createElement(SidebarContent, {
      activeTabIndex: displayFieldFilters ? 1 : activeTabIndex,
      keywords: keywords,
      onAddFieldName: onAddFieldName
    }))));
  };

  exports["default"] = _default;
  //# sourceMappingURL=TableViewSidebar.es.js.map
});
//# sourceMappingURL=TableViewSidebar.es.js.map