Liferay.Loader.define("app-builder-web@1.0.2/js/utils/dataDefinition.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getOptionLabel = exports.getFieldLabel = exports.getDataDefinitionField = void 0;

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var getDataDefinitionField = function getDataDefinitionField() {
    var dataDefinition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
      dataDefinitionFields: []
    };
    var fieldName = arguments.length > 1 ? arguments[1] : undefined;
    return dataDefinition.dataDefinitionFields.find(function (field) {
      return field.name === fieldName;
    }, fieldName);
  };

  exports.getDataDefinitionField = getDataDefinitionField;

  var getFieldLabel = function getFieldLabel(dataDefinition, fieldName) {
    var field = getDataDefinitionField(dataDefinition, fieldName);
    return field ? field.label[themeDisplay.getLanguageId()] : fieldName;
  };

  exports.getFieldLabel = getFieldLabel;

  var getOptionLabel = function getOptionLabel() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var value = arguments.length > 1 ? arguments[1] : undefined;
    return (options[themeDisplay.getLanguageId()] || []).reduce(function (result, option) {
      if (option.value === value) {
        return option.label;
      }

      return result;
    }, value);
  };

  exports.getOptionLabel = getOptionLabel;
  //# sourceMappingURL=dataDefinition.es.js.map
});
//# sourceMappingURL=dataDefinition.es.js.map