"use strict";

Liferay.Loader.define("app-builder-web$dnd-core@7.7.0/lib/cjs/reducers/dragOperation", ['module', 'exports', 'require', '../actions/dragDrop', '../actions/registry', '../utils/discount_lodash'], function (module, exports, require) {
    var define = undefined;
    var __assign = this && this.__assign || function () {
        __assign = Object.assign || function (t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    var dragDrop_1 = require("../actions/dragDrop");
    var registry_1 = require("../actions/registry");
    var discount_lodash_1 = require("../utils/discount_lodash");
    var initialState = {
        itemType: null,
        item: null,
        sourceId: null,
        targetIds: [],
        dropResult: null,
        didDrop: false,
        isSourcePublic: null
    };
    function dragOperation(state, action) {
        if (state === void 0) {
            state = initialState;
        }
        var payload = action.payload;
        switch (action.type) {
            case dragDrop_1.BEGIN_DRAG:
                return __assign({}, state, { itemType: payload.itemType, item: payload.item, sourceId: payload.sourceId, isSourcePublic: payload.isSourcePublic, dropResult: null, didDrop: false });
            case dragDrop_1.PUBLISH_DRAG_SOURCE:
                return __assign({}, state, { isSourcePublic: true });
            case dragDrop_1.HOVER:
                return __assign({}, state, { targetIds: payload.targetIds });
            case registry_1.REMOVE_TARGET:
                if (state.targetIds.indexOf(payload.targetId) === -1) {
                    return state;
                }
                return __assign({}, state, { targetIds: discount_lodash_1.without(state.targetIds, payload.targetId) });
            case dragDrop_1.DROP:
                return __assign({}, state, { dropResult: payload.dropResult, didDrop: true, targetIds: [] });
            case dragDrop_1.END_DRAG:
                return __assign({}, state, { itemType: null, item: null, sourceId: null, dropResult: null, didDrop: false, isSourcePublic: null, targetIds: [] });
            default:
                return state;
        }
    }
    exports.default = dragOperation;
});
//# sourceMappingURL=dragOperation.js.map