Liferay.Loader.define('app-builder-web$lodash-es@4.17.11/_getFuncName', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import realNames from './_realNames.js';

  /** Used for built-in method references. */
  var objectProto = Object.prototype;

  /** Used to check objects for own properties. */
  var hasOwnProperty = objectProto.hasOwnProperty;

  /**
   * Gets the name of `func`.
   *
   * @private
   * @param {Function} func The function to query.
   * @returns {string} Returns the function name.
   */
  function getFuncName(func) {
    var result = func.name + '',
        array = realNames[result],
        length = hasOwnProperty.call(realNames, result) ? array.length : 0;

    while (length--) {
      var data = array[length],
          otherFunc = data.func;
      if (otherFunc == null || otherFunc == func) {
        return data.name;
      }
    }
    return result;
  }

  export default getFuncName;
});
//# sourceMappingURL=_getFuncName.js.map