Liferay.Loader.define('app-builder-web$lodash-es@4.17.11/nth', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseNth from './_baseNth.js';
  import toInteger from './toInteger.js';

  /**
   * Gets the element at index `n` of `array`. If `n` is negative, the nth
   * element from the end is returned.
   *
   * @static
   * @memberOf _
   * @since 4.11.0
   * @category Array
   * @param {Array} array The array to query.
   * @param {number} [n=0] The index of the element to return.
   * @returns {*} Returns the nth element of `array`.
   * @example
   *
   * var array = ['a', 'b', 'c', 'd'];
   *
   * _.nth(array, 1);
   * // => 'b'
   *
   * _.nth(array, -2);
   * // => 'c';
   */
  function nth(array, n) {
    return array && array.length ? baseNth(array, toInteger(n)) : undefined;
  }

  export default nth;
});
//# sourceMappingURL=nth.js.map