Liferay.Loader.define('app-builder-web$node-fetch@1.7.3/lib/fetch-error', ['module', 'exports', 'require', 'frontend-js-node-shims$util'], function (module, exports, require) {
  var define = undefined;

  /**
   * fetch-error.js
   *
   * FetchError interface for operational errors
   */

  module.exports = FetchError;

  /**
   * Create FetchError instance
   *
   * @param   String      message      Error message for human
   * @param   String      type         Error type for machine
   * @param   String      systemError  For Node.js system error
   * @return  FetchError
   */
  function FetchError(message, type, systemError) {

    this.name = this.constructor.name;
    this.message = message;
    this.type = type;

    // when err.type is `system`, err.code contains system error code
    if (systemError) {
      this.code = this.errno = systemError.code;
    }

    // hide custom error implementation details from end-users
    Error.captureStackTrace(this, this.constructor);
  }

  require('frontend-js-node-shims$util').inherits(FetchError, Error);
});
//# sourceMappingURL=fetch-error.js.map