Liferay.Loader.define("app-builder-web@1.0.55/js/components/control-menu/ControlMenu.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', 'app-builder-web$react-router-dom', '../../AppContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.ControlMenuBase = exports.PortalControlMenu = exports.InlineControlMenu = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDom = require("frontend-js-react-web$react-dom");

    var _reactRouterDom = require("app-builder-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var BackButton = function BackButton(_ref) {
      var backURL = _ref.backURL;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          backButtonContainer = _useState2[0],
          setBackButtonContainer = _useState2[1];

      var Link = backURL && backURL.startsWith('http') ? ExternalLink : _reactRouterDom.Link;
      (0, _react.useEffect)(function () {
        if (backButtonContainer !== null) {
          return;
        }

        setBackButtonContainer(document.querySelector('.sites-control-group .control-menu-nav'));
      }, [backButtonContainer]);

      if (!backButtonContainer) {
        return _react["default"].createElement(_react["default"].Fragment, null);
      }

      return (0, _reactDom.createPortal)(_react["default"].createElement("li", {
        className: "control-menu-nav-item"
      }, _react["default"].createElement(Link, {
        className: "control-menu-icon lfr-icon-item",
        tabIndex: 1,
        to: backURL
      }, _react["default"].createElement("span", {
        className: "icon-monospaced"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "angle-left"
      })))), backButtonContainer);
    };

    var ExternalLink = function ExternalLink(_ref2) {
      var children = _ref2.children,
          to = _ref2.to,
          props = _objectWithoutProperties(_ref2, ["children", "to"]);

      return _react["default"].createElement("a", _extends({
        href: to
      }, props), children);
    };

    var resolveBackURL = function resolveBackURL(backURL, url) {
      if (backURL === '../') {
        var paths = url.split('/');
        paths.pop();
        backURL = paths.join('/');
      }

      return backURL;
    };

    var setDocumentTitle = function setDocumentTitle(title) {
      if (title) {
        var titles = document.title.split(' - ');
        titles[0] = title;
        document.title = titles.join(' - ');
      }
    };

    var InlineControlMenu = function InlineControlMenu(_ref3) {
      var backURL = _ref3.backURL,
          title = _ref3.title,
          url = _ref3.url;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          appDeploymentType = _useContext.appDeploymentType,
          controlMenuElementId = _useContext.controlMenuElementId;

      backURL = resolveBackURL(backURL, url);
      var Link = backURL && backURL.startsWith('http') ? ExternalLink : _reactRouterDom.Link;

      var _useState3 = (0, _react.useState)(null),
          _useState4 = _slicedToArray(_useState3, 2),
          controlMenuContainer = _useState4[0],
          setControlMenuContainer = _useState4[1];

      (0, _react.useEffect)(function () {
        if (controlMenuContainer !== null) {
          return;
        }

        setControlMenuContainer(document.getElementById(controlMenuElementId));
      }, [controlMenuContainer, controlMenuElementId]);

      var ControlMenu = function ControlMenu() {
        return _react["default"].createElement("div", {
          className: (0, _classnames["default"])('app-builder-control-menu', appDeploymentType)
        }, backURL && _react["default"].createElement(Link, {
          className: (0, _classnames["default"])('control-menu-back-button', appDeploymentType),
          tabIndex: 1,
          to: backURL
        }, _react["default"].createElement("span", {
          className: "icon-monospaced"
        }, _react["default"].createElement(_icon["default"], {
          symbol: "angle-left"
        }))), title && _react["default"].createElement("span", {
          className: (0, _classnames["default"])('control-menu-title', appDeploymentType)
        }, title));
      };

      return controlMenuContainer ? (0, _reactDom.createPortal)(_react["default"].createElement(ControlMenu, null), controlMenuContainer) : _react["default"].createElement(ControlMenu, null);
    };

    exports.InlineControlMenu = InlineControlMenu;

    var PortalControlMenu = function PortalControlMenu(_ref4) {
      var backURL = _ref4.backURL,
          title = _ref4.title,
          url = _ref4.url;
      backURL = resolveBackURL(backURL, url);
      (0, _react.useEffect)(function () {
        document.querySelector('.tools-control-group .control-menu-level-1-heading').innerHTML = title;
      }, [title]);
      return _react["default"].createElement(_react["default"].Fragment, null, backURL && _react["default"].createElement(BackButton, {
        backURL: backURL
      }));
    };

    exports.PortalControlMenu = PortalControlMenu;

    var ControlMenuBase = function ControlMenuBase(props) {
      (0, _react.useEffect)(function () {
        setDocumentTitle(props.title);
      }, [props.title]);

      var _useContext2 = (0, _react.useContext)(_AppContext.AppContext),
          appDeploymentType = _useContext2.appDeploymentType;

      if (appDeploymentType && (appDeploymentType === 'standalone' || appDeploymentType === 'widget')) {
        return _react["default"].createElement(InlineControlMenu, props);
      } else {
        return _react["default"].createElement(PortalControlMenu, props);
      }
    };

    exports.ControlMenuBase = ControlMenuBase;

    var _default = (0, _reactRouterDom.withRouter)(function (_ref5) {
      var url = _ref5.match.url,
          props = _objectWithoutProperties(_ref5, ["match"]);

      return _react["default"].createElement(ControlMenuBase, _extends({}, props, {
        url: url
      }));
    });

    exports["default"] = _default;
    //# sourceMappingURL=ControlMenu.es.js.map
  }
});
//# sourceMappingURL=ControlMenu.es.js.map