Liferay.Loader.define("app-builder-web@1.0.55/js/components/list-view/ListView.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../hooks/useQuery.es', '../../hooks/useResource.es', '../../utils/toast.es', '../management-toolbar/ManagementToolbar.es', '../management-toolbar/ManagementToolbarResultsBar.es', '../management-toolbar/SearchContext.es', '../table/TableWithPagination.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("app-builder-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _useQuery3 = _interopRequireDefault(require("../../hooks/useQuery.es"));

    var _useResource2 = _interopRequireDefault(require("../../hooks/useResource.es"));

    var _toast = require("../../utils/toast.es");

    var _ManagementToolbar = _interopRequireDefault(require("../management-toolbar/ManagementToolbar.es"));

    var _ManagementToolbarResultsBar = _interopRequireWildcard(require("../management-toolbar/ManagementToolbarResultsBar.es"));

    var _SearchContext = _interopRequireWildcard(require("../management-toolbar/SearchContext.es"));

    var _TableWithPagination = _interopRequireDefault(require("../table/TableWithPagination.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
      var actions = _ref.actions,
          addButton = _ref.addButton,
          children = _ref.children,
          columns = _ref.columns,
          editMode = _ref.editMode,
          emptyState = _ref.emptyState,
          endpoint = _ref.endpoint,
          _ref$filters = _ref.filters,
          filters = _ref$filters === void 0 ? [] : _ref$filters,
          history = _ref.history,
          noActionsMessage = _ref.noActionsMessage,
          queryParams = _ref.queryParams,
          scope = _ref.scope;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          _useContext$defaultDe = _useContext.defaultDelta,
          defaultDelta = _useContext$defaultDe === void 0 ? 20 : _useContext$defaultDe;

      var _useQuery = (0, _useQuery3["default"])(history, _objectSpread({
        filters: {},
        keywords: '',
        page: 1,
        pageSize: defaultDelta,
        sort: ''
      }, queryParams), scope),
          _useQuery2 = _slicedToArray(_useQuery, 2),
          query = _useQuery2[0],
          setQuery = _useQuery2[1];

      var dispatch = (0, _react.useCallback)(function (action) {
        return setQuery((0, _SearchContext.reducer)(query, action));
      }, [query, setQuery]);

      var params = _objectSpread({}, query, {}, query.filters);

      delete params.filters;

      var _useResource = (0, _useResource2["default"])({
        endpoint: endpoint,
        params: params
      }),
          error = _useResource.error,
          isLoading = _useResource.isLoading,
          refetch = _useResource.refetch,
          response = _useResource.response;

      var items = [];
      var totalCount = 0;
      var totalPages;

      if (response) {
        var _response$items = response.items;
        items = _response$items === void 0 ? [] : _response$items;
        totalCount = response.totalCount;
        totalPages = response.lastPage;
      }

      (0, _react.useEffect)(function () {
        if (totalPages && Number(query.page) > totalPages) {
          dispatch({
            page: totalPages,
            type: 'CHANGE_PAGE'
          });
        }
      }, [dispatch, query.page, totalPages]);
      (0, _react.useEffect)(function () {
        if (error) {
          (0, _toast.errorToast)();
        }
      }, [error]);
      var refetchOnActions;

      if (actions && actions.length > 0) {
        refetchOnActions = actions.map(function (_action) {
          if (!_action.action) {
            return _action;
          }

          return _objectSpread({}, _action, {
            action: function action(item) {
              _action.action(item, refetch).then(function (isRefetch) {
                if (!isRefetch) {
                  return;
                }

                refetch();
              });
            }
          });
        });
      }

      var selectedFilters = (0, _ManagementToolbarResultsBar.getSelectedFilters)(filters, query.filters);
      var isEmpty = totalCount === 0;
      var isFiltered = selectedFilters.length > 0;
      return _react["default"].createElement(_SearchContext["default"].Provider, {
        value: [query, dispatch]
      }, _react["default"].createElement(_ManagementToolbar["default"], {
        addButton: addButton,
        columns: columns,
        disabled: !isFiltered && !query.keywords && isEmpty,
        filters: filters,
        totalCount: totalCount
      }), _react["default"].createElement(_ManagementToolbarResultsBar["default"], {
        filters: filters,
        isLoading: isLoading,
        totalCount: totalCount
      }), _react["default"].createElement(_TableWithPagination["default"], {
        actions: refetchOnActions,
        columns: columns,
        editMode: editMode,
        emptyState: emptyState,
        isEmpty: isEmpty,
        isFiltered: isFiltered,
        isLoading: isLoading,
        items: items.map(function (item, index) {
          return children(item, index);
        }),
        keywords: query.keywords,
        noActionsMessage: noActionsMessage,
        totalCount: totalCount
      }));
    });

    exports["default"] = _default;
    //# sourceMappingURL=ListView.es.js.map
  }
});
//# sourceMappingURL=ListView.es.js.map