Liferay.Loader.define("app-builder-web@1.0.55/js/components/management-toolbar/ManagementToolbarResultsBar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/management-toolbar', 'frontend-js-react-web$react', '../../pages/apps/constants.es', '../../utils/lang.es', '../../utils/utils.es', '../button/Button.es', './SearchContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.getSelectedFilters = void 0;

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _managementToolbar = require("@frontend-taglib-clay$clayui/management-toolbar");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _constants = require("../../pages/apps/constants.es");

    var _lang = require("../../utils/lang.es");

    var _utils = require("../../utils/utils.es");

    var _Button = _interopRequireDefault(require("../button/Button.es"));

    var _SearchContext = _interopRequireDefault(require("./SearchContext.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var FilterItem = function FilterItem(_ref) {
      var filterKey = _ref.filterKey,
          name = _ref.name,
          value = _ref.value;

      var _useContext = (0, _react.useContext)(_SearchContext["default"]),
          _useContext2 = _slicedToArray(_useContext, 2),
          dispatch = _useContext2[1];

      return _react["default"].createElement(_managementToolbar.ClayResultsBar.Item, null, _react["default"].createElement(_label["default"], {
        className: "tbar-label",
        closeButtonProps: {
          onClick: function onClick() {
            return dispatch({
              filterKey: filterKey,
              type: 'REMOVE_FILTER'
            });
          }
        },
        displayType: "unstyled"
      }, _react["default"].createElement("span", {
        className: "label-section"
      }, "".concat(_constants.FILTER_NAMES[name][0], ": "), _react["default"].createElement("span", {
        className: "font-weight-normal"
      }, value))));
    };

    var getSelectedFilters = function getSelectedFilters(filters, appliedFilters) {
      var selectedFilters = [];
      Object.keys(appliedFilters).forEach(function (filterKey) {
        var filter = filters.find(function (_ref2) {
          var key = _ref2.key;
          return filterKey === key;
        });

        var _ref3 = filter || {},
            _ref3$items = _ref3.items,
            items = _ref3$items === void 0 ? [] : _ref3$items,
            key = _ref3.key,
            name = _ref3.name;

        var selectedItems = items.filter(function (_ref4) {
          var value = _ref4.value;
          return Array.isArray(appliedFilters[key]) ? appliedFilters[key].includes(value) : appliedFilters[key] === value;
        });
        var value = (0, _utils.concatValues)(selectedItems.map(function (_ref5) {
          var label = _ref5.label;
          return label;
        }));
        selectedFilters.push({
          filterKey: filterKey,
          name: name,
          value: value
        });
      });
      return selectedFilters;
    };

    exports.getSelectedFilters = getSelectedFilters;

    var _default = function _default(_ref6) {
      var _ref6$filters = _ref6.filters,
          filters = _ref6$filters === void 0 ? [] : _ref6$filters,
          isLoading = _ref6.isLoading,
          totalCount = _ref6.totalCount;

      var _useContext3 = (0, _react.useContext)(_SearchContext["default"]),
          _useContext4 = _slicedToArray(_useContext3, 2),
          _useContext4$ = _useContext4[0],
          _useContext4$$filters = _useContext4$.filters,
          appliedFilters = _useContext4$$filters === void 0 ? {} : _useContext4$$filters,
          keywords = _useContext4$.keywords,
          dispatch = _useContext4[1];

      var selectedFilters = getSelectedFilters(filters, appliedFilters);
      return _react["default"].createElement(_react["default"].Fragment, null, (keywords || selectedFilters.length > 0) && !isLoading && _react["default"].createElement(_managementToolbar.ClayResultsBar, null, _react["default"].createElement(_managementToolbar.ClayResultsBar.Item, null, _react["default"].createElement("span", {
        className: "component-text text-truncate-inline"
      }, _react["default"].createElement("span", {
        className: "text-truncate"
      }, (0, _lang.sub)(Liferay.Language.get('x-results-for-x'), [totalCount, keywords])))), selectedFilters.map(function (filter, key) {
        return _react["default"].createElement(FilterItem, _extends({
          key: key
        }, filter));
      }), _react["default"].createElement(_managementToolbar.ClayResultsBar.Item, {
        expand: true
      }, _react["default"].createElement("div", {
        className: "tbar-section text-right"
      }, _react["default"].createElement(_Button["default"], {
        className: "component-link tbar-link",
        displayType: "unstyled",
        onClick: function onClick() {
          return dispatch({
            type: 'CLEAR'
          });
        }
      }, Liferay.Language.get('clear-all'))))));
    };

    exports["default"] = _default;
    //# sourceMappingURL=ManagementToolbarResultsBar.es.js.map
  }
});
//# sourceMappingURL=ManagementToolbarResultsBar.es.js.map