Liferay.Loader.define("app-builder-web@1.0.55/js/components/popover/Popover.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-metal-web$metal-position', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './PopoverBase.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _metalPosition = require("frontend-js-metal-web$metal-position");

    var _propTypes = require("frontend-js-react-web$prop-types");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _PopoverBase = _interopRequireDefault(require("./PopoverBase.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var ALIGNMENTS_MAP = {
      bottom: _metalPosition.Align.Bottom,
      'bottom-left': _metalPosition.Align.BottomLeft,
      'bottom-right': _metalPosition.Align.BottomRight,
      left: _metalPosition.Align.Left,
      right: _metalPosition.Align.Right,
      top: _metalPosition.Align.Top,
      'top-left': _metalPosition.Align.TopLeft,
      'top-right': _metalPosition.Align.TopRight
    };
    var POSITIONS = ['top', 'top', 'right', 'bottom', 'bottom', 'bottom', 'left', 'top'];

    var getAlignPosition = function getAlignPosition(source, target, suggestedPosition) {
      if (!suggestedPosition) {
        suggestedPosition = 'top';
      }

      var position = _metalPosition.Align.align(source, target, ALIGNMENTS_MAP[suggestedPosition]);

      return POSITIONS[position];
    };

    var Popover = function Popover(_ref) {
      var alignElement = _ref.alignElement,
          className = _ref.className,
          content = _ref.content,
          footer = _ref.footer,
          forwardRef = _ref.forwardRef,
          showArrow = _ref.showArrow,
          suggestedPosition = _ref.suggestedPosition,
          title = _ref.title,
          visible = _ref.visible;

      var _useState = (0, _react.useState)({
        position: null,
        width: 240
      }),
          _useState2 = _slicedToArray(_useState, 2),
          state = _useState2[0],
          setState = _useState2[1];

      var position = state.position,
          width = state.width;
      (0, _react.useEffect)(function () {
        if (forwardRef && forwardRef.current) {
          var _width = forwardRef.current.offsetWidth;
          setState({
            width: _width
          });
        }
      }, [forwardRef]);
      (0, _react.useEffect)(function () {
        if (forwardRef && forwardRef.current && visible) {
          setState({
            position: getAlignPosition(forwardRef.current, alignElement, suggestedPosition)
          });
        }
      }, [alignElement, forwardRef, suggestedPosition, visible]);
      var withoutContent = !content;
      return _react["default"].createElement(_PopoverBase["default"], {
        className: (0, _classnames["default"])(className, {
          'no-content': withoutContent,
          'popover-large': width > 600
        }),
        forwardRef: forwardRef,
        placement: showArrow ? position : null,
        visible: visible
      }, title && (withoutContent ? _react["default"].createElement(_PopoverBase["default"].Body, null, title()) : _react["default"].createElement(_PopoverBase["default"].Header, null, title())), content && _react["default"].createElement(_PopoverBase["default"].Body, null, content()), footer && _react["default"].createElement(_PopoverBase["default"].Footer, null, footer()));
    };

    var _default = _react["default"].forwardRef(function (props, ref) {
      return _react["default"].createElement(Popover, _extends({}, props, {
        forwardRef: ref
      }));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Popover.es.js.map
  }
});
//# sourceMappingURL=Popover.es.js.map