Liferay.Loader.define("app-builder-web@1.0.55/js/components/table/EmptyState.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../utils/lang.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.withEmpty = exports.SearchAndFilteredEmpty = exports.SearchEmpty = exports.FilteredEmpty = void 0;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _lang = require("../../utils/lang.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    var DEFAULT_EMPTY = {
      empty: {
        className: 'taglib-empty-state',
        title: Liferay.Language.get('there-are-no-entries')
      },
      search: {
        className: 'taglib-search-state',
        title: Liferay.Language.get('no-results-were-found')
      }
    };

    var EmptyState = function EmptyState(_ref) {
      var button = _ref.button,
          _ref$className = _ref.className,
          className = _ref$className === void 0 ? DEFAULT_EMPTY.empty.className : _ref$className,
          description = _ref.description,
          _ref$title = _ref.title,
          title = _ref$title === void 0 ? DEFAULT_EMPTY.empty.title : _ref$title;
      return _react["default"].createElement("div", {
        className: "taglib-empty-result-message"
      }, _react["default"].createElement("div", {
        className: "text-center"
      }, _react["default"].createElement("div", {
        className: className
      }), title && _react["default"].createElement("h1", {
        className: "taglib-empty-result-message-title"
      }, title), description && _react["default"].createElement("p", {
        className: "empty-message-color taglib-empty-result-message-description"
      }, description), button && button()));
    };

    var FilteredEmpty = function FilteredEmpty(props) {
      var description = Liferay.Language.get('there-are-no-results-with-these-attributes');
      return _react["default"].createElement(EmptyState, _extends({
        description: description
      }, props));
    };

    exports.FilteredEmpty = FilteredEmpty;

    var SearchEmpty = function SearchEmpty(_ref2) {
      var keywords = _ref2.keywords,
          otherProps = _objectWithoutProperties(_ref2, ["keywords"]);

      var description = (0, _lang.sub)(Liferay.Language.get('there-are-no-results-for-x'), [keywords]);
      return _react["default"].createElement(EmptyState, _extends({
        description: description
      }, otherProps));
    };

    exports.SearchEmpty = SearchEmpty;

    var SearchAndFilteredEmpty = function SearchAndFilteredEmpty(_ref3) {
      var keywords = _ref3.keywords,
          otherProps = _objectWithoutProperties(_ref3, ["keywords"]);

      var description = (0, _lang.sub)(Liferay.Language.get('there-are-no-results-for-x-with-these-attributes'), [keywords]);
      return _react["default"].createElement(EmptyState, _extends({
        description: description
      }, otherProps));
    };

    exports.SearchAndFilteredEmpty = SearchAndFilteredEmpty;

    var withEmpty = function withEmpty(Component) {
      var Wrapper = function Wrapper(_ref4) {
        var emptyState = _ref4.emptyState,
            isEmpty = _ref4.isEmpty,
            isFiltered = _ref4.isFiltered,
            keywords = _ref4.keywords,
            restProps = _objectWithoutProperties(_ref4, ["emptyState", "isEmpty", "isFiltered", "keywords"]);

        if (isEmpty) {
          if (keywords.length) {
            if (isFiltered) {
              return _react["default"].createElement(SearchAndFilteredEmpty, _extends({
                keywords: keywords
              }, DEFAULT_EMPTY.search, emptyState.searchAndFiltered));
            }

            return _react["default"].createElement(SearchEmpty, _extends({
              keywords: keywords
            }, DEFAULT_EMPTY.search, emptyState.search));
          }

          if (isFiltered) {
            return _react["default"].createElement(FilteredEmpty, _extends({}, DEFAULT_EMPTY.search, emptyState.filtered));
          }

          return _react["default"].createElement(EmptyState, emptyState);
        }

        return _react["default"].createElement(Component, restProps);
      };

      return Wrapper;
    };

    exports.withEmpty = withEmpty;
    var _default = EmptyState;
    exports["default"] = _default;
    //# sourceMappingURL=EmptyState.es.js.map
  }
});
//# sourceMappingURL=EmptyState.es.js.map