Liferay.Loader.define("app-builder-web@1.0.55/js/components/table/Table.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/table', 'frontend-js-react-web$react', './DropDown.es', './EditableCell.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _DropDown = _interopRequireDefault(require("./DropDown.es"));

    var _EditableCell = _interopRequireDefault(require("./EditableCell.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    var Body = _table["default"].Body,
        Cell = _table["default"].Cell,
        Head = _table["default"].Head,
        Row = _table["default"].Row;

    var CellWrapper = function CellWrapper(_ref) {
      var children = _ref.children,
          _ref$colSpan = _ref.colSpan,
          colSpan = _ref$colSpan === void 0 ? 1 : _ref$colSpan,
          fieldAlign = _ref.fieldAlign,
          index = _ref.index;
      return _react["default"].createElement(Cell, {
        align: index === 0 ? 'left' : fieldAlign,
        className: index > 0 && 'table-cell-expand-smaller',
        colSpan: colSpan,
        expanded: index === 0,
        headingTitle: index === 0,
        key: index
      }, children);
    };

    var Table = function Table(_ref2) {
      var actions = _ref2.actions,
          _ref2$align = _ref2.align,
          align = _ref2$align === void 0 ? 'left' : _ref2$align,
          checkable = _ref2.checkable,
          columns = _ref2.columns,
          editMode = _ref2.editMode,
          forwardRef = _ref2.forwardRef,
          items = _ref2.items,
          noActionsMessage = _ref2.noActionsMessage;
      return _react["default"].createElement("div", {
        ref: forwardRef
      }, _react["default"].createElement(_table["default"], {
        hover: false
      }, _react["default"].createElement(Head, null, _react["default"].createElement(Row, null, checkable && _react["default"].createElement(Cell, {
        headingCell: true
      }), columns.map(function (column, index) {
        return _react["default"].createElement(Cell, {
          align: index === 0 ? 'left' : align,
          className: index > 0 && 'table-cell-expand-smaller',
          expanded: index === 0,
          headingCell: true,
          key: index
        }, column.value);
      }), actions && _react["default"].createElement(Cell, {
        headingCell: true
      }))), _react["default"].createElement(Body, null, items.map(function (item, index) {
        var isEditMode = editMode && editMode.id === item.id;
        return _react["default"].createElement(Row, {
          key: index
        }, checkable && _react["default"].createElement(Cell, null, _react["default"].createElement(_form.ClayCheckbox, {
          checked: false,
          disabled: false,
          indeterminate: false,
          onChange: function onChange() {}
        })), isEditMode ? _react["default"].createElement(_EditableCell["default"], {
          Cell: CellWrapper,
          columns: columns,
          editMode: editMode,
          item: item
        }) : columns.map(function (column, index) {
          return _react["default"].createElement(CellWrapper, {
            fieldAlign: align,
            index: index,
            key: index
          }, item[column.key]);
        }), actions && !isEditMode && _react["default"].createElement(Cell, null, _react["default"].createElement(_DropDown["default"], {
          actions: actions,
          item: item,
          noActionsMessage: noActionsMessage
        })));
      }))));
    };

    var _default = _react["default"].forwardRef(function (props, ref) {
      return _react["default"].createElement(Table, _extends({}, props, {
        forwardRef: ref
      }));
    });

    exports["default"] = _default;
    //# sourceMappingURL=Table.es.js.map
  }
});
//# sourceMappingURL=Table.es.js.map