Liferay.Loader.define("app-builder-web@1.0.55/js/hooks/useDataListView.es", ['module', 'exports', 'require', 'data-engine-taglib', 'frontend-js-react-web$react', '../utils/client.es', '../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = useDataListView;

    var _dataEngineTaglib = require("data-engine-taglib");

    var _react = require("frontend-js-react-web$react");

    var _client = require("../utils/client.es");

    var _toast = require("../utils/toast.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function useDataListView(dataListViewId, dataDefinitionId) {
      var _useState = (0, _react.useState)({
        columns: [],
        dataDefinition: null,
        dataListView: {
          fieldNames: []
        },
        isLoading: true
      }),
          _useState2 = _slicedToArray(_useState, 2),
          state = _useState2[0],
          setState = _useState2[1];

      (0, _react.useEffect)(function () {
        Promise.all([(0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId)), (0, _client.getItem)("/o/data-engine/v2.0/data-list-views/".concat(dataListViewId))]).then(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              dataDefinition = _ref2[0],
              dataListView = _ref2[1];

          setState(function (prevState) {
            return _objectSpread({}, prevState, {
              columns: dataListView.fieldNames.map(function (column) {
                var _DataDefinitionUtils$ = _dataEngineTaglib.DataDefinitionUtils.getDataDefinitionField(dataDefinition, column),
                    value = _DataDefinitionUtils$.label;

                return {
                  key: 'dataRecordValues/' + column,
                  sortable: true,
                  value: value
                };
              }),
              dataDefinition: _objectSpread({}, prevState.dataDefinition, {}, dataDefinition),
              dataListView: _objectSpread({}, prevState.dataListView, {}, dataListView),
              isLoading: false
            });
          });
        })["catch"](function () {
          setState(function (prevState) {
            return _objectSpread({}, prevState, {
              isLoading: false
            });
          });
          (0, _toast.errorToast)();
        });
      }, [dataDefinitionId, dataListViewId]);
      return state;
    }
    //# sourceMappingURL=useDataListView.es.js.map
  }
});
//# sourceMappingURL=useDataListView.es.js.map