Liferay.Loader.define("app-builder-web@1.0.55/js/hooks/withDDMForm.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useDDMFormSubmit = useDDMFormSubmit;
    exports.useDDMFormValidation = useDDMFormValidation;
    exports["default"] = withDDMForm;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function useDDMFormSubmit(ddmForm, onSubmit) {
      (0, _react.useEffect)(function () {
        var formNode = ddmForm.reactComponentRef.current.getFormNode();
        formNode.addEventListener('submit', onSubmit);
        return function () {
          return formNode.removeEventListener('submit', onSubmit);
        };
      }, [ddmForm, onSubmit]);
    }

    function useDDMFormValidation(ddmForm, languageId, availableLanguageIds) {
      return (0, _react.useCallback)(function (event) {
        return new Promise(function (resolve, reject) {
          if (typeof event.stopImmediatePropagation === 'function') {
            event.stopImmediatePropagation();
          }

          var ddmReactForm = ddmForm.reactComponentRef.current;
          ddmReactForm.validate().then(function (isValidForm) {
            if (!isValidForm) {
              return reject();
            }

            var dataRecordValues = {};
            var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(ddmReactForm.get('pages'));

            visitor.mapFields(function setDataRecord(_ref) {
              var fieldName = _ref.fieldName,
                  repeatable = _ref.repeatable,
                  type = _ref.type,
                  value = _ref.value,
                  visible = _ref.visible;

              if (type === 'fieldset') {
                return;
              }

              if (!visible) {
                value = '';
              }

              if (!dataRecordValues[fieldName]) {
                dataRecordValues[fieldName] = _defineProperty({}, languageId, []);
              }

              if (repeatable) {
                dataRecordValues[fieldName][languageId].push(value);
              } else {
                dataRecordValues[fieldName] = _defineProperty({}, languageId, value);
              }

              availableLanguageIds.forEach(function (key) {
                dataRecordValues[fieldName][key] = dataRecordValues[fieldName][languageId];
              });
            }, true, true);
            resolve({
              dataRecordValues: dataRecordValues
            });
          })["catch"](reject);
        });
      }, [availableLanguageIds, ddmForm.reactComponentRef, languageId]);
    }

    function withDDMForm(Component) {
      return function (_ref2) {
        var containerElementId = _ref2.containerElementId,
            props = _objectWithoutProperties(_ref2, ["containerElementId"]);

        var _useState = (0, _react.useState)(),
            _useState2 = _slicedToArray(_useState, 2),
            ddmForm = _useState2[0],
            setDDMForm = _useState2[1];

        if (!ddmForm) {
          Liferay.componentReady(containerElementId).then(setDDMForm);
        }

        return ddmForm ? _react["default"].createElement(Component, _extends({
          ddmForm: ddmForm
        }, props)) : null;
      };
    }
    //# sourceMappingURL=withDDMForm.es.js.map
  }
});
//# sourceMappingURL=withDDMForm.es.js.map