Liferay.Loader.define("app-builder-web@1.0.55/js/pages/apps/ListApps.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/label', 'app-builder-web$path-to-regexp', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../hooks/useBackUrl.es', '../../hooks/useDataDefinition.es', '../../hooks/useDeployApp.es', '../../utils/client.es', '../../utils/lang.es', '../../utils/time.es', '../../utils/utils.es', './constants.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.Actions = void 0;

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _pathToRegexp = require("app-builder-web$path-to-regexp");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("app-builder-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

    var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

    var _useBackUrl = _interopRequireDefault(require("../../hooks/useBackUrl.es"));

    var _useDataDefinition2 = _interopRequireDefault(require("../../hooks/useDataDefinition.es"));

    var _useDeployApp2 = _interopRequireDefault(require("../../hooks/useDeployApp.es"));

    var _client = require("../../utils/client.es");

    var _lang = require("../../utils/lang.es");

    var _time = require("../../utils/time.es");

    var _utils = require("../../utils/utils.es");

    var _constants = require("./constants.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var Actions = function Actions() {
      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          getStandaloneURL = _useContext.getStandaloneURL;

      var _useDeployApp = (0, _useDeployApp2["default"])(),
          deployApp = _useDeployApp.deployApp,
          undeployApp = _useDeployApp.undeployApp;

      return [{
        action: function action(app) {
          return app.active ? undeployApp(app) : deployApp(app);
        },
        name: function name(_ref) {
          var active = _ref.active;
          return _constants.DEPLOYMENT_ACTION[active ? 'undeploy' : 'deploy'];
        },
        show: function show(_ref2) {
          var appDeployments = _ref2.appDeployments;
          return appDeployments.length > 0;
        }
      }, {
        action: function action(_ref3) {
          var id = _ref3.id;
          return Promise.resolve(window.open(getStandaloneURL(id), '_blank'));
        },
        name: Liferay.Language.get('open-standalone-app'),
        show: function show(_ref4) {
          var active = _ref4.active,
              appDeployments = _ref4.appDeployments;
          return active && appDeployments.some(function (_ref5) {
            var type = _ref5.type;
            return type === 'standalone';
          });
        }
      }, {
        action: (0, _client.confirmDelete)('/o/app-builder/v1.0/apps/'),
        name: Liferay.Language.get('delete')
      }];
    };

    exports.Actions = Actions;

    var _default = function _default(_ref6) {
      var _ref6$editPath = _ref6.editPath,
          editPath = _ref6$editPath === void 0 ? ["/:objectType/:dataDefinitionId(\\d+)/apps/deploy", "/:objectType/:dataDefinitionId(\\d+)/apps/:appId(\\d+)"] : _ref6$editPath,
          _ref6$listViewProps = _ref6.listViewProps,
          listViewProps = _ref6$listViewProps === void 0 ? {} : _ref6$listViewProps,
          _ref6$match$params = _ref6.match.params,
          dataDefinitionId = _ref6$match$params.dataDefinitionId,
          objectType = _ref6$match$params.objectType;

      var _useContext2 = (0, _react.useContext)(_AppContext.AppContext),
          scope = _useContext2.scope;

      var withBackUrl = (0, _useBackUrl["default"])();

      var _useDataDefinition = (0, _useDataDefinition2["default"])(dataDefinitionId),
          _useDataDefinition$de = _useDataDefinition.defaultLanguageId,
          defaultLanguageId = _useDataDefinition$de === void 0 ? themeDisplay.getDefaultLanguageId() : _useDataDefinition$de;

      var newAppLink = (0, _pathToRegexp.compile)(editPath[0])({
        dataDefinitionId: dataDefinitionId,
        objectType: objectType
      });

      var EMPTY_STATE = {
        button: function button() {
          return _react["default"].createElement(_Button["default"], {
            displayType: "secondary",
            href: newAppLink
          }, Liferay.Language.get('new-app'));
        },
        description: Liferay.Language.get('select-the-form-and-table-view-you-want-and-deploy-your-app-as-a-widget-standalone-or-place-it-in-the-product-menu'),
        title: Liferay.Language.get('there-are-no-apps-yet')
      };
      var ENDPOINT = "/o/app-builder/v1.0/data-definitions/".concat(dataDefinitionId, "/apps?scope=").concat(scope);

      var getEditAppUrl = function getEditAppUrl(_ref7) {
        var dataDefinitionId = _ref7.dataDefinitionId,
            id = _ref7.id;
        return withBackUrl((0, _pathToRegexp.compile)(editPath[1])({
          appId: id,
          dataDefinitionId: dataDefinitionId,
          objectType: objectType
        }));
      };

      return _react["default"].createElement(_ListView["default"], _extends({
        actions: Actions(),
        addButton: function ADD_BUTTON() {
          return _react["default"].createElement(_Button["default"], {
            className: "nav-btn nav-btn-monospaced",
            href: newAppLink,
            symbol: "plus",
            tooltip: Liferay.Language.get('new-app')
          });
        },
        columns: _constants.COLUMNS,
        emptyState: EMPTY_STATE,
        endpoint: ENDPOINT
      }, listViewProps), function (app) {
        var appName = (0, _lang.getLocalizedValue)(defaultLanguageId, app.name);
        return _objectSpread({}, app, {
          appName: appName,
          dateCreated: (0, _time.fromNow)(app.dateCreated),
          dateModified: (0, _time.fromNow)(app.dateModified),
          name: _react["default"].createElement(_reactRouterDom.Link, {
            to: getEditAppUrl(app)
          }, appName),
          status: _react["default"].createElement(_label["default"], {
            displayType: app.active ? 'success' : 'secondary'
          }, _constants.STATUSES[app.active ? 'active' : 'inactive']),
          type: (0, _utils.concatValues)(app.appDeployments.map(function (_ref8) {
            var type = _ref8.type;
            return _constants.DEPLOYMENT_TYPES[type];
          }))
        });
      });
    };

    exports["default"] = _default;
    //# sourceMappingURL=ListApps.es.js.map
  }
});
//# sourceMappingURL=ListApps.es.js.map