Liferay.Loader.define("app-builder-web@1.0.55/js/pages/apps/SelectObjectsDropDown.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/link', 'frontend-js-react-web$react', '../../AppContext.es', '../../utils/client.es', '../../utils/lang.es', './DropDownWithSearch.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getDataObjects = getDataObjects;
    exports["default"] = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../../AppContext.es");

    var _client = require("../../utils/client.es");

    var _lang = require("../../utils/lang.es");

    var _DropDownWithSearch = _interopRequireDefault(require("./DropDownWithSearch.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function getDataObjects() {
      return (0, _client.getItem)('/o/data-engine/v2.0/data-definitions/by-content-type/app-builder', {
        keywords: '',
        page: -1,
        pageSize: -1,
        sort: ''
      }).then(function (_ref) {
        var items = _ref.items;
        return items.map(function (item) {
          return _objectSpread({}, item, {
            name: (0, _lang.getLocalizedValue)(item.defaultLanguageId, item.name),
            type: 'custom'
          });
        });
      });
    }

    var _default = function _default(_ref2) {
      var defaultValue = _ref2.defaultValue,
          label = _ref2.label,
          onSelect = _ref2.onSelect,
          selectedValue = _ref2.selectedValue,
          visible = _ref2.visible;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          objectsPortletURL = _useContext.objectsPortletURL;

      var _useState = (0, _react.useState)({
        error: null,
        isLoading: true
      }),
          _useState2 = _slicedToArray(_useState, 2),
          state = _useState2[0],
          setState = _useState2[1];

      var _useState3 = (0, _react.useState)([]),
          _useState4 = _slicedToArray(_useState3, 2),
          items = _useState4[0],
          setItems = _useState4[1];

      var doFetch = function doFetch() {
        setState({
          error: null,
          isLoading: true
        });
        getDataObjects().then(function (items) {
          setItems(items);
          setState({
            error: null,
            isLoading: false
          });

          if (defaultValue) {
            var defaultItem = items.find(function (_ref3) {
              var id = _ref3.id;
              return id === defaultValue;
            });

            if (defaultItem) {
              onSelect(defaultItem);
            }
          }
        })["catch"](function (error) {
          setState({
            error: error,
            isLoading: false
          });
        });
      };

      var getMessageWithNewObjectLink = function getMessageWithNewObjectLink(message) {
        return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("span", {
          className: "d-block"
        }, message), _react["default"].createElement(_link["default"], {
          href: "".concat(objectsPortletURL, "#/?showCustomObjectPopover=1"),
          target: "_blank"
        }, Liferay.Language.get('create-new-object'), ' ', _react["default"].createElement(_icon["default"], {
          fontSize: "10px",
          symbol: "shortcut"
        })));
      };

      (0, _react.useEffect)(function () {
        doFetch(); // eslint-disable-next-line react-hooks/exhaustive-deps
      }, []);
      var stateProps = {
        emptyProps: {
          label: getMessageWithNewObjectLink(Liferay.Language.get('there-are-no-objects-yet'))
        },
        errorProps: {
          children: _react["default"].createElement(_button["default"], {
            displayType: "link",
            onClick: doFetch,
            small: true
          }, Liferay.Language.get('retry')),
          label: Liferay.Language.get('unable-to-retrieve-the-objects')
        },
        loadingProps: {
          label: Liferay.Language.get('retrieving-all-objects')
        }
      };
      var labelProps = {
        custom: {
          displayType: 'success',
          label: Liferay.Language.get('custom')
        },
        "native": {
          displayType: 'info',
          label: Liferay.Language.get('native')
        }
      };

      var ItemWithLabel = function ItemWithLabel(_ref4) {
        var name = _ref4.name,
            type = _ref4.type;
        var itemName = name || label;
        return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("span", {
          className: "float-left text-left text-truncate w50",
          title: itemName
        }, itemName), type && _react["default"].createElement(_label["default"], {
          className: "dropdown-button-asset float-right",
          displayType: labelProps[type].displayType
        }, labelProps[type].label));
      };

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_DropDownWithSearch["default"], _extends({}, state, {
        isEmpty: items.length === 0,
        label: label,
        stateProps: stateProps,
        trigger: _react["default"].createElement(_button["default"], {
          "aria-labelledby": "select-object-label",
          className: "clearfix w-100",
          displayType: "secondary"
        }, _react["default"].createElement(_icon["default"], {
          className: "dropdown-button-asset float-right ml-1",
          symbol: "caret-bottom"
        }), _react["default"].createElement(ItemWithLabel, selectedValue)),
        visible: visible
      }), _react["default"].createElement(_DropDownWithSearch["default"].Items, {
        emptyResultMessage: getMessageWithNewObjectLink(Liferay.Language.get('there-were-no-objects-found-with-this-name')),
        items: items,
        onSelect: onSelect
      }, ItemWithLabel)));
    };

    exports["default"] = _default;
    //# sourceMappingURL=SelectObjectsDropDown.es.js.map
  }
});
//# sourceMappingURL=SelectObjectsDropDown.es.js.map