Liferay.Loader.define("app-builder-web@1.0.55/js/pages/apps/edit/ListItems.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/table', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../../components/loading/Loading.es', '../../../components/table/EmptyState.es', '../../../utils/lang.es', '../../../utils/time.es', './EditAppContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Loading = require("../../../components/loading/Loading.es");

    var _EmptyState = require("../../../components/table/EmptyState.es");

    var _lang = require("../../../utils/lang.es");

    var _time = require("../../../utils/time.es");

    var _EditAppContext = _interopRequireWildcard(require("./EditAppContext.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var Body = _table["default"].Body,
        Cell = _table["default"].Cell,
        Head = _table["default"].Head,
        Row = _table["default"].Row;

    var ListItems = function ListItems(_ref) {
      var defaultLanguageId = _ref.defaultLanguageId,
          itemType = _ref.itemType,
          items = _ref.items;

      var _useContext = (0, _react.useContext)(_EditAppContext["default"]),
          dispatch = _useContext.dispatch,
          _useContext$state$app = _useContext.state.app,
          dataLayoutId = _useContext$state$app.dataLayoutId,
          dataListViewId = _useContext$state$app.dataListViewId;

      var itemId = itemType === 'DATA_LAYOUT' ? dataLayoutId : dataListViewId;

      var onItemIdChange = function onItemIdChange(id) {
        var type = itemType === 'DATA_LAYOUT' ? _EditAppContext.UPDATE_DATA_LAYOUT_ID : _EditAppContext.UPDATE_DATA_LIST_VIEW_ID;
        dispatch({
          id: id,
          type: type
        });
      };

      return _react["default"].createElement("table", {
        className: "table table-autofit table-heading-nowrap table-hover table-nowrap table-responsive"
      }, _react["default"].createElement(Head, null, _react["default"].createElement(Row, null, _react["default"].createElement(Cell, {
        expanded: true,
        headingCell: true
      }, Liferay.Language.get('name')), _react["default"].createElement(Cell, {
        headingCell: true
      }, Liferay.Language.get('create-date')), _react["default"].createElement(Cell, {
        headingCell: true
      }, Liferay.Language.get('modified-date')), _react["default"].createElement(Cell, {
        headingCell: true
      }))), _react["default"].createElement(Body, null, items.map(function (_ref2, index) {
        var dateCreated = _ref2.dateCreated,
            dateModified = _ref2.dateModified,
            id = _ref2.id,
            name = _ref2.name;
        return _react["default"].createElement(Row, {
          className: (0, _classnames["default"])('selectable-row', {
            'selectable-active': id === itemId
          }),
          key: index,
          onClick: function onClick() {
            return onItemIdChange(id);
          }
        }, _react["default"].createElement(Cell, {
          align: "left"
        }, (0, _lang.getLocalizedValue)(defaultLanguageId, name)), _react["default"].createElement(Cell, null, (0, _time.fromNow)(dateCreated)), _react["default"].createElement(Cell, null, (0, _time.fromNow)(dateModified)), _react["default"].createElement(Cell, {
          align: 'right'
        }, _react["default"].createElement(_form.ClayRadioGroup, {
          inline: true,
          onSelectedValueChange: function onSelectedValueChange() {
            return onItemIdChange(id);
          },
          selectedValue: itemId
        }, _react["default"].createElement(_form.ClayRadio, {
          value: id
        }))));
      })));
    };

    var _default = (0, _Loading.withLoading)((0, _EmptyState.withEmpty)(ListItems));

    exports["default"] = _default;
    //# sourceMappingURL=ListItems.es.js.map
  }
});
//# sourceMappingURL=ListItems.es.js.map