Liferay.Loader.define("app-builder-web@1.0.55/js/pages/entry/ListEntries.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../AppContext.es', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../components/loading/Loading.es', '../../hooks/useDataListView.es', '../../hooks/useEntriesActions.es', '../../hooks/usePermissions.es', '../../utils/lang.es', './utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = ListEntries;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../../AppContext.es");

    var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

    var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

    var _Loading = require("../../components/loading/Loading.es");

    var _useDataListView2 = _interopRequireDefault(require("../../hooks/useDataListView.es"));

    var _useEntriesActions = _interopRequireDefault(require("../../hooks/useEntriesActions.es"));

    var _usePermissions = _interopRequireDefault(require("../../hooks/usePermissions.es"));

    var _lang = require("../../utils/lang.es");

    var _utils = require("./utils.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function ListEntries() {
      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          appId = _useContext.appId,
          basePortletURL = _useContext.basePortletURL,
          dataDefinitionId = _useContext.dataDefinitionId,
          dataListViewId = _useContext.dataListViewId,
          showFormView = _useContext.showFormView,
          userLanguageId = _useContext.userLanguageId;

      var _useDataListView = (0, _useDataListView2["default"])(dataListViewId, dataDefinitionId),
          columns = _useDataListView.columns,
          dataDefinition = _useDataListView.dataDefinition,
          fieldNames = _useDataListView.dataListView.fieldNames,
          isLoading = _useDataListView.isLoading;

      var permissions = (0, _usePermissions["default"])();
      var formColumns = columns.map(function (_ref) {
        var value = _ref.value,
            column = _objectWithoutProperties(_ref, ["value"]);

        return _objectSpread({}, column, {
          value: (0, _lang.getLocalizedUserPreferenceValue)(value, userLanguageId, dataDefinition.defaultLanguageId)
        });
      });
      var portletParams = {
        languageId: userLanguageId
      };
      return _react["default"].createElement(_Loading.Loading, {
        isLoading: isLoading
      }, _react["default"].createElement(_ListView["default"], {
        actions: (0, _useEntriesActions["default"])(),
        addButton: function addButton() {
          return showFormView && permissions.add && _react["default"].createElement(_Button["default"], {
            className: "nav-btn nav-btn-monospaced",
            onClick: function onClick() {
              return (0, _utils.navigateToEditPage)(basePortletURL, portletParams);
            },
            symbol: "plus",
            tooltip: Liferay.Language.get('new-entry')
          });
        },
        columns: formColumns,
        emptyState: {
          button: function button() {
            return showFormView && permissions.add && _react["default"].createElement(_Button["default"], {
              displayType: "secondary",
              onClick: function onClick() {
                return (0, _utils.navigateToEditPage)(basePortletURL, portletParams);
              }
            }, Liferay.Language.get('new-entry'));
          },
          title: Liferay.Language.get('there-are-no-entries-yet')
        },
        endpoint: "/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-records"),
        noActionsMessage: Liferay.Language.get('you-do-not-have-the-permission-to-manage-this-entry'),
        queryParams: {
          dataListViewId: dataListViewId
        },
        scope: appId
      }, (0, _utils.buildEntries)({
        dataDefinition: dataDefinition,
        fieldNames: fieldNames,
        permissions: permissions,
        scope: appId
      })));
    }
    //# sourceMappingURL=ListEntries.es.js.map
  }
});
//# sourceMappingURL=ListEntries.es.js.map