Liferay.Loader.define("app-builder-web@1.0.55/js/pages/form-view/CustomObjectFieldsList.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'data-engine-taglib', 'frontend-js-react-web$react', '../../hooks/useDoubleClick.es', '../../utils/findFieldByName.es', './DataLayoutBuilderInstanceContext.es', './FormViewContext.es', './useDeleteDefinitionField.es', './useDeleteDefinitionFieldModal.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _dataEngineTaglib = require("data-engine-taglib");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _useDoubleClick3 = _interopRequireDefault(require("../../hooks/useDoubleClick.es"));

    var _findFieldByName2 = require("../../utils/findFieldByName.es");

    var _DataLayoutBuilderInstanceContext = _interopRequireDefault(require("./DataLayoutBuilderInstanceContext.es"));

    var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

    var _useDeleteDefinitionField = _interopRequireDefault(require("./useDeleteDefinitionField.es"));

    var _useDeleteDefinitionFieldModal = _interopRequireDefault(require("./useDeleteDefinitionFieldModal.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var createFieldSet = function createFieldSet(_ref) {
      var name = _ref.name,
          nestedDataDefinitionFields = _ref.nestedDataDefinitionFields,
          otherProps = _objectWithoutProperties(_ref, ["name", "nestedDataDefinitionFields"]);

      var defaultLanguageId = Liferay.ThemeDisplay.getDefaultLanguageId();
      return _objectSpread({}, otherProps, {
        availableLanguageIds: [defaultLanguageId],
        dataDefinitionFields: nestedDataDefinitionFields,
        defaultLanguageId: defaultLanguageId,
        description: {},
        name: name
      });
    };

    var getFieldSet = function getFieldSet(_ref2) {
      var customProperties = _ref2.customProperties,
          fieldSets = _ref2.fieldSets,
          name = _ref2.name,
          otherProps = _objectWithoutProperties(_ref2, ["customProperties", "fieldSets", "name"]);

      var fieldSet = fieldSets.find(function (_ref3) {
        var id = _ref3.id;
        return id === Number(customProperties.ddmStructureId);
      });

      if (fieldSet) {
        return _objectSpread({}, fieldSet, {
          name: name
        });
      }

      return createFieldSet(_objectSpread({
        customProperties: customProperties,
        name: name
      }, otherProps));
    };

    var getFieldTypes = function getFieldTypes(_ref4) {
      var dataDefinition = _ref4.dataDefinition,
          dataLayout = _ref4.dataLayout,
          editingLanguageId = _ref4.editingLanguageId,
          fieldSets = _ref4.fieldSets,
          fieldTypes = _ref4.fieldTypes,
          focusedCustomObjectField = _ref4.focusedCustomObjectField;
      var customDataDefinitionFields = [];
      var nativeDataDefinitionFields = [];
      var dataLayoutPages = dataLayout.dataLayoutPages;
      var fields = dataDefinition.dataDefinitionFields,
          defaultLanguageId = dataDefinition.defaultLanguageId;

      var setDefinitionField = function setDefinitionField(_ref5, nested) {
        var customProperties = _ref5.customProperties,
            fieldType = _ref5.fieldType,
            label = _ref5.label,
            name = _ref5.name,
            _ref5$nestedDataDefin = _ref5.nestedDataDefinitionFields,
            nestedDataDefinitionFields = _ref5$nestedDataDefin === void 0 ? [] : _ref5$nestedDataDefin,
            repeatable = _ref5.repeatable,
            showLabel = _ref5.showLabel;
        var ddmStructureId = customProperties.ddmStructureId;

        if (fieldType === 'section') {
          return;
        }

        var fieldTypeSettings = fieldTypes.find(function (_ref6) {
          var name = _ref6.name;
          return name === fieldType;
        });
        var isFieldGroup = fieldType === 'fieldset';
        var isFieldSet = isFieldGroup && ddmStructureId;
        var FieldTypeLabel = isFieldSet ? Liferay.Language.get('fieldset') : fieldTypeSettings.label;

        var dataDefinitionField = _objectSpread({
          active: name === focusedCustomObjectField.name,
          className: nested ? 'custom-object-field-children' : 'custom-object-field',
          description: function getDescription() {
            var description = '';

            if (isFieldGroup && !nested) {
              description = "- ".concat(nestedDataDefinitionFields.length, " ").concat(Liferay.Language.get('fields'));
            }

            return "".concat(FieldTypeLabel, " ").concat(description);
          }(),
          disabled: _dataEngineTaglib.DataLayoutVisitor.containsField(dataLayoutPages, name),
          dragAlignment: 'right',
          dragType: isFieldGroup ? _dataEngineTaglib.DragTypes.DRAG_FIELDSET : _dataEngineTaglib.DragTypes.DRAG_DATA_DEFINITION_FIELD,
          icon: fieldTypeSettings.icon,
          isCustomField: !customProperties['nativeField'],
          isFieldSet: isFieldSet
        }, isFieldGroup && {
          fieldSet: getFieldSet({
            customProperties: customProperties,
            fieldSets: fieldSets,
            name: label,
            nestedDataDefinitionFields: nestedDataDefinitionFields
          }),
          properties: {
            collapsible: customProperties.collapsible,
            repeatable: repeatable,
            showLabel: showLabel
          },
          useFieldName: name
        }, {
          label: label[editingLanguageId] || label[defaultLanguageId],
          name: name,
          nestedDataDefinitionFields: nestedDataDefinitionFields.map(function (nestedField) {
            return setDefinitionField(nestedField, true);
          })
        });

        if (nested) {
          return dataDefinitionField;
        }

        if (dataDefinitionField.isCustomField) {
          customDataDefinitionFields.push(dataDefinitionField);
        } else {
          nativeDataDefinitionFields.push(dataDefinitionField);
        }
      };

      fields.forEach(function (fieldType) {
        setDefinitionField(fieldType);
      });
      return [customDataDefinitionFields, nativeDataDefinitionFields];
    };

    var FieldCategory = function FieldCategory(_ref7) {
      var categoryName = _ref7.categoryName;
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('custom-object-sidebar-header', 'ml-1 pt-2 pb-2')
      }, _react["default"].createElement("div", {
        className: "autofit-row autofit-row-center"
      }, _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
        className: "autofit-col autofit-col-expand"
      }, _react["default"].createElement("h3", {
        className: "category-text"
      }, categoryName)))));
    };

    var _default = function _default(_ref8) {
      var keywords = _ref8.keywords;

      var _useContext = (0, _react.useContext)(_DataLayoutBuilderInstanceContext["default"]),
          _useContext2 = _slicedToArray(_useContext, 1),
          dataLayoutBuilder = _useContext2[0];

      var _useContext3 = (0, _react.useContext)(_FormViewContext["default"]),
          _useContext4 = _slicedToArray(_useContext3, 2),
          state = _useContext4[0],
          dispatch = _useContext4[1];

      var dataDefinition = state.dataDefinition,
          fieldSets = state.fieldSets;
      var dataDefinitionFields = dataDefinition.dataDefinitionFields;

      var _getFieldTypes = getFieldTypes(state),
          _getFieldTypes2 = _slicedToArray(_getFieldTypes, 2),
          customFieldTypes = _getFieldTypes2[0],
          nativeFieldTypes = _getFieldTypes2[1];

      var _useDoubleClick = (0, _useDoubleClick3["default"])(function onClick(_ref9) {
        var name = _ref9.name;
        var dataDefinitionField = (0, _findFieldByName2.findFieldByName)(dataDefinitionFields, name);
        dispatch({
          payload: {
            dataDefinitionField: dataDefinitionField
          },
          type: _dataEngineTaglib.DataLayoutBuilderActions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD
        });
      }, function onDoubleClick(_ref10) {
        var name = _ref10.name;

        var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
            activePage = _dataLayoutBuilder$ge.activePage,
            pages = _dataLayoutBuilder$ge.pages;

        var indexes = {
          columnIndex: 0,
          pageIndex: activePage,
          rowIndex: pages[activePage].rows.length
        };

        var _findFieldByName = (0, _findFieldByName2.findFieldByName)(dataDefinitionFields, name),
            customProperties = _findFieldByName.customProperties,
            fieldType = _findFieldByName.fieldType,
            label = _findFieldByName.label,
            repeatable = _findFieldByName.repeatable,
            showLabel = _findFieldByName.showLabel,
            otherFieldProps = _objectWithoutProperties(_findFieldByName, ["customProperties", "fieldType", "label", "repeatable", "showLabel"]);

        if (fieldType === 'fieldset') {
          return dataLayoutBuilder.dispatch('fieldSetAdded', _dataEngineTaglib.DataLayoutBuilderActions.dropFieldSet({
            dataLayoutBuilder: dataLayoutBuilder,
            fieldName: name,
            fieldSet: getFieldSet(_objectSpread({}, otherFieldProps, {
              customProperties: customProperties,
              fieldSets: fieldSets,
              name: label
            })),
            indexes: indexes,
            properties: {
              collapsible: customProperties.collapsible,
              repeatable: repeatable,
              showLabel: showLabel
            },
            useFieldName: name
          }));
        }

        dataLayoutBuilder.dispatch('fieldAdded', _dataEngineTaglib.DataLayoutBuilderActions.dropCustomObjectField({
          addedToPlaceholder: true,
          dataDefinition: dataDefinition,
          dataDefinitionFieldName: name,
          dataLayoutBuilder: dataLayoutBuilder,
          indexes: indexes
        }));
      }),
          _useDoubleClick2 = _slicedToArray(_useDoubleClick, 2),
          handleOnClick = _useDoubleClick2[0],
          handleOnDoubleClick = _useDoubleClick2[1];

      var deleteField = (0, _useDeleteDefinitionField["default"])({
        dataLayoutBuilder: dataLayoutBuilder
      });
      var onDeleteDefinitionField = (0, _useDeleteDefinitionFieldModal["default"])(function (event) {
        return deleteField(event);
      });
      var showCategories = !!customFieldTypes.length && !!nativeFieldTypes.length;
      var fieldTypeListProps = {
        deleteLabel: Liferay.Language.get('delete-from-object'),
        keywords: keywords,
        onClick: handleOnClick,
        onDelete: function onDelete(fieldName) {
          return onDeleteDefinitionField({
            activePage: 0,
            fieldName: fieldName
          });
        },
        onDoubleClick: handleOnDoubleClick
      };
      return _react["default"].createElement(_react["default"].Fragment, null, showCategories && _react["default"].createElement(FieldCategory, {
        categoryName: Liferay.Language.get('custom-fields')
      }), _react["default"].createElement(_dataEngineTaglib.FieldTypeList, _extends({}, fieldTypeListProps, {
        fieldTypes: customFieldTypes
      })), showCategories && _react["default"].createElement(FieldCategory, {
        categoryName: Liferay.Language.get('native-fields')
      }), _react["default"].createElement(_dataEngineTaglib.FieldTypeList, _extends({}, fieldTypeListProps, {
        fieldTypes: nativeFieldTypes
      })));
    };

    exports["default"] = _default;
    //# sourceMappingURL=CustomObjectFieldsList.es.js.map
  }
});
//# sourceMappingURL=CustomObjectFieldsList.es.js.map