Liferay.Loader.define("app-builder-web@1.0.55/js/pages/form-view/ListFormViews.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../AppContext.es', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../hooks/useDataDefinition.es', '../../utils/client.es', '../../utils/lang.es', '../../utils/time.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../../AppContext.es");

    var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

    var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

    var _useDataDefinition2 = _interopRequireDefault(require("../../hooks/useDataDefinition.es"));

    var _client = require("../../utils/client.es");

    var _lang = require("../../utils/lang.es");

    var _time = require("../../utils/time.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var _default = function _default(_ref) {
      var dataDefinitionId = _ref.match.params.dataDefinitionId;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          basePortletURL = _useContext.basePortletURL;

      var _useDataDefinition = (0, _useDataDefinition2["default"])(dataDefinitionId),
          defaultLanguageId = _useDataDefinition.defaultLanguageId;

      var getItemURL = function getItemURL(item) {
        return Liferay.Util.PortletURL.createRenderURL(basePortletURL, {
          dataDefinitionId: dataDefinitionId,
          dataLayoutId: item.id,
          mvcRenderCommandName: '/edit_form_view'
        });
      };

      var handleEditItem = function handleEditItem(item) {
        var itemURL = getItemURL(item);
        Liferay.Util.navigate(itemURL);
      };

      var COLUMNS = [{
        key: 'name',
        sortable: true,
        value: Liferay.Language.get('name')
      }, {
        key: 'dateCreated',
        sortable: true,
        value: Liferay.Language.get('create-date')
      }, {
        asc: false,
        key: 'dateModified',
        sortable: true,
        value: Liferay.Language.get('modified-date')
      }, {
        key: 'id',
        value: Liferay.Language.get('id')
      }];
      var addURL = Liferay.Util.PortletURL.createRenderURL(basePortletURL, {
        dataDefinitionId: dataDefinitionId,
        mvcRenderCommandName: '/edit_form_view'
      });
      return _react["default"].createElement(_ListView["default"], {
        actions: [{
          action: function action(item) {
            return Promise.resolve(handleEditItem(item));
          },
          name: Liferay.Language.get('edit')
        }, {
          action: (0, _client.confirmDelete)('/o/data-engine/v2.0/data-layouts/'),
          name: Liferay.Language.get('delete')
        }],
        addButton: function addButton() {
          return _react["default"].createElement(_Button["default"], {
            className: "nav-btn nav-btn-monospaced",
            onClick: function onClick() {
              return Liferay.Util.navigate(addURL);
            },
            symbol: "plus",
            tooltip: Liferay.Language.get('new-form-view')
          });
        },
        columns: COLUMNS,
        emptyState: {
          button: function button() {
            return _react["default"].createElement(_Button["default"], {
              displayType: "secondary",
              onClick: function onClick() {
                return Liferay.Util.navigate(addURL);
              }
            }, Liferay.Language.get('new-form-view'));
          },
          description: Liferay.Language.get('create-one-or-more-forms-to-display-the-data-held-in-your-data-object'),
          title: Liferay.Language.get('there-are-no-form-views-yet')
        },
        endpoint: "/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-layouts")
      }, function (item) {
        var dateCreated = item.dateCreated,
            dateModified = item.dateModified,
            id = item.id,
            name = item.name;
        return {
          dataDefinitionId: dataDefinitionId,
          dateCreated: (0, _time.fromNow)(dateCreated),
          dateModified: (0, _time.fromNow)(dateModified),
          id: id,
          name: _react["default"].createElement("a", {
            href: getItemURL(item)
          }, (0, _lang.getLocalizedValue)(defaultLanguageId, name))
        };
      });
    };

    exports["default"] = _default;
    //# sourceMappingURL=ListFormViews.es.js.map
  }
});
//# sourceMappingURL=ListFormViews.es.js.map