Liferay.Loader.define("app-builder-web@1.0.55/js/pages/table-view/utils.es", ['module', 'exports', 'require', 'data-engine-taglib', 'frontend-js-metal-web$metal-dom', '../../utils/client.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.saveTableView = exports.getTableViewTitle = exports.getDestructuredFields = exports.getFieldTypeLabel = exports.getFieldLabel = exports.getColumns = exports.getColumnNode = exports.getColumnIndex = void 0;

    var _dataEngineTaglib = require("data-engine-taglib");

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    var _client = require("../../utils/client.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var getColumnIndex = function getColumnIndex(node) {
      var rowNode = _metalDom["default"].closest(node, 'tr');

      if (!rowNode) {
        return -1;
      }

      var columnNode = _metalDom["default"].closest(node, 'td,th');

      if (!columnNode) {
        return -1;
      }

      var scopeId = "".concat(Date.now());
      rowNode.setAttribute('data-scope-uuid', scopeId);
      var columns = rowNode.querySelectorAll("[data-scope-uuid=\"".concat(scopeId, "\"] > ").concat(columnNode.tagName));
      rowNode.removeAttribute('data-scope-uuid');
      return Array.prototype.indexOf.call(columns, columnNode) - 1;
    };

    exports.getColumnIndex = getColumnIndex;

    var getColumnNode = function getColumnNode(container, index) {
      return container.querySelector("table tbody > tr:first-of-type > td:nth-of-type(".concat(index + 2, ")"));
    };

    exports.getColumnNode = getColumnNode;

    var getColumns = function getColumns(container) {
      return container.querySelectorAll("table tbody > tr:first-of-type > td");
    };

    exports.getColumns = getColumns;

    var getFieldLabel = function getFieldLabel(dataDefinition, editingLanguageId, fieldName) {
      var field = _dataEngineTaglib.DataDefinitionUtils.getDataDefinitionField(dataDefinition, fieldName);

      if (field) {
        return field.label[editingLanguageId] || field.label[dataDefinition.defaultLanguageId];
      }

      return fieldName;
    };

    exports.getFieldLabel = getFieldLabel;

    var getFieldTypeLabel = function getFieldTypeLabel(fieldTypes, fieldType) {
      var fieldTypeObject = fieldTypes.find(function (_ref) {
        var name = _ref.name;
        return name === fieldType;
      });

      if (fieldTypeObject) {
        return fieldTypeObject.label;
      }

      return fieldType;
    };

    exports.getFieldTypeLabel = getFieldTypeLabel;

    var getDestructuredFields = function getDestructuredFields(dataDefinition, dataListView) {
      var fieldNames = dataListView.fieldNames;
      var fields = [];
      fieldNames.forEach(function (fieldName) {
        dataDefinition.dataDefinitionFields.forEach(function (dataDefinitionField) {
          var name = dataDefinitionField.name,
              nestedDataDefinitionFields = dataDefinitionField.nestedDataDefinitionFields;

          if (nestedDataDefinitionFields.length) {
            var nested = nestedDataDefinitionFields.find(function (_ref2) {
              var nestedName = _ref2.name;
              return nestedName === fieldName;
            });

            if (nested) {
              fields.push(nested);
            }
          } else if (name === fieldName) {
            fields.push(dataDefinitionField);
          }
        });
      });
      return fields;
    };

    exports.getDestructuredFields = getDestructuredFields;

    var getTableViewTitle = function getTableViewTitle(_ref3) {
      var id = _ref3.id;

      if (id) {
        return Liferay.Language.get('edit-table-view');
      }

      return Liferay.Language.get('new-table-view');
    };

    exports.getTableViewTitle = getTableViewTitle;

    var saveTableView = function saveTableView(dataDefinition, dataListView) {
      if (dataListView.id) {
        return (0, _client.updateItem)("/o/data-engine/v2.0/data-list-views/".concat(dataListView.id), dataListView);
      }

      return (0, _client.addItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinition.id, "/data-list-views"), dataListView);
    };

    exports.saveTableView = saveTableView;
    //# sourceMappingURL=utils.es.js.map
  }
});
//# sourceMappingURL=utils.es.js.map