Liferay.Loader.define("app-builder-web@1.0.55/js/utils/client.es", ['module', 'exports', 'require', 'frontend-js-web', '../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.updateItem = exports.request = exports.getURL = exports.getItem = exports.deleteItem = exports.confirmDelete = exports.addItem = exports.parseResponse = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _toast = require("../utils/toast.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var HEADERS = {
      Accept: 'application/json',
      'Accept-Language': Liferay.ThemeDisplay.getBCP47LanguageId(),
      'Content-Type': 'application/json'
    };

    var parseJSON = function parseJSON(response, resolve, reject) {
      return response.text().then(function (text) {
        return resolve(text ? JSON.parse(text) : {});
      })["catch"](function (error) {
        return reject(error);
      });
    };

    var parseResponse = function parseResponse(response) {
      return new Promise(function (resolve, reject) {
        if (response.ok) {
          parseJSON(response, resolve, reject);
        } else {
          parseJSON(response, reject, reject);
        }
      });
    };

    exports.parseResponse = parseResponse;

    var addItem = function addItem(endpoint, item) {
      return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
        body: JSON.stringify(item),
        headers: HEADERS,
        method: 'POST'
      }).then(function (response) {
        return parseResponse(response);
      });
    };

    exports.addItem = addItem;

    var confirmDelete = function confirmDelete(endpoint) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return function (item) {
        return new Promise(function (resolve, reject) {
          var _options$confirmMessa = options.confirmMessage,
              confirmMessage = _options$confirmMessa === void 0 ? Liferay.Language.get('are-you-sure-you-want-to-delete-this') : _options$confirmMessa,
              _options$errorMessage = options.errorMessage,
              errorMessage = _options$errorMessage === void 0 ? Liferay.Language.get('the-item-could-not-be-deleted') : _options$errorMessage,
              _options$successMessa = options.successMessage,
              successMessage = _options$successMessa === void 0 ? Liferay.Language.get('the-item-was-deleted-successfully') : _options$successMessa;
          var confirmed = confirm(confirmMessage);

          if (confirmed) {
            deleteItem(endpoint + item.id).then(function () {
              return resolve(true);
            }).then(function () {
              return (0, _toast.successToast)(successMessage);
            })["catch"](function (error) {
              (0, _toast.errorToast)(errorMessage);
              reject(error);
            });
          } else {
            resolve(false);
          }
        });
      };
    };

    exports.confirmDelete = confirmDelete;

    var deleteItem = function deleteItem(endpoint) {
      return (0, _frontendJsWeb.fetch)(getURL(endpoint), {
        headers: HEADERS,
        method: 'DELETE'
      }).then(function (response) {
        return parseResponse(response);
      });
    };

    exports.deleteItem = deleteItem;

    var getItem = function getItem(endpoint, params) {
      return (0, _frontendJsWeb.fetch)(getURL(endpoint, params), {
        headers: HEADERS,
        method: 'GET'
      }).then(function (response) {
        return parseResponse(response);
      });
    };

    exports.getItem = getItem;

    var getURL = function getURL(path, params) {
      var _objectSpread2;

      params = _objectSpread((_objectSpread2 = {}, _defineProperty(_objectSpread2, 'p_auth', Liferay.authToken), _defineProperty(_objectSpread2, "t", Date.now()), _objectSpread2), params);
      var uri = new URL("".concat(window.location.origin).concat(path));
      var keys = Object.keys(params);
      keys.forEach(function (key) {
        if (Array.isArray(params[key])) {
          params[key].forEach(function (value) {
            return uri.searchParams.append(key, value);
          });
        } else {
          uri.searchParams.set(key, params[key]);
        }
      });
      return uri.toString();
    };

    exports.getURL = getURL;

    var request = function request(_ref) {
      var endpoint = _ref.endpoint,
          _ref$method = _ref.method,
          method = _ref$method === void 0 ? 'GET' : _ref$method,
          _ref$params = _ref.params,
          params = _ref$params === void 0 ? {} : _ref$params;
      return (0, _frontendJsWeb.fetch)(getURL(endpoint, params), {
        headers: HEADERS,
        method: method
      }).then(function (response) {
        return parseResponse(response);
      });
    };

    exports.request = request;

    var updateItem = function updateItem(endpoint, item, params) {
      return (0, _frontendJsWeb.fetch)(getURL(endpoint, params), {
        body: JSON.stringify(item),
        headers: HEADERS,
        method: 'PUT'
      }).then(function (response) {
        return parseResponse(response);
      });
    };

    exports.updateItem = updateItem;
    //# sourceMappingURL=client.es.js.map
  }
});
//# sourceMappingURL=client.es.js.map