Liferay.Loader.define("app-builder-web@1.0.55/js/utils/lang.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.sub = exports.getLocalizedUserPreferenceValue = exports.getLocalizedValue = void 0;

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var getLocalizedValue = function getLocalizedValue(defaultLanguageId, localizedValues) {
      var languageId = themeDisplay.getLanguageId();

      if (localizedValues[languageId]) {
        return localizedValues[languageId];
      }

      return localizedValues[defaultLanguageId];
    };

    exports.getLocalizedValue = getLocalizedValue;

    var getLocalizedUserPreferenceValue = function getLocalizedUserPreferenceValue(localizedValues, userLanguageId, defaultLanguageId) {
      var _localizedValues$lang;

      var languageId = themeDisplay.getLanguageId();

      if (localizedValues[userLanguageId]) {
        return localizedValues[userLanguageId];
      }

      return (_localizedValues$lang = localizedValues[languageId]) !== null && _localizedValues$lang !== void 0 ? _localizedValues$lang : localizedValues[defaultLanguageId];
    };

    exports.getLocalizedUserPreferenceValue = getLocalizedUserPreferenceValue;

    var sub = function sub(langKey, args) {
      var SPLIT_REGEX = /({\d+})/g;
      var keyArray = langKey.split(SPLIT_REGEX).filter(function (val) {
        return val.length !== 0;
      });

      for (var i = 0; i < args.length; i++) {
        var arg = args[i];
        var indexKey = "{".concat(i, "}");
        var argIndex = keyArray.indexOf(indexKey);

        while (argIndex >= 0) {
          keyArray.splice(argIndex, 1, arg);
          argIndex = keyArray.indexOf(indexKey);
        }
      }

      return keyArray.join('');
    };

    exports.sub = sub;
    //# sourceMappingURL=lang.es.js.map
  }
});
//# sourceMappingURL=lang.es.js.map