Liferay.Loader.define('app-builder-web$moment@2.24.0/locale/gom-latn', ['module', 'exports', 'require', '../moment'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        (function (global, factory) {
            typeof exports === 'object' && typeof module !== 'undefined' && typeof require === 'function' ? factory(require('../moment')) : typeof define === 'function' && define.amd ? define(['../moment'], factory) : factory(global.moment);
        })(this, function (moment) {
            'use strict';

            function processRelativeTime(number, withoutSuffix, key, isFuture) {
                var format = {
                    's': ['thodde secondanim', 'thodde second'],
                    'ss': [number + ' secondanim', number + ' second'],
                    'm': ['eka mintan', 'ek minute'],
                    'mm': [number + ' mintanim', number + ' mintam'],
                    'h': ['eka voran', 'ek vor'],
                    'hh': [number + ' voranim', number + ' voram'],
                    'd': ['eka disan', 'ek dis'],
                    'dd': [number + ' disanim', number + ' dis'],
                    'M': ['eka mhoinean', 'ek mhoino'],
                    'MM': [number + ' mhoineanim', number + ' mhoine'],
                    'y': ['eka vorsan', 'ek voros'],
                    'yy': [number + ' vorsanim', number + ' vorsam']
                };
                return withoutSuffix ? format[key][0] : format[key][1];
            }

            var gomLatn = moment.defineLocale('gom-latn', {
                months: 'Janer_Febrer_Mars_Abril_Mai_Jun_Julai_Agost_Setembr_Otubr_Novembr_Dezembr'.split('_'),
                monthsShort: 'Jan._Feb._Mars_Abr._Mai_Jun_Jul._Ago._Set._Otu._Nov._Dez.'.split('_'),
                monthsParseExact: true,
                weekdays: 'Aitar_Somar_Mongllar_Budvar_Brestar_Sukrar_Son\'var'.split('_'),
                weekdaysShort: 'Ait._Som._Mon._Bud._Bre._Suk._Son.'.split('_'),
                weekdaysMin: 'Ai_Sm_Mo_Bu_Br_Su_Sn'.split('_'),
                weekdaysParseExact: true,
                longDateFormat: {
                    LT: 'A h:mm [vazta]',
                    LTS: 'A h:mm:ss [vazta]',
                    L: 'DD-MM-YYYY',
                    LL: 'D MMMM YYYY',
                    LLL: 'D MMMM YYYY A h:mm [vazta]',
                    LLLL: 'dddd, MMMM[achea] Do, YYYY, A h:mm [vazta]',
                    llll: 'ddd, D MMM YYYY, A h:mm [vazta]'
                },
                calendar: {
                    sameDay: '[Aiz] LT',
                    nextDay: '[Faleam] LT',
                    nextWeek: '[Ieta to] dddd[,] LT',
                    lastDay: '[Kal] LT',
                    lastWeek: '[Fatlo] dddd[,] LT',
                    sameElse: 'L'
                },
                relativeTime: {
                    future: '%s',
                    past: '%s adim',
                    s: processRelativeTime,
                    ss: processRelativeTime,
                    m: processRelativeTime,
                    mm: processRelativeTime,
                    h: processRelativeTime,
                    hh: processRelativeTime,
                    d: processRelativeTime,
                    dd: processRelativeTime,
                    M: processRelativeTime,
                    MM: processRelativeTime,
                    y: processRelativeTime,
                    yy: processRelativeTime
                },
                dayOfMonthOrdinalParse: /\d{1,2}(er)/,
                ordinal: function (number, period) {
                    switch (period) {
                        // the ordinal 'er' only applies to day of the month
                        case 'D':
                            return number + 'er';
                        default:
                        case 'M':
                        case 'Q':
                        case 'DDD':
                        case 'd':
                        case 'w':
                        case 'W':
                            return number;
                    }
                },
                week: {
                    dow: 1, // Monday is the first day of the week.
                    doy: 4 // The week that contains Jan 4th is the first week of the year.
                },
                meridiemParse: /rati|sokalli|donparam|sanje/,
                meridiemHour: function (hour, meridiem) {
                    if (hour === 12) {
                        hour = 0;
                    }
                    if (meridiem === 'rati') {
                        return hour < 4 ? hour : hour + 12;
                    } else if (meridiem === 'sokalli') {
                        return hour;
                    } else if (meridiem === 'donparam') {
                        return hour > 12 ? hour : hour + 12;
                    } else if (meridiem === 'sanje') {
                        return hour + 12;
                    }
                },
                meridiem: function (hour, minute, isLower) {
                    if (hour < 4) {
                        return 'rati';
                    } else if (hour < 12) {
                        return 'sokalli';
                    } else if (hour < 16) {
                        return 'donparam';
                    } else if (hour < 20) {
                        return 'sanje';
                    } else {
                        return 'rati';
                    }
                }
            });

            return gomLatn;
        }); //! moment.js locale configuration
    }
});
//# sourceMappingURL=gom-latn.js.map