Liferay.Loader.define('app-builder-web$moment@2.24.0/src/lib/units/week', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { addFormatToken } from '../format/format';
        import { addUnitAlias } from './aliases';
        import { addUnitPriority } from './priorities';
        import { addRegexToken, match1to2, match2 } from '../parse/regex';
        import { addWeekParseToken } from '../parse/token';
        import toInt from '../utils/to-int';
        import { createLocal } from '../create/local';
        import { weekOfYear } from './week-calendar-utils';

        // FORMATTING

        addFormatToken('w', ['ww', 2], 'wo', 'week');
        addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

        // ALIASES

        addUnitAlias('week', 'w');
        addUnitAlias('isoWeek', 'W');

        // PRIORITIES

        addUnitPriority('week', 5);
        addUnitPriority('isoWeek', 5);

        // PARSING

        addRegexToken('w', match1to2);
        addRegexToken('ww', match1to2, match2);
        addRegexToken('W', match1to2);
        addRegexToken('WW', match1to2, match2);

        addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
            week[token.substr(0, 1)] = toInt(input);
        });

        // HELPERS

        // LOCALES

        export function localeWeek(mom) {
            return weekOfYear(mom, this._week.dow, this._week.doy).week;
        }

        export var defaultLocaleWeek = {
            dow: 0, // Sunday is the first day of the week.
            doy: 6 // The week that contains Jan 6th is the first week of the year.
        };

        export function localeFirstDayOfWeek() {
            return this._week.dow;
        }

        export function localeFirstDayOfYear() {
            return this._week.doy;
        }

        // MOMENTS

        export function getSetWeek(input) {
            var week = this.localeData().week(this);
            return input == null ? week : this.add((input - week) * 7, 'd');
        }

        export function getSetISOWeek(input) {
            var week = weekOfYear(this, 1, 4).week;
            return input == null ? week : this.add((input - week) * 7, 'd');
        }
    }
});
//# sourceMappingURL=week.js.map