/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.entry.rel.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AssetEntryAssetCategoryRelUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryAssetCategoryRelUpgradeProcess.class);

    protected void addAssetEntryAssetCategoryRels() throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select entryId, categoryId from AssetEntries_AssetCategories");
             ResultSet rs = ps.executeQuery();){
            ArrayList<InsertAssetEntryAssetCategoryRelCallable> insertAssetEntryAssetCategoryRelCallables = new ArrayList<InsertAssetEntryAssetCategoryRelCallable>();
            while (rs.next()) {
                long assetEntryId = rs.getLong("entryId");
                long assetCategoryId = rs.getLong("categoryId");
                InsertAssetEntryAssetCategoryRelCallable insertAssetEntryAssetCategoryRelCallable = new InsertAssetEntryAssetCategoryRelCallable(assetEntryId, assetCategoryId);
                insertAssetEntryAssetCategoryRelCallables.add(insertAssetEntryAssetCategoryRelCallable);
            }
            ExecutorService executorService = Executors.newWorkStealingPool();
            List futures = executorService.invokeAll(insertAssetEntryAssetCategoryRelCallables);
            executorService.shutdown();
            for (Future future : futures) {
                boolean success = GetterUtil.get(future.get(), (boolean)true);
                if (success) continue;
                throw new UpgradeException("Unable to add relationships between asset entries and asset categories");
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.addAssetEntryAssetCategoryRels();
    }

    protected void upgradeSchema() throws Exception {
        String template = StringUtil.read((InputStream)AssetEntryAssetCategoryRelUpgradeProcess.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false);
    }

    private class InsertAssetEntryAssetCategoryRelCallable
    implements Callable<Boolean> {
        private final long _assetCategoryId;
        private final long _assetEntryId;

        public InsertAssetEntryAssetCategoryRelCallable(long assetEntryId, long assetCategoryId) {
            this._assetEntryId = assetEntryId;
            this._assetCategoryId = assetCategoryId;
        }

        @Override
        public Boolean call() throws Exception {
            try (Connection connection = DataAccess.getConnection();){
                StringBundler sb = new StringBundler(9);
                sb.append("insert into AssetEntryAssetCategoryRel (");
                sb.append("assetEntryAssetCategoryRelId, assetEntryId, ");
                sb.append("assetCategoryId) values (");
                sb.append(AssetEntryAssetCategoryRelUpgradeProcess.this.increment());
                sb.append(", ");
                sb.append(this._assetEntryId);
                sb.append(", ");
                sb.append(this._assetCategoryId);
                sb.append(")");
                AssetEntryAssetCategoryRelUpgradeProcess.this.runSQL(connection, sb.toString());
            }
            catch (Exception exception) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to add relationship for asset entry ", this._assetEntryId, " and asset category ", this._assetCategoryId}), (Throwable)exception);
                return false;
            }
            return true;
        }
    }
}

