"use strict";

Liferay.Loader.define("@asset-list-web$clayui/provider@3.77.0/lib/Provider", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', './DataClient'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
        return typeof obj;
      } : function (obj) {
        return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      }, _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useProvider = exports.Provider = void 0;

    var _icon = require("@frontend-taglib-clay$clayui/icon");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DataClient = require("./DataClient");

    var _excluded = ["children", "spritemap", "storageMaxSize", "theme"];

    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function") return null;var cacheBabelInterop = new WeakMap();var cacheNodeInterop = new WeakMap();return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }

    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache(nodeInterop);if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);enumerableOnly && (symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        })), keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = null != arguments[i] ? arguments[i] : {};i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var Context = /*#__PURE__*/_react.default.createContext({});

    Context.displayName = 'ClayProviderContext';

    var Provider = function Provider(_ref) {
      var children = _ref.children,
          spritemap = _ref.spritemap,
          _ref$storageMaxSize = _ref.storageMaxSize,
          storageMaxSize = _ref$storageMaxSize === void 0 ? 20 : _ref$storageMaxSize,
          theme = _ref.theme,
          otherProps = _objectWithoutProperties(_ref, _excluded);

      // Use `useMemo` to instantiate the DataClient only once and when
      // updating the property.
      var client = (0, _react.useMemo)(function () {
        return new _DataClient.DataClient({
          storageMaxSize: storageMaxSize
        });
      }, [storageMaxSize]);
      return (/*#__PURE__*/_react.default.createElement(Context.Provider, {
          value: _objectSpread({
            client: client,
            theme: theme
          }, otherProps)
        }, /*#__PURE__*/_react.default.createElement(_icon.ClayIconSpriteContext.Provider, {
          value: spritemap
        }, theme ? /*#__PURE__*/_react.default.createElement("div", {
          className: theme
        }, children) : children))
      );
    };

    exports.Provider = Provider;

    var useProvider = function useProvider() {
      return (0, _react.useContext)(Context);
    };

    exports.useProvider = useProvider;
  }
});
//# sourceMappingURL=Provider.js.map