"use strict";

Liferay.Loader.define("asset-list-web$dom-helpers@5.2.0/cjs/getScrollAccessor", ['module', 'exports', 'require', '@asset-list-web$babel/runtime/helpers/interopRequireDefault', './isWindow'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var _interopRequireDefault = require("@asset-list-web$babel/runtime/helpers/interopRequireDefault");

    exports.__esModule = true;
    exports.default = getscrollAccessor;

    var _isWindow = _interopRequireDefault(require("./isWindow"));

    function getscrollAccessor(offset) {
      var prop = offset === 'pageXOffset' ? 'scrollLeft' : 'scrollTop';

      return function scrollAccessor(node, val) {
        var win = (0, _isWindow.default)(node);

        if (val === undefined) {
          return win ? win[offset] : node[prop];
        }

        if (win) {
          win.scrollTo(win[offset], val);
        } else {
          node[prop] = val;
        }
      };
    }

    module.exports = exports["default"];
  }
});
//# sourceMappingURL=getScrollAccessor.js.map