Liferay.Loader.define("asset-list-web@2.0.82/auto_field/index", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', 'asset-taglib', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _assetTaglib = require("asset-taglib");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const DEFAULT_RULE = {
      queryContains: true,
      type: 'assetTags'
    };
    const QUERY_AND_OPERATOR_OPTIONS = [{
      label: Liferay.Language.get('all'),
      value: true
    }, {
      label: Liferay.Language.get('any'),
      value: false
    }];
    const QUERY_CONTAINS_OPTIONS = [{
      label: Liferay.Language.get('contains'),
      value: true
    }, {
      label: Liferay.Language.get('does-not-contain'),
      value: false
    }];
    const RULE_TYPE_OPTIONS = [{
      label: Liferay.Language.get('categories'),
      value: 'assetCategories'
    }, {
      label: Liferay.Language.get('keywords'),
      value: 'keywords'
    }, {
      label: Liferay.Language.get('tags'),
      value: 'assetTags'
    }];

    function AssetCategories({
      categorySelectorURL,
      groupIds,
      index,
      namespace,
      rule,
      vocabularyIds
    }) {
      const [selectedItems, setSelectedItems] = (0, _react.useState)(rule.selectedItems || []);
      return (/*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: "".concat(namespace, "queryCategoryIds").concat(index)
        }, Liferay.Language.get('categories')), /*#__PURE__*/_react.default.createElement(_assetTaglib.AssetVocabularyCategoriesSelector, {
          categoryIds: rule.queryValues ? rule.queryValues : '',
          eventName: "".concat(namespace, "selectCategory"),
          groupIds: groupIds,
          inputName: "".concat(namespace, "queryCategoryIds").concat(index),
          onSelectedItemsChange: setSelectedItems,
          portletURL: categorySelectorURL,
          selectedItems: selectedItems,
          sourceItemsVocabularyIds: vocabularyIds
        }))
      );
    }

    function AssetTags({
      groupIds,
      index,
      namespace,
      rule,
      tagSelectorURL
    }) {
      const [inputValue, setInputValue] = (0, _react.useState)();
      const [selectedItems, setSelectedItems] = (0, _react.useState)(rule.selectedItems);
      return (/*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement(_assetTaglib.AssetTagsSelector, {
          eventName: "".concat(namespace, "selectTag"),
          groupIds: groupIds,
          inputName: "".concat(namespace, "queryTagNames").concat(index),
          inputValue: inputValue,
          onInputValueChange: setInputValue,
          onSelectedItemsChange: setSelectedItems,
          portletURL: tagSelectorURL,
          selectedItems: selectedItems,
          showSelectButton: true,
          tagNames: rule.queryValues ? rule.queryValues : ''
        }))
      );
    }

    function Keywords({
      index,
      namespace,
      onChange,
      rule
    }) {
      return (/*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: "".concat(namespace, "keywords").concat(index)
        }, Liferay.Language.get('keywords')), /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          className: "asset-query-keywords",
          "data-index": index,
          "data-item-index": index,
          "data-property": "queryValues",
          id: "".concat(namespace, "keywords").concat(index),
          name: "".concat(namespace, "keywords").concat(index),
          onChange: onChange,
          type: "text",
          value: rule.queryValues
        }))
      );
    }

    function Rule({
      categorySelectorURL,
      disabled,
      groupIds,
      index,
      namespace,
      onDeleteRule,
      onRuleChange,
      rule,
      tagSelectorURL,
      vocabularyIds
    }) {
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "panel panel-default"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "panel-body"
        }, /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement(_form.ClaySelectWithOption, {
          "data-index": index,
          "data-property": "queryContains",
          id: "".concat(namespace, "queryContains").concat(index),
          name: "".concat(namespace, "queryContains").concat(index),
          onChange: onRuleChange,
          options: QUERY_CONTAINS_OPTIONS,
          title: Liferay.Language.get('query-contains'),
          value: rule.queryContains
        })), /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement(_form.ClaySelectWithOption, {
          "data-index": index,
          "data-property": "queryAndOperator",
          id: "".concat(namespace, "queryAndOperator").concat(index),
          name: "".concat(namespace, "queryAndOperator").concat(index),
          onChange: onRuleChange,
          options: QUERY_AND_OPERATOR_OPTIONS,
          title: Liferay.Language.get('and-operator'),
          value: rule.queryAndOperator
        })), /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement("label", {
          className: "control-label",
          htmlFor: "".concat(namespace, "queryName").concat(index)
        }, Liferay.Language.get('of-the-following'))), /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement(_form.ClaySelectWithOption, {
          "data-index": index,
          "data-property": "type",
          id: "".concat(namespace, "queryName").concat(index),
          name: "".concat(namespace, "queryName").concat(index),
          onChange: onRuleChange,
          options: RULE_TYPE_OPTIONS,
          value: rule.type
        })), rule.type === 'assetCategories' && /*#__PURE__*/_react.default.createElement(AssetCategories, {
          categorySelectorURL: categorySelectorURL,
          groupIds: groupIds,
          index: index,
          namespace: namespace,
          rule: rule,
          vocabularyIds: vocabularyIds
        }), rule.type === 'assetTags' && /*#__PURE__*/_react.default.createElement(AssetTags, {
          groupIds: groupIds,
          index: index,
          namespace: namespace,
          rule: rule,
          tagSelectorURL: tagSelectorURL
        }), rule.type === 'keywords' && /*#__PURE__*/_react.default.createElement(Keywords, {
          index: index,
          namespace: namespace,
          onChange: onRuleChange,
          rule: rule
        }), /*#__PURE__*/_react.default.createElement("div", {
          className: "timeline-increment"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "timeline-icon"
        })))), !disabled && /*#__PURE__*/_react.default.createElement("div", {
          className: "container-trash"
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "condition-card-delete",
          "data-index": index,
          monospaced: true,
          onClick: onDeleteRule,
          small: true
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "trash"
        }))))
      );
    }

    function AutoField({
      categorySelectorURL,
      disabled,
      groupIds,
      namespace,
      rules,
      tagSelectorURL,
      vocabularyIds
    }) {
      const [currentRules, setCurrentRules] = (0, _react.useState)(rules);
      const handleAddRule = (0, _react.useCallback)(() => {
        setCurrentRules([...currentRules, DEFAULT_RULE]);
      }, [currentRules]);
      const handleDeleteRule = (0, _react.useCallback)(event => {
        const index = parseInt(event.currentTarget.dataset.index, 10);
        setCurrentRules([...currentRules.slice(0, index), ...currentRules.slice(index + 1, currentRules.length)]);
      }, [currentRules]);
      const handleRuleChange = (0, _react.useCallback)(event => {
        const index = parseInt(event.currentTarget.dataset.index, 10);
        const property = event.currentTarget.dataset.property;
        const rule = property === 'type' ? {
          queryContains: true
        } : currentRules[index];
        setCurrentRules([...currentRules.slice(0, index), _objectSpread(_objectSpread({}, rule), {}, {
          [property]: event.currentTarget.value
        }), ...currentRules.slice(index + 1, currentRules.length)]);
      }, [currentRules]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          name: "".concat(namespace, "queryLogicIndexes"),
          type: "hidden",
          value: Object.keys(currentRules).toString()
        }), /*#__PURE__*/_react.default.createElement("ul", {
          className: "timeline"
        }, /*#__PURE__*/_react.default.createElement("li", {
          className: "timeline-item"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "flex-container panel-body"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "timeline-increment"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "timeline-icon"
        })))), currentRules.map((rule, index) => /*#__PURE__*/_react.default.createElement("li", {
          className: "timeline-item",
          key: index
        }, /*#__PURE__*/_react.default.createElement(Rule, {
          categorySelectorURL: categorySelectorURL,
          disabled: disabled,
          groupIds: groupIds,
          index: index,
          namespace: namespace,
          onDeleteRule: handleDeleteRule,
          onRuleChange: handleRuleChange,
          rule: rule,
          tagSelectorURL: tagSelectorURL,
          vocabularyIds: vocabularyIds
        })))), !disabled && /*#__PURE__*/_react.default.createElement("div", {
          className: "addbutton-timeline-item"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "add-condition timeline-increment-icon"
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "form-builder-rule-add-condition form-builder-timeline-add-item",
          monospaced: true,
          onClick: handleAddRule,
          small: true
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "plus"
        })))))
      );
    }

    var _default = AutoField;
    exports.default = _default;
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map