Liferay.Loader.define("asset-list-web@2.0.82/js/AssetEntryListDropdownDefaultEventHandler.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metalState = require("frontend-js-metal-web$metal-state");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    class AssetEntryListDropdownDefaultEventHandler extends _frontendJsWeb.DefaultEventHandler {
      deleteAssetListEntry(itemData) {
        if (confirm(Liferay.Language.get('are-you-sure-you-want-to-delete-this'))) {
          this._send(itemData.deleteAssetListEntryURL);
        }
      }

      permissionsAssetEntryList(itemData) {
        (0, _frontendJsWeb.openModal)({
          title: Liferay.Language.get('permissions'),
          url: itemData.permissionsAssetEntryListURL
        });
      }

      renameAssetListEntry(itemData) {
        (0, _frontendJsWeb.openSimpleInputModal)({
          dialogTitle: Liferay.Language.get('rename-collection'),
          formSubmitURL: itemData.renameAssetListEntryURL,
          idFieldName: 'id',
          idFieldValue: itemData.assetListEntryId,
          mainFieldLabel: Liferay.Language.get('title'),
          mainFieldName: 'title',
          mainFieldPlaceholder: Liferay.Language.get('title'),
          mainFieldValue: itemData.assetListEntryTitle,
          namespace: this.namespace,
          spritemap: this.spritemap
        });
      }

      _send(url) {
        submitForm(document.hrefFm, url);
      }

    }

    AssetEntryListDropdownDefaultEventHandler.STATE = {
      spritemap: _metalState.Config.string()
    };
    var _default = AssetEntryListDropdownDefaultEventHandler;
    exports.default = _default;
    //# sourceMappingURL=AssetEntryListDropdownDefaultEventHandler.es.js.map
  }
});
//# sourceMappingURL=AssetEntryListDropdownDefaultEventHandler.es.js.map