/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.display.context;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.action.AssetEntryAction;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeField;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.configuration.AssetPublisherPortletInstanceConfiguration;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.internal.action.AssetEntryActionRegistry;
import com.liferay.asset.publisher.web.internal.util.AssetPublisherWebUtil;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.asset.util.AssetPublisherAddItemHolder;
import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.rss.util.RSSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class AssetPublisherDisplayContext {
    public static final String PAGINATION_TYPE_NONE = "none";
    public static final String PAGINATION_TYPE_REGULAR = "regular";
    public static final String PAGINATION_TYPE_SIMPLE = "simple";
    public static final String[] PAGINATION_TYPES = new String[]{"none", "regular", "simple"};
    private Integer _abstractLength;
    private long[] _allAssetCategoryIds;
    private String[] _allAssetTagNames;
    private Boolean _anyAssetType;
    private final AssetEntryActionRegistry _assetEntryActionRegistry;
    private AssetEntryQuery _assetEntryQuery;
    private AssetHelper _assetHelper;
    private String _assetLinkBehavior;
    private final AssetPublisherCustomizer _assetPublisherCustomizer;
    private final AssetPublisherPortletInstanceConfiguration _assetPublisherPortletInstanceConfiguration;
    private final AssetPublisherWebConfiguration _assetPublisherWebConfiguration;
    private final AssetPublisherWebUtil _assetPublisherWebUtil;
    private Map<String, Serializable> _attributes;
    private long[] _availableClassNameIds;
    private long[] _classNameIds;
    private long[] _classTypeIds;
    private Long _companyId;
    private String[] _compilerTagNames;
    private String _ddmStructureDisplayFieldValue;
    private String _ddmStructureFieldLabel;
    private String _ddmStructureFieldName;
    private String _ddmStructureFieldValue;
    private Boolean _defaultAssetPublisher;
    private String _displayStyle;
    private Long _displayStyleGroupId;
    private Boolean _enableCommentRatings;
    private Boolean _enableComments;
    private Boolean _enableConversions;
    private Boolean _enableFlags;
    private Boolean _enablePrint;
    private Boolean _enableRatings;
    private Boolean _enableRelatedAssets;
    private Boolean _enableRSS;
    private Boolean _enableTagBasedNavigation;
    private Boolean _enableViewCountIncrement;
    private Boolean _excludeZeroViewCount;
    private String[] _extensions;
    private long[] _groupIds;
    private Layout _layout;
    private Locale _locale;
    private Boolean _mergeURLTags;
    private String[] _metadataFields;
    private String _orderByColumn1;
    private String _orderByColumn2;
    private String _orderByType1;
    private String _orderByType2;
    private String _paginationType;
    private final PortletPreferences _portletPreferences;
    private final PortletRequest _portletRequest;
    private String _portletResource;
    private final PortletResponse _portletResponse;
    private long[] _referencedModelsGroupIds;
    private final HttpServletRequest _request;
    private String _rootPortletId;
    private Integer _rssDelta;
    private String _rssDisplayStyle;
    private String _rssFeedType;
    private String _rssName;
    private Long _scopeGroupId;
    private String _selectionStyle;
    private Boolean _showAddContentButton;
    private Boolean _showAssetTitle;
    private Boolean _showAvailableLocales;
    private Boolean _showContextLink;
    private Boolean _showExtraInfo;
    private Boolean _showMetadataDescriptions;
    private Boolean _showOnlyLayoutAssets;
    private String _socialBookmarksDisplayStyle;
    private String _socialBookmarksTypes;
    private Boolean _subtypeFieldsFilterEnabled;
    private TimeZone _timeZone;
    private Long _userId;

    public AssetPublisherDisplayContext(AssetPublisherCustomizer assetPublisherCustomizer, PortletRequest portletRequest, PortletResponse portletResponse, PortletPreferences portletPreferences) throws ConfigurationException {
        this._assetPublisherCustomizer = assetPublisherCustomizer;
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._portletPreferences = portletPreferences;
        this._assetEntryActionRegistry = (AssetEntryActionRegistry)portletRequest.getAttribute("ASSET_ENTRY_ACTION_REGISTRY");
        this._assetHelper = (AssetHelper)portletRequest.getAttribute("ASSET_HELPER");
        this._assetPublisherWebUtil = (AssetPublisherWebUtil)portletRequest.getAttribute("ASSET_PUBLISHER_WEB_UTIL");
        this._assetPublisherPortletInstanceConfiguration = (AssetPublisherPortletInstanceConfiguration)portletRequest.getAttribute("ASSET_PUBLISHER_PORTLET_INSTANCE_CONFIGURATION");
        this._assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)portletRequest.getAttribute("ASSET_PUBLISHER_WEB_CONFIGURATION");
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
    }

    @Deprecated
    public AssetPublisherDisplayContext(PortletRequest portletRequest, PortletPreferences portletPreferences) {
        throw new UnsupportedOperationException("This constructor is deprecated and replaced by #AssetPublisherDisplayContext(PortletRequest, PortletResponse, PortletPreferences)");
    }

    public int getAbstractLength() {
        if (this._abstractLength != null) {
            return this._abstractLength;
        }
        this._abstractLength = GetterUtil.getInteger((String)this._portletPreferences.getValue("abstractLength", null), (int)200);
        return this._abstractLength;
    }

    public long[] getAllAssetCategoryIds() throws Exception {
        if (this._allAssetCategoryIds != null) {
            return this._allAssetCategoryIds;
        }
        this._allAssetCategoryIds = new long[0];
        long assetCategoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"categoryId");
        String selectionStyle = this.getSelectionStyle();
        if (selectionStyle.equals("dynamic")) {
            this._allAssetCategoryIds = AssetPublisherUtil.getAssetCategoryIds(this._portletPreferences);
        }
        if (assetCategoryId > 0L && !ArrayUtil.contains((long[])this._allAssetCategoryIds, (long)assetCategoryId)) {
            this._allAssetCategoryIds = ArrayUtil.append((long[])this._allAssetCategoryIds, (long)assetCategoryId);
        }
        return this._allAssetCategoryIds;
    }

    public String[] getAllAssetTagNames() throws Exception {
        if (this._allAssetTagNames != null) {
            return this._allAssetTagNames;
        }
        this._allAssetTagNames = new String[0];
        String assetTagName = ParamUtil.getString((HttpServletRequest)this._request, (String)"tag");
        String selectionStyle = this.getSelectionStyle();
        if (selectionStyle.equals("dynamic")) {
            this._allAssetTagNames = AssetPublisherUtil.getAssetTagNames(this._portletPreferences);
        }
        if (Validator.isNotNull((String)assetTagName) && !ArrayUtil.contains((Object[])this._allAssetTagNames, (Object)assetTagName)) {
            this._allAssetTagNames = (String[])ArrayUtil.append((Object[])this._allAssetTagNames, (Object)assetTagName);
        }
        if (this.isMergeURLTags()) {
            this._allAssetTagNames = (String[])ArrayUtil.append((Object[])this._allAssetTagNames, (Object[])this.getCompilerTagNames());
        }
        this._allAssetTagNames = ArrayUtil.distinct((String[])this._allAssetTagNames, (Comparator)new StringComparator());
        return this._allAssetTagNames;
    }

    public List<AssetEntryAction> getAssetEntryActions(String className) {
        return this._assetEntryActionRegistry.getAssetEntryActions(className);
    }

    public AssetEntryQuery getAssetEntryQuery() throws Exception {
        if (this._assetEntryQuery != null) {
            return this._assetEntryQuery;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._assetEntryQuery = AssetPublisherUtil.getAssetEntryQuery(this._portletPreferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout(), this.getAllAssetCategoryIds(), this.getAllAssetTagNames());
        this._assetEntryQuery.setEnablePermissions(this.isEnablePermissions().booleanValue());
        this.configureSubtypeFieldFilter(this._assetEntryQuery, themeDisplay.getLocale());
        this._assetEntryQuery.setPaginationType(this.getPaginationType());
        this._assetPublisherWebUtil.processAssetEntryQuery(themeDisplay.getUser(), this._portletPreferences, this._assetEntryQuery);
        this._assetPublisherCustomizer.setAssetEntryQueryOptions(this._assetEntryQuery, this._request);
        return this._assetEntryQuery;
    }

    public String getAssetLinkBehavior() {
        if (this._assetLinkBehavior != null) {
            return this._assetLinkBehavior;
        }
        this._assetLinkBehavior = GetterUtil.getString((String)this._portletPreferences.getValue("assetLinkBehavior", "showFullContent"));
        return this._assetLinkBehavior;
    }

    public AssetPublisherPortletInstanceConfiguration getAssetPublisherPortletInstanceConfiguration() {
        return this._assetPublisherPortletInstanceConfiguration;
    }

    public Map<String, Serializable> getAttributes() {
        if (this._attributes != null) {
            return this._attributes;
        }
        this._attributes = new HashMap<String, Serializable>();
        Map parameters = this._request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isNotEmpty((Object[])values)) continue;
            if (values.length == 1) {
                this._attributes.put(name, (Serializable)values[0]);
                continue;
            }
            this._attributes.put(name, (Serializable)values);
        }
        return this._attributes;
    }

    public JSONArray getAutoFieldRulesJSONArray() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String queryLogicIndexesParam = ParamUtil.getString((HttpServletRequest)this._request, (String)"queryLogicIndexes");
        int[] queryLogicIndexes = null;
        if (Validator.isNotNull((String)queryLogicIndexesParam)) {
            queryLogicIndexes = StringUtil.split((String)queryLogicIndexesParam, (int)0);
        } else {
            String queryValues;
            queryLogicIndexes = new int[]{};
            int i = 0;
            while (!Validator.isNull((String)(queryValues = PrefsParamUtil.getString((PortletPreferences)this._portletPreferences, (HttpServletRequest)this._request, (String)("queryValues" + i))))) {
                queryLogicIndexes = ArrayUtil.append((int[])queryLogicIndexes, (int)i);
                ++i;
            }
            if (queryLogicIndexes.length == 0) {
                queryLogicIndexes = ArrayUtil.append((int[])queryLogicIndexes, (int)-1);
            }
        }
        JSONArray rulesJSONArray = JSONFactoryUtil.createJSONArray();
        for (int queryLogicIndex : queryLogicIndexes) {
            JSONObject ruleJSONObject = JSONFactoryUtil.createJSONObject();
            boolean queryAndOperator = PrefsParamUtil.getBoolean((PortletPreferences)this._portletPreferences, (HttpServletRequest)this._request, (String)("queryAndOperator" + queryLogicIndex));
            ruleJSONObject.put("queryAndOperator", queryAndOperator);
            boolean queryContains = PrefsParamUtil.getBoolean((PortletPreferences)this._portletPreferences, (HttpServletRequest)this._request, (String)("queryContains" + queryLogicIndex), (boolean)true);
            ruleJSONObject.put("queryContains", queryContains);
            String queryValues = StringUtil.merge((Object[])this._portletPreferences.getValues("queryValues" + queryLogicIndex, new String[0]));
            String queryName = PrefsParamUtil.getString((PortletPreferences)this._portletPreferences, (HttpServletRequest)this._request, (String)("queryName" + queryLogicIndex), (String)"assetTags");
            if (Objects.equals(queryName, "assetTags")) {
                queryValues = ParamUtil.getString((HttpServletRequest)this._request, (String)("queryTagNames" + queryLogicIndex), (String)queryValues);
                queryValues = this._assetPublisherWebUtil.filterAssetTagNames(themeDisplay.getScopeGroupId(), queryValues);
            } else {
                queryValues = ParamUtil.getString((HttpServletRequest)this._request, (String)("queryCategoryIds" + queryLogicIndex), (String)queryValues);
                JSONArray categoryIdsTitles = JSONFactoryUtil.createJSONArray();
                List<AssetCategory> categories = this._filterAssetCategories(GetterUtil.getLongValues((String[])queryValues.split(",")));
                for (AssetCategory category : categories) {
                    categoryIdsTitles.put(category.getTitle(themeDisplay.getLocale()));
                }
                List categoryIds = ListUtil.toList(categories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
                queryValues = StringUtil.merge((Collection)categoryIds, (String)",");
                ruleJSONObject.put("categoryIdsTitles", categoryIdsTitles);
            }
            if (Validator.isNull((String)queryValues)) continue;
            ruleJSONObject.put("queryValues", queryValues);
            ruleJSONObject.put("type", queryName);
            rulesJSONArray.put(ruleJSONObject);
        }
        return rulesJSONArray;
    }

    public long[] getAvailableClassNameIds() {
        if (this._availableClassNameIds != null) {
            return this._availableClassNameIds;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)themeDisplay.getCompanyId(), (boolean)true);
        return this._availableClassNameIds;
    }

    public String getCategorySelectorURL() {
        try {
            PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this._request, (String)AssetCategory.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
            if (portletURL == null) {
                return null;
            }
            portletURL.setParameter("eventName", this._portletResponse.getNamespace() + "selectCategory");
            portletURL.setParameter("selectedCategories", "{selectedCategories}");
            portletURL.setParameter("singleSelect", "{singleSelect}");
            portletURL.setParameter("vocabularyIds", "{vocabularyIds}");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            return portletURL.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long[] getClassNameIds() {
        if (this._classNameIds != null) {
            return this._classNameIds;
        }
        this._classNameIds = AssetPublisherUtil.getClassNameIds(this._portletPreferences, this.getAvailableClassNameIds());
        return this._classNameIds;
    }

    public long[] getClassTypeIds() {
        if (this._classTypeIds != null) {
            return this._classTypeIds;
        }
        this._classTypeIds = GetterUtil.getLongValues((String[])this._portletPreferences.getValues("classTypeIds", null));
        return this._classTypeIds;
    }

    public Long getCompanyId() {
        if (this._companyId != null) {
            return this._companyId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._companyId = themeDisplay.getCompanyId();
        return this._companyId;
    }

    public String[] getCompilerTagNames() {
        if (this._compilerTagNames != null) {
            return this._compilerTagNames;
        }
        this._compilerTagNames = new String[0];
        if (this.isMergeURLTags()) {
            this._compilerTagNames = ParamUtil.getParameterValues((HttpServletRequest)this._request, (String)"tags");
        }
        return this._compilerTagNames;
    }

    public String getDDMStructureDisplayFieldValue() throws Exception {
        if (this._ddmStructureDisplayFieldValue != null) {
            return this._ddmStructureDisplayFieldValue;
        }
        this.setDDMStructure();
        return this._ddmStructureDisplayFieldValue;
    }

    public String getDDMStructureFieldLabel() throws Exception {
        if (this._ddmStructureFieldLabel != null) {
            return this._ddmStructureFieldLabel;
        }
        this.setDDMStructure();
        return this._ddmStructureFieldLabel;
    }

    public String getDDMStructureFieldName() throws Exception {
        if (this._ddmStructureFieldName != null) {
            return this._ddmStructureFieldName;
        }
        this.setDDMStructure();
        return this._ddmStructureFieldName;
    }

    public String getDDMStructureFieldValue() throws Exception {
        if (this._ddmStructureFieldValue != null) {
            return this._ddmStructureFieldValue;
        }
        this.setDDMStructure();
        return this._ddmStructureFieldValue;
    }

    public Integer getDelta() {
        return this._assetPublisherCustomizer.getDelta(this._request);
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = GetterUtil.getString((String)this._portletPreferences.getValue("displayStyle", this._assetPublisherPortletInstanceConfiguration.defaultDisplayStyle()));
        return this._displayStyle;
    }

    public long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId != null) {
            return this._displayStyleGroupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._displayStyleGroupId = GetterUtil.getLong((String)this._portletPreferences.getValue("displayStyleGroupId", null), (long)themeDisplay.getScopeGroupId());
        return this._displayStyleGroupId;
    }

    public String[] getExtensions() {
        if (this._extensions != null) {
            return this._extensions;
        }
        this._extensions = this._portletPreferences.getValues("extensions", new String[0]);
        return this._extensions;
    }

    public String[] getExtensions(AssetRenderer<?> assetRenderer) {
        final String[] supportedConversions = assetRenderer.getSupportedConversions();
        if (supportedConversions == null) {
            return this.getExtensions();
        }
        return (String[])ArrayUtil.filter((Object[])this.getExtensions(), (PredicateFilter)new PredicateFilter<String>(){

            public boolean filter(String extension) {
                return ArrayUtil.contains((Object[])supportedConversions, (Object)extension);
            }
        });
    }

    public long[] getGroupIds() {
        if (this._groupIds != null) {
            return this._groupIds;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._groupIds = AssetPublisherUtil.getGroupIds(this._portletPreferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout());
        return this._groupIds;
    }

    public Layout getLayout() {
        if (this._layout != null) {
            return this._layout;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._layout = themeDisplay.getLayout();
        return this._layout;
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._locale = themeDisplay.getLocale();
        return this._locale;
    }

    public String[] getMetadataFields() {
        if (this._metadataFields != null) {
            return this._metadataFields;
        }
        this._metadataFields = StringUtil.split((String)this._portletPreferences.getValue("metadataFields", ""));
        return this._metadataFields;
    }

    public String getOrderByColumn1() {
        if (this._orderByColumn1 != null) {
            return this._orderByColumn1;
        }
        this._orderByColumn1 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByColumn1", "modifiedDate"));
        return this._orderByColumn1;
    }

    public String getOrderByColumn2() {
        if (this._orderByColumn2 != null) {
            return this._orderByColumn2;
        }
        this._orderByColumn2 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByColumn2", "title"));
        return this._orderByColumn2;
    }

    public String getOrderByType1() {
        if (this._orderByType1 != null) {
            return this._orderByType1;
        }
        this._orderByType1 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByType1", "DESC"));
        return this._orderByType1;
    }

    public String getOrderByType2() {
        if (this._orderByType2 != null) {
            return this._orderByType2;
        }
        this._orderByType2 = GetterUtil.getString((String)this._portletPreferences.getValue("orderByType2", "ASC"));
        return this._orderByType2;
    }

    public String getPaginationType() {
        if (this._paginationType != null) {
            return this._paginationType;
        }
        this._paginationType = GetterUtil.getString((String)this._portletPreferences.getValue("paginationType", PAGINATION_TYPE_NONE));
        if (!ArrayUtil.contains((Object[])PAGINATION_TYPES, (Object)this._paginationType)) {
            this._paginationType = PAGINATION_TYPE_NONE;
        }
        return this._paginationType;
    }

    public String getPortletName() {
        PortletConfig portletConfig = (PortletConfig)this._request.getAttribute("javax.portlet.config");
        if (portletConfig == null) {
            return "";
        }
        return portletConfig.getPortletName();
    }

    public String getPortletResource() {
        if (this._portletResource != null) {
            return this._portletResource;
        }
        this._portletResource = ParamUtil.getString((HttpServletRequest)this._request, (String)"portletResource");
        return this._portletResource;
    }

    public long[] getReferencedModelsGroupIds() throws PortalException {
        if (this._referencedModelsGroupIds != null) {
            return this._referencedModelsGroupIds;
        }
        this._referencedModelsGroupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long[])this.getGroupIds(), (boolean)true);
        return this._referencedModelsGroupIds;
    }

    public String getRootPortletId() {
        if (this._rootPortletId != null) {
            return this._rootPortletId;
        }
        this._rootPortletId = PortletIdCodec.decodePortletName((String)this.getPortletResource());
        return this._rootPortletId;
    }

    public int getRSSDelta() {
        if (this._rssDelta != null) {
            return this._rssDelta;
        }
        this._rssDelta = GetterUtil.getInteger((String)this._portletPreferences.getValue("rssDelta", ""), (int)SearchContainer.DEFAULT_DELTA);
        return this._rssDelta;
    }

    public String getRSSDisplayStyle() {
        if (this._rssDisplayStyle != null) {
            return this._rssDisplayStyle;
        }
        this._rssDisplayStyle = this._portletPreferences.getValue("rssDisplayStyle", "abstract");
        return this._rssDisplayStyle;
    }

    public String getRSSFeedType() {
        if (this._rssFeedType != null) {
            return this._rssFeedType;
        }
        this._rssFeedType = this._portletPreferences.getValue("rssFeedType", RSSUtil.FEED_TYPE_DEFAULT);
        return this._rssFeedType;
    }

    public String getRSSName() {
        if (this._rssName != null) {
            return this._rssName;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._rssName = this._portletPreferences.getValue("rssName", portletDisplay.getTitle());
        return this._rssName;
    }

    @Deprecated
    public Map<Long, Map<String, PortletURL>> getScopeAddPortletURLs(int max) throws Exception {
        long[] groupIds = this.getGroupIds();
        if (groupIds.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, PortletURL>> scopeAddPortletURLs = new HashMap<Long, Map<String, PortletURL>>();
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)this._portletRequest);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)this._portletResponse);
        String redirect = this._getScopeAssetPortletRedirect(liferayPortletRequest, liferayPortletResponse);
        for (long groupId : groupIds) {
            List assetPublisherAddItemHolders = this._assetHelper.getAssetPublisherAddItemHolders(liferayPortletRequest, liferayPortletResponse, groupId, this.getClassNameIds(), this.getClassTypeIds(), this.getAllAssetCategoryIds(), this.getAllAssetTagNames(), redirect);
            if (ListUtil.isNotEmpty((List)assetPublisherAddItemHolders)) {
                HashMap<String, PortletURL> addPortletURLs = new HashMap<String, PortletURL>();
                for (AssetPublisherAddItemHolder assetPublisherAddItemHolder : assetPublisherAddItemHolders) {
                    addPortletURLs.put(assetPublisherAddItemHolder.getName(), assetPublisherAddItemHolder.getPortletURL());
                }
                scopeAddPortletURLs.put(groupId, addPortletURLs);
            }
            if (scopeAddPortletURLs.size() > max) break;
        }
        return scopeAddPortletURLs;
    }

    public Map<Long, List<AssetPublisherAddItemHolder>> getScopeAssetPublisherAddItemHolders(int max) throws Exception {
        long[] groupIds = this.getGroupIds();
        if (groupIds.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<AssetPublisherAddItemHolder>> scopeAssetPublisherAddItemHolders = new HashMap<Long, List<AssetPublisherAddItemHolder>>();
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)this._portletRequest);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)this._portletResponse);
        String redirect = this._getScopeAssetPortletRedirect(liferayPortletRequest, liferayPortletResponse);
        for (long groupId : groupIds) {
            List assetPublisherAddItemHolders = this._assetHelper.getAssetPublisherAddItemHolders(liferayPortletRequest, liferayPortletResponse, groupId, this.getClassNameIds(), this.getClassTypeIds(), this.getAllAssetCategoryIds(), this.getAllAssetTagNames(), redirect);
            if (ListUtil.isNotEmpty((List)assetPublisherAddItemHolders)) {
                scopeAssetPublisherAddItemHolders.put(groupId, assetPublisherAddItemHolders);
            }
            if (scopeAssetPublisherAddItemHolders.size() > max) break;
        }
        return scopeAssetPublisherAddItemHolders;
    }

    public Long getScopeGroupId() {
        if (this._scopeGroupId != null) {
            return this._scopeGroupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._scopeGroupId = themeDisplay.getScopeGroupId();
        return this._scopeGroupId;
    }

    public String getSelectionStyle() {
        if (this._selectionStyle != null) {
            return this._selectionStyle;
        }
        this._selectionStyle = GetterUtil.getString((String)this._portletPreferences.getValue("selectionStyle", null), (String)"dynamic");
        return this._selectionStyle;
    }

    @Deprecated
    public String getSocialBookmarksDisplayPosition() {
        return "bottom";
    }

    public String getSocialBookmarksDisplayStyle() {
        if (this._socialBookmarksDisplayStyle != null) {
            return this._socialBookmarksDisplayStyle;
        }
        return this._portletPreferences.getValue("socialBookmarksDisplayStyle", null);
    }

    public String getSocialBookmarksTypes() {
        if (this._socialBookmarksTypes == null) {
            this._socialBookmarksTypes = this._portletPreferences.getValue("socialBookmarksTypes", null);
        }
        return this._socialBookmarksTypes;
    }

    public String getTagSelectorURL() {
        try {
            PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this._request, (String)AssetTag.class.getName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
            if (portletURL == null) {
                return null;
            }
            portletURL.setParameter("eventName", this._portletResponse.getNamespace() + "selectTag");
            portletURL.setParameter("groupIds", StringUtil.merge((long[])this.getGroupIds()));
            portletURL.setParameter("selectedTagNames", "{selectedTagNames}");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            return portletURL.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public TimeZone getTimeZone() {
        if (this._timeZone != null) {
            return this._timeZone;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._timeZone = themeDisplay.getTimeZone();
        return this._timeZone;
    }

    public Long getUserId() {
        if (this._userId != null) {
            return this._userId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._userId = themeDisplay.getUserId();
        return this._userId;
    }

    public String getVocabularyIds() throws Exception {
        List vocabularies = AssetVocabularyServiceUtil.getGroupsVocabularies((long[])this.getGroupIds());
        return ListUtil.toString((List)vocabularies, (Accessor)AssetVocabulary.VOCABULARY_ID_ACCESSOR);
    }

    public AssetEntry incrementViewCounter(AssetEntry assetEntry) throws PortalException {
        if (assetEntry == null || assetEntry.isNew() || !assetEntry.isVisible() || !this.isEnableViewCountIncrement()) {
            return assetEntry;
        }
        if (this.isEnablePermissions().booleanValue()) {
            return AssetEntryServiceUtil.incrementViewCounter((String)assetEntry.getClassName(), (long)assetEntry.getClassPK());
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return AssetEntryLocalServiceUtil.incrementViewCounter((long)themeDisplay.getUserId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK());
    }

    public Boolean isAnyAssetType() {
        if (this._anyAssetType != null) {
            return this._anyAssetType;
        }
        this._anyAssetType = GetterUtil.getBoolean((String)this._portletPreferences.getValue("anyAssetType", null), (boolean)true);
        return this._anyAssetType;
    }

    public boolean isAssetLinkBehaviorShowFullContent() {
        String assetLinkBehavior = this.getAssetLinkBehavior();
        return assetLinkBehavior.equals("showFullContent");
    }

    public boolean isAssetLinkBehaviorViewInPortlet() {
        String assetLinkBehavior = this.getAssetLinkBehavior();
        return assetLinkBehavior.equals("viewInPortlet");
    }

    public boolean isDefaultAssetPublisher() {
        if (this._defaultAssetPublisher != null) {
            return this._defaultAssetPublisher;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._defaultAssetPublisher = this._assetPublisherWebUtil.isDefaultAssetPublisher(themeDisplay.getLayout(), portletDisplay.getId(), this.getPortletResource());
        return this._defaultAssetPublisher;
    }

    public boolean isEnableCommentRatings() {
        if (this._enableCommentRatings != null) {
            return this._enableCommentRatings;
        }
        this._enableCommentRatings = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableCommentRatings", null));
        return this._enableCommentRatings;
    }

    public boolean isEnableComments() {
        if (this._enableComments != null) {
            return this._enableComments;
        }
        this._enableComments = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableComments", null));
        return this._enableComments;
    }

    public Boolean isEnableConversions() throws Exception {
        if (this._enableConversions != null) {
            return this._enableConversions;
        }
        this._enableConversions = this.isOpenOfficeServerEnabled() && ArrayUtil.isNotEmpty((Object[])this.getExtensions());
        return this._enableConversions;
    }

    public boolean isEnableFlags() {
        if (this._enableFlags != null) {
            return this._enableFlags;
        }
        this._enableFlags = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableFlags", null));
        return this._enableFlags;
    }

    public Boolean isEnablePermissions() {
        return this._assetPublisherCustomizer.isEnablePermissions(this._request);
    }

    public boolean isEnablePrint() {
        if (this._enablePrint != null) {
            return this._enablePrint;
        }
        this._enablePrint = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enablePrint", null));
        return this._enablePrint;
    }

    public boolean isEnableRatings() {
        if (this._enableRatings != null) {
            return this._enableRatings;
        }
        this._enableRatings = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableRatings", null));
        return this._enableRatings;
    }

    public boolean isEnableRelatedAssets() {
        if (this._enableRelatedAssets != null) {
            return this._enableRelatedAssets;
        }
        this._enableRelatedAssets = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableRelatedAssets", null), (boolean)true);
        return this._enableRelatedAssets;
    }

    public boolean isEnableRSS() {
        if (this._enableRSS != null) {
            return this._enableRSS;
        }
        this._enableRSS = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableRss", null));
        return this._enableRSS;
    }

    public boolean isEnableSetAsDefaultAssetPublisher() {
        String rootPortletId = this.getRootPortletId();
        return rootPortletId.equals("com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet");
    }

    @Deprecated
    public boolean isEnableSocialBookmarks() {
        return true;
    }

    public boolean isEnableTagBasedNavigation() {
        if (this._enableTagBasedNavigation != null) {
            return this._enableTagBasedNavigation;
        }
        this._enableTagBasedNavigation = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableTagBasedNavigation", null));
        return this._enableTagBasedNavigation;
    }

    public boolean isEnableViewCountIncrement() {
        if (this._enableViewCountIncrement != null) {
            return this._enableViewCountIncrement;
        }
        this._enableViewCountIncrement = GetterUtil.getBoolean((String)this._portletPreferences.getValue("enableViewCountIncrement", null), (boolean)PropsValues.ASSET_ENTRY_BUFFERED_INCREMENT_ENABLED);
        return this._enableViewCountIncrement;
    }

    public boolean isExcludeZeroViewCount() {
        if (this._excludeZeroViewCount != null) {
            return this._excludeZeroViewCount;
        }
        this._excludeZeroViewCount = GetterUtil.getBoolean((String)this._portletPreferences.getValue("excludeZeroViewCount", null));
        return this._excludeZeroViewCount;
    }

    public boolean isMergeURLTags() {
        if (this._mergeURLTags != null) {
            return this._mergeURLTags;
        }
        this._mergeURLTags = GetterUtil.getBoolean((String)this._portletPreferences.getValue("mergeUrlTags", null), (boolean)true);
        return this._mergeURLTags;
    }

    public boolean isOpenOfficeServerEnabled() {
        return DocumentConversionUtil.isEnabled();
    }

    public boolean isOrderingAndGroupingEnabled() {
        return this._assetPublisherCustomizer.isOrderingAndGroupingEnabled(this._request);
    }

    public boolean isOrderingByTitleEnabled() {
        return this._assetPublisherCustomizer.isOrderingByTitleEnabled(this._request);
    }

    public boolean isPaginationTypeNone() {
        String paginationType = this.getPaginationType();
        return paginationType.equals(PAGINATION_TYPE_NONE);
    }

    public boolean isPaginationTypeSelected(String paginationType) {
        String curPaginationType = this.getPaginationType();
        return curPaginationType.equals(paginationType);
    }

    public boolean isSelectionStyleDynamic() {
        String selectionStyle = this.getSelectionStyle();
        return selectionStyle.equals("dynamic");
    }

    public boolean isSelectionStyleEnabled() {
        return this._assetPublisherCustomizer.isSelectionStyleEnabled(this._request);
    }

    public boolean isSelectionStyleManual() {
        String selectionStyle = this.getSelectionStyle();
        return selectionStyle.equals("manual");
    }

    public boolean isShowAddContentButton() {
        if (this._showAddContentButton != null) {
            return this._showAddContentButton;
        }
        this._showAddContentButton = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showAddContentButton", null), (boolean)true);
        return this._showAddContentButton;
    }

    public Boolean isShowAssetTitle() {
        if (this._showAssetTitle != null) {
            return this._showAssetTitle;
        }
        this._showAssetTitle = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showAssetTitle", null), (boolean)true);
        return this._showAssetTitle;
    }

    public Boolean isShowAvailableLocales() {
        if (this._showAvailableLocales != null) {
            return this._showAvailableLocales;
        }
        this._showAvailableLocales = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showAvailableLocales", null));
        return this._showAvailableLocales;
    }

    public Boolean isShowContextLink() {
        if (this._showContextLink != null) {
            return this._showContextLink;
        }
        this._showContextLink = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showContextLink", null), (boolean)true);
        return this._showContextLink;
    }

    public Boolean isShowContextLink(long groupId, String portletId) throws PortalException {
        if (this._showContextLink != null) {
            return this._showContextLink;
        }
        this._showContextLink = this.isShowContextLink();
        if (this._showContextLink.booleanValue() && PortalUtil.getPlidFromPortletId((long)groupId, (String)portletId) == 0L) {
            this._showContextLink = false;
        }
        return this._showContextLink;
    }

    public boolean isShowEnableAddContentButton() {
        return this._assetPublisherCustomizer.isShowEnableAddContentButton(this._request);
    }

    public Boolean isShowEnablePermissions() {
        if (this._assetPublisherWebConfiguration.searchWithIndex()) {
            return false;
        }
        return this._assetPublisherWebConfiguration.permissionCheckingConfigurable();
    }

    public boolean isShowEnableRelatedAssets() {
        return this._assetPublisherCustomizer.isShowEnableRelatedAssets(this._request);
    }

    public boolean isShowExtraInfo() {
        if (this._showExtraInfo != null) {
            return this._showExtraInfo;
        }
        this._showExtraInfo = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showExtraInfo", null), (boolean)true);
        return this._showExtraInfo;
    }

    public boolean isShowMetadataDescriptions() {
        if (this._showMetadataDescriptions != null) {
            return this._showMetadataDescriptions;
        }
        this._showMetadataDescriptions = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showMetadataDescriptions", null), (boolean)true);
        return this._showMetadataDescriptions;
    }

    public boolean isShowOnlyLayoutAssets() {
        if (this._showOnlyLayoutAssets != null) {
            return this._showOnlyLayoutAssets;
        }
        this._showOnlyLayoutAssets = GetterUtil.getBoolean((String)this._portletPreferences.getValue("showOnlyLayoutAssets", null));
        return this._showOnlyLayoutAssets;
    }

    public boolean isShowScopeSelector() {
        String rootPortletId = this.getRootPortletId();
        return !rootPortletId.equals("com_liferay_asset_publisher_web_portlet_RelatedAssetsPortlet");
    }

    public boolean isShowSubtypeFieldsFilter() {
        return this._assetPublisherCustomizer.isShowSubtypeFieldsFilter(this._request);
    }

    public boolean isSubtypeFieldsFilterEnabled() {
        if (this._subtypeFieldsFilterEnabled != null) {
            return this._subtypeFieldsFilterEnabled;
        }
        this._subtypeFieldsFilterEnabled = GetterUtil.getBoolean((String)this._portletPreferences.getValue("subtypeFieldsFilterEnabled", Boolean.FALSE.toString()));
        return this._subtypeFieldsFilterEnabled;
    }

    public void setDisplayStyle(String displayStyle) {
        this._displayStyle = displayStyle;
    }

    public void setLayoutAssetEntry(AssetEntry assetEntry) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String defaultAssetPublisherPortletId = this._assetPublisherWebUtil.getDefaultAssetPublisherId(themeDisplay.getLayout());
        if (this.isDefaultAssetPublisher() || Validator.isNull((String)defaultAssetPublisherPortletId) || !PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)defaultAssetPublisherPortletId, (String)"VIEW")) {
            this._request.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)assetEntry);
        }
    }

    public void setSelectionStyle(String selectionStyle) {
        this._selectionStyle = selectionStyle;
    }

    public void setShowContextLink(Boolean showContextLink) {
        this._showContextLink = showContextLink;
    }

    protected void configureSubtypeFieldFilter(AssetEntryQuery assetEntryQuery, Locale locale) throws Exception {
        long[] classNameIds = this.getClassNameIds();
        long[] classTypeIds = this.getClassTypeIds();
        if (!this.isSubtypeFieldsFilterEnabled() || classNameIds.length != 1 || classTypeIds.length != 1 || Validator.isNull((String)this.getDDMStructureFieldName()) || Validator.isNull((String)this.getDDMStructureFieldValue())) {
            return;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameIds[0]);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(classTypeIds[0], locale);
        ClassTypeField classTypeField = classType.getClassTypeField(this.getDDMStructureFieldName());
        assetEntryQuery.setAttribute("ddmStructureFieldName", (Serializable)((Object)this._assetPublisherWebUtil.encodeName(classTypeField.getClassTypeId(), this.getDDMStructureFieldName(), locale)));
        assetEntryQuery.setAttribute("ddmStructureFieldValue", (Serializable)((Object)this.getDDMStructureFieldValue()));
    }

    protected void setDDMStructure() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._ddmStructureDisplayFieldValue = "";
        this._ddmStructureFieldLabel = "";
        this._ddmStructureFieldName = "";
        this._ddmStructureFieldValue = null;
        long[] classNameIds = this.getClassNameIds();
        long[] classTypeIds = this.getClassTypeIds();
        if (!this.isSubtypeFieldsFilterEnabled() || classNameIds.length != 1 || classTypeIds.length != 1) {
            return;
        }
        this._ddmStructureDisplayFieldValue = ParamUtil.getString((HttpServletRequest)this._request, (String)"ddmStructureDisplayFieldValue", (String)this._portletPreferences.getValue("ddmStructureDisplayFieldValue", ""));
        this._ddmStructureFieldName = ParamUtil.getString((HttpServletRequest)this._request, (String)"ddmStructureFieldName", (String)this._portletPreferences.getValue("ddmStructureFieldName", ""));
        this._ddmStructureFieldValue = ParamUtil.getString((HttpServletRequest)this._request, (String)"ddmStructureFieldValue", (String)this._portletPreferences.getValue("ddmStructureFieldValue", ""));
        if (Validator.isNotNull((String)this._ddmStructureFieldName) && Validator.isNotNull((String)this._ddmStructureFieldValue)) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameIds[0]);
            ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
            ClassType classType = classTypeReader.getClassType(classTypeIds[0], themeDisplay.getLocale());
            ClassTypeField classTypeField = classType.getClassTypeField(this._ddmStructureFieldName);
            this._ddmStructureFieldLabel = classTypeField.getLabel();
        }
    }

    private List<AssetCategory> _filterAssetCategories(long[] categoryIds) {
        ArrayList<AssetCategory> filteredCategories = new ArrayList<AssetCategory>();
        for (long categoryId : categoryIds) {
            AssetCategory category = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)categoryId);
            if (category == null) continue;
            filteredCategories.add(category);
        }
        return filteredCategories;
    }

    private String _getScopeAssetPortletRedirect(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL redirectURL = liferayPortletResponse.createRenderURL();
        redirectURL.setParameter("hideDefaultSuccessMessage", Boolean.TRUE.toString());
        redirectURL.setParameter("mvcPath", "/add_asset_redirect.jsp");
        PortletURL currentURLObj = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        redirectURL.setParameter("redirect", currentURLObj.toString());
        redirectURL.setWindowState(LiferayWindowState.POP_UP);
        return redirectURL.toString();
    }
}

