/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.display.context;

import com.liferay.asset.publisher.web.display.context.ItemSelectorViewDisplayContext;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.item.selector.criterion.SiteItemSelectorCriterion;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseItemSelectorViewDisplayContext
implements ItemSelectorViewDisplayContext {
    protected final PortletURL portletURL;
    protected final HttpServletRequest request;
    private Long _groupId;
    private final String _itemSelectedEventName;
    private final SiteItemSelectorCriterion _siteItemSelectorCriterion;

    public BaseItemSelectorViewDisplayContext(HttpServletRequest request, SiteItemSelectorCriterion siteItemSelectorCriterion, String itemSelectedEventName, PortletURL portletURL) {
        this.request = request;
        this._siteItemSelectorCriterion = siteItemSelectorCriterion;
        this._itemSelectedEventName = itemSelectedEventName;
        this.portletURL = portletURL;
    }

    @Override
    public String getDisplayStyle() {
        String displayStyle = ParamUtil.getString((HttpServletRequest)this.request, (String)"displayStyle");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this.request);
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = portalPreferences.getValue("ITEM_SELECTOR", "display-style", "icon");
        } else {
            portalPreferences.setValue("ITEM_SELECTOR", "display-style", displayStyle);
            this.request.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        return displayStyle;
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this.request, (String)"groupId");
        return this._groupId;
    }

    @Override
    public String getItemSelectedEventName() {
        return this._itemSelectedEventName;
    }

    @Override
    public PortletRequest getPortletRequest() {
        return (PortletRequest)this.request.getAttribute("javax.portlet.request");
    }

    @Override
    public PortletResponse getPortletResponse() {
        return (PortletResponse)this.request.getAttribute("javax.portlet.response");
    }

    @Override
    public PortletURL getPortletURL() throws PortletException {
        PortletURL portletURL = PortletURLUtil.clone((PortletURL)this.portletURL, (LiferayPortletResponse)PortalUtil.getLiferayPortletResponse((PortletResponse)this.getPortletResponse()));
        long plid = ParamUtil.getLong((HttpServletRequest)this.request, (String)"plid");
        long groupId = ParamUtil.getLong((HttpServletRequest)this.request, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)this.request, (String)"privateLayout");
        String portletResource = ParamUtil.getString((HttpServletRequest)this.request, (String)"portletResource");
        portletURL.setParameter("plid", String.valueOf(plid));
        portletURL.setParameter("groupId", String.valueOf(groupId));
        portletURL.setParameter("privateLayout", String.valueOf(privateLayout));
        portletURL.setParameter("portletResource", portletResource);
        return portletURL;
    }

    @Override
    public long[] getSelectedGroupIds() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletResource = ParamUtil.getString((HttpServletRequest)this.request, (String)"portletResource");
        long plid = ParamUtil.getLong((HttpServletRequest)this.request, (String)"plid");
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        if (layout == null) {
            return new long[0];
        }
        PortletPreferences portletPreferences = themeDisplay.getStrictLayoutPortletSetup(layout, portletResource);
        return AssetPublisherUtil.getGroupIds(portletPreferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout());
    }

    @Override
    public SiteItemSelectorCriterion getSiteItemSelectorCriterion() {
        return this._siteItemSelectorCriterion;
    }

    @Override
    public boolean isShowSearch() {
        return true;
    }
}

