/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.internal.util.AssetPublisherWebUtil;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.base.BaseExportImportPortletPreferencesProcessor;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.site.model.adapter.StagedGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, property={"javax.portlet.name=com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class AssetPublisherExportImportPortletPreferencesProcessor
extends BaseExportImportPortletPreferencesProcessor {
    @Reference(target="(name=AssetPublisherExportCapability)")
    protected Capability assetExportCapability;
    @Reference(target="(name=AssetPublisherImportCapability)")
    protected Capability assetImportCapability;
    @Reference
    protected AssetPublisherWebUtil assetPublisherWebUtil;
    @Reference(target="(name=ReferencedStagedModelImporter)")
    protected Capability capability;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(AssetPublisherExportImportPortletPreferencesProcessor.class);
    private AssetCategoryLocalService _assetCategoryLocalService;
    private AssetPublisherWebConfiguration _assetPublisherWebConfiguration;
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private CompanyLocalService _companyLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    private OrganizationLocalService _organizationLocalService;
    private PortletLocalService _portletLocalService;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this.assetExportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this.assetImportCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            if (MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PORTLET_DATA") && !MergeLayoutPrototypesThreadLocal.isInProgress()) {
                this.exportAssetObjects(portletDataContext, portletPreferences);
            }
            return this.updateExportPortletPreferences(portletDataContext, portletDataContext.getPortletId(), portletPreferences);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to update portlet preferences while exporting " + portletDataContext.getPortletId()), (Throwable)e);
            }
            return portletPreferences;
        }
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            this.importLayoutReferences(portletDataContext);
            this.capability.process(portletDataContext, portletPreferences);
            return this.updateImportPortletPreferences(portletDataContext, portletPreferences);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to update portlet preferences while importing " + portletDataContext.getPortletId()), (Throwable)e);
            }
            return portletPreferences;
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)ConfigurableUtil.createConfigurable(AssetPublisherWebConfiguration.class, properties);
    }

    protected void exportAssetObjects(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        List assetEntries = null;
        Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            if (!this._assetPublisherWebConfiguration.dynamicExportEnabled()) {
                return;
            }
            AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(layout, portletDataContext.getCompanyGroupId(), portletDataContext.getScopeGroupId(), portletPreferences);
            long assetVocabularyId = GetterUtil.getLong((String)portletPreferences.getValue("assetVocabularyId", null));
            if (assetVocabularyId > 0L) {
                this.mergeAnyCategoryIds(assetEntryQuery, assetVocabularyId);
                if (ArrayUtil.isEmpty((long[])assetEntryQuery.getAnyCategoryIds())) {
                    return;
                }
            }
            BaseModelSearchResult<AssetEntry> baseModelSearchResult = AssetPublisherUtil.getAssetEntries(assetEntryQuery, layout, portletPreferences, "com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", LocaleUtil.getDefault(), TimeZoneUtil.getDefault(), portletDataContext.getCompanyId(), portletDataContext.getScopeGroupId(), 0L, new HashMap<String, Serializable>(), assetEntryQuery.getStart(), assetEntryQuery.getEnd());
            assetEntries = baseModelSearchResult.getBaseModels();
        } else {
            if (!this._assetPublisherWebConfiguration.manualExportEnabled()) {
                return;
            }
            long[] groupIds = AssetPublisherUtil.getGroupIds(portletPreferences, portletDataContext.getScopeGroupId(), layout);
            assetEntries = AssetPublisherUtil.getAssetEntries(null, portletPreferences, PermissionThreadLocal.getPermissionChecker(), groupIds, false, false);
        }
        for (AssetEntry assetEntry : assetEntries) {
            AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
            if (assetRenderer == null || !(assetRenderer.getAssetObject() instanceof StagedModel)) continue;
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)((StagedModel)assetRenderer.getAssetObject()));
        }
    }

    protected AssetEntryQuery getAssetEntryQuery(Layout layout, long companyId, long groupId, PortletPreferences portletPreferences) throws Exception {
        AssetEntryQuery assetEntryQuery = AssetPublisherUtil.getAssetEntryQuery(portletPreferences, groupId, layout, null, null);
        long[] classNameIds = AssetPublisherUtil.getClassNameIds(portletPreferences, AssetRendererFactoryRegistryUtil.getClassNameIds((long)companyId, (boolean)true));
        assetEntryQuery.setClassNameIds(classNameIds);
        assetEntryQuery.setEnablePermissions(false);
        int end = this._assetPublisherWebConfiguration.dynamicExportLimit();
        if (end == 0) {
            end = -1;
        }
        assetEntryQuery.setEnd(end);
        assetEntryQuery.setExcludeZeroViewCount(false);
        int start = 0;
        if (end == 0) {
            start = -1;
        }
        assetEntryQuery.setStart(start);
        return assetEntryQuery;
    }

    protected String getExportPortletPreferencesValue(PortletDataContext portletDataContext, Portlet portlet, String className, long primaryKeyLong) throws Exception {
        Organization organization;
        String uuid = null;
        long groupId = 0L;
        Element rootElement = portletDataContext.getExportDataRootElement();
        if (className.equals(AssetCategory.class.getName())) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(primaryKeyLong);
            if (assetCategory != null) {
                uuid = assetCategory.getUuid();
                groupId = assetCategory.getGroupId();
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portlet.getPortletId(), (StagedModel)assetCategory);
            }
        } else if (className.equals(AssetVocabulary.class.getName())) {
            AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(primaryKeyLong);
            if (assetVocabulary != null) {
                uuid = assetVocabulary.getUuid();
                groupId = assetVocabulary.getGroupId();
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portlet.getPortletId(), (StagedModel)assetVocabulary);
            }
        } else if (className.equals(DDMStructure.class.getName())) {
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(primaryKeyLong);
            if (ddmStructure != null) {
                uuid = ddmStructure.getUuid();
                groupId = ddmStructure.getGroupId();
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portlet.getPortletId(), (StagedModel)ddmStructure);
            }
        } else if (className.equals(DLFileEntryType.class.getName())) {
            DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.fetchFileEntryType(primaryKeyLong);
            if (dlFileEntryType != null) {
                uuid = dlFileEntryType.getUuid();
                groupId = dlFileEntryType.getGroupId();
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portlet.getPortletId(), (StagedModel)dlFileEntryType);
            }
        } else if (className.equals(Organization.class.getName()) && (organization = this._organizationLocalService.fetchOrganization(primaryKeyLong)) != null) {
            uuid = organization.getUuid();
            portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)organization, "dependency", true);
        }
        if (Validator.isNull((String)uuid)) {
            return null;
        }
        return StringUtil.merge((Object[])new Object[]{uuid, groupId}, (String)"#");
    }

    protected Long getImportPortletPreferencesNewValue(PortletDataContext portletDataContext, Class<?> clazz, long companyGroupId, Map<Long, Long> primaryKeys, String portletPreferencesOldValue) throws Exception {
        if (Validator.isNumber((String)portletPreferencesOldValue)) {
            long oldPrimaryKey = GetterUtil.getLong((String)portletPreferencesOldValue);
            return MapUtil.getLong(primaryKeys, (long)oldPrimaryKey, (long)oldPrimaryKey);
        }
        String className = clazz.getName();
        String[] oldValues = StringUtil.split((String)portletPreferencesOldValue, (String)"#");
        String uuid = oldValues[0];
        long groupId = portletDataContext.getScopeGroupId();
        if (oldValues.length > 1) {
            Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
            groupId = MapUtil.getLong((Map)groupIds, (long)GetterUtil.getLong((String)oldValues[1]), (long)groupId);
        }
        if (className.equals(AssetCategory.class.getName())) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByUuidAndGroupId(uuid, groupId);
            if (assetCategory != null) {
                return assetCategory.getCategoryId();
            }
        } else if (className.equals(AssetVocabulary.class.getName())) {
            AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabularyByUuidAndGroupId(uuid, groupId);
            if (assetVocabulary != null) {
                return assetVocabulary.getVocabularyId();
            }
        } else if (className.equals(DDMStructure.class.getName())) {
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructureByUuidAndGroupId(uuid, groupId);
            if (ddmStructure == null) {
                Map structureUuids = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureUuid");
                String defaultStructureUuid = MapUtil.getString((Map)structureUuids, (String)uuid, (String)uuid);
                ddmStructure = this._ddmStructureLocalService.fetchDDMStructureByUuidAndGroupId(defaultStructureUuid, groupId);
            }
            if (ddmStructure != null) {
                return ddmStructure.getStructureId();
            }
        } else if (className.equals(DLFileEntryType.class.getName())) {
            Element rootElement;
            Element element;
            DLFileEntryType dlFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryTypeByUuidAndGroupId(uuid, groupId);
            if (dlFileEntryType == null && (element = portletDataContext.getReferenceElement(rootElement = portletDataContext.getImportDataRootElement(), clazz, companyGroupId, uuid, "dependency")) != null) {
                String fileEntryTypeKey = element.attributeValue("file-entry-type-key");
                boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
                if (preloaded) {
                    dlFileEntryType = this._dlFileEntryTypeLocalService.fetchFileEntryType(companyGroupId, fileEntryTypeKey);
                }
            }
            if (dlFileEntryType != null) {
                return dlFileEntryType.getFileEntryTypeId();
            }
        }
        return null;
    }

    protected void importLayoutReferences(PortletDataContext portletDataContext) throws PortletDataException {
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element referencesElement = importDataRootElement.element("references");
        if (referencesElement == null) {
            return;
        }
        List referenceElements = referencesElement.elements();
        for (Element referenceElement : referenceElements) {
            String className = referenceElement.attributeValue("class-name");
            if (!className.equals(Layout.class.getName())) continue;
            long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (String)className, (long)classPK);
        }
    }

    protected void mergeAnyCategoryIds(AssetEntryQuery assetEntryQuery, long assetVocabularyId) {
        List assetCategories = this._assetCategoryLocalService.getVocabularyRootCategories(assetVocabularyId, -1, -1, null);
        long[] vocabularyCategoryIds = new long[]{};
        for (AssetCategory assetCategory : assetCategories) {
            vocabularyCategoryIds = ArrayUtil.append((long[])vocabularyCategoryIds, (long)assetCategory.getCategoryId());
        }
        long[] originalAnyCategoryIds = assetEntryQuery.getAnyCategoryIds();
        if (ArrayUtil.isEmpty((long[])originalAnyCategoryIds)) {
            assetEntryQuery.setAnyCategoryIds(vocabularyCategoryIds);
        } else {
            long[] newAnyCategoryIds = new long[]{};
            for (long originalAnyCategoryId : originalAnyCategoryIds) {
                if (!ArrayUtil.contains((long[])vocabularyCategoryIds, (long)originalAnyCategoryId)) continue;
                newAnyCategoryIds = ArrayUtil.append((long[])newAnyCategoryIds, (long)originalAnyCategoryId);
            }
            assetEntryQuery.setAnyCategoryIds(newAnyCategoryIds);
        }
    }

    protected void restorePortletPreference(PortletDataContext portletDataContext, String name, PortletPreferences portletPreferences) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
        PortletPreferences originalPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletDataContext.getPortletId());
        String[] values = originalPortletPreferences.getValues(name, new String[]{""});
        portletPreferences.setValues(name, values);
    }

    @Reference(unbind="-")
    protected void setAssetCategoryLocalService(AssetCategoryLocalService assetCategoryLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setAssetVocabularyLocalService(AssetVocabularyLocalService assetVocabularyLocalService) {
        this._assetVocabularyLocalService = assetVocabularyLocalService;
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setOrganizationLocalService(OrganizationLocalService organizationLocalService) {
        this._organizationLocalService = organizationLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    protected void updateExportClassNameIds(PortletPreferences portletPreferences, String key) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i = 0;
        for (String oldValue : oldValues) {
            if (key.equals("anyAssetType") && (oldValue.equals("false") || oldValue.equals("true"))) {
                newValues[i++] = oldValue;
                continue;
            }
            try {
                long classNameId = GetterUtil.getLong((String)oldValue);
                String className = this.portal.getClassName(classNameId);
                newValues[i++] = className;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to get class name ID for class name " + oldValue));
            }
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateExportOrderByColumnClassPKs(PortletDataContext portletDataContext, Portlet portlet, PortletPreferences portletPreferences, String key) throws Exception {
        String oldValue = portletPreferences.getValue(key, null);
        String[] ddmStructureFieldNameParts = StringUtil.split((String)oldValue, (String)"__");
        String primaryKey = ddmStructureFieldNameParts[2];
        if (!Validator.isNumber((String)primaryKey)) {
            return;
        }
        long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
        String newPreferencesValue = this.getExportPortletPreferencesValue(portletDataContext, portlet, DDMStructure.class.getName(), primaryKeyLong);
        if (Validator.isNull((String)newPreferencesValue)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to export portlet preferences value for class ", DDMStructure.class.getName(), " with primary key ", String.valueOf(primaryKeyLong)}));
            }
            return;
        }
        String newValue = StringUtil.replace((String)oldValue, (String)primaryKey, (String)newPreferencesValue);
        portletPreferences.setValue(key, newValue);
    }

    protected PortletPreferences updateExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        String[] classNameIds;
        String anyAssetTypeString = portletPreferences.getValue("anyAssetType", null);
        String selectionStyle = portletPreferences.getValue("selectionStyle", null);
        if (Validator.isNotNull((String)selectionStyle) && selectionStyle.equals("manual")) {
            portletPreferences.reset("anyAssetType");
            anyAssetTypeString = portletPreferences.getValue("anyAssetType", null);
        } else if (Validator.isNotNull((String)anyAssetTypeString) && anyAssetTypeString.equals("false") && (classNameIds = portletPreferences.getValues("classNameIds", StringPool.EMPTY_ARRAY)).length == 1) {
            portletPreferences.setValue("anyAssetType", classNameIds[0]);
            anyAssetTypeString = portletPreferences.getValue("anyAssetType", null);
            portletPreferences.reset("classNameIds");
        }
        String anyAssetTypeClassName = "";
        long anyAssetType = GetterUtil.getLong((String)anyAssetTypeString);
        if (anyAssetType > 0L) {
            anyAssetTypeClassName = this.portal.getClassName(anyAssetType);
        }
        Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
        Enumeration enu = portletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = GetterUtil.getString((String)portletPreferences.getValue(name, null));
            if (name.equals("anyAssetType") || name.equals("classNameIds")) {
                if (name.equals("classNameIds") && Validator.isNotNull((String)anyAssetTypeString) && !anyAssetTypeString.equals("false")) {
                    portletPreferences.reset(name);
                    continue;
                }
                this.updateExportClassNameIds(portletPreferences, name);
                continue;
            }
            if (name.equals("anyClassTypeDLFileEntryAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(DLFileEntry.class.getName()) || name.equals("classTypeIdsDLFileEntryAssetRendererFactory")) {
                String anyClassTypeDLFileEntryAssetRendererFactory = portletPreferences.getValue("anyClassTypeDLFileEntryAssetRendererFactory", null);
                String[] classTypeIdsDLFileEntryAssetRendererFactory = portletPreferences.getValues("classTypeIdsDLFileEntryAssetRendererFactory", StringPool.EMPTY_ARRAY);
                if (Validator.isNotNull((String)anyClassTypeDLFileEntryAssetRendererFactory) && anyClassTypeDLFileEntryAssetRendererFactory.equals("false") && classTypeIdsDLFileEntryAssetRendererFactory.length == 1) {
                    portletPreferences.setValue("anyClassTypeDLFileEntryAssetRendererFactory", classTypeIdsDLFileEntryAssetRendererFactory[0]);
                    portletPreferences.reset("classTypeIdsDLFileEntryAssetRendererFactory");
                    anyClassTypeDLFileEntryAssetRendererFactory = portletPreferences.getValue("anyClassTypeDLFileEntryAssetRendererFactory", null);
                }
                if (!anyAssetTypeClassName.equals(DLFileEntry.class.getName()) || name.equals("classTypeIdsDLFileEntryAssetRendererFactory") && Validator.isNotNull((String)anyClassTypeDLFileEntryAssetRendererFactory) && !anyClassTypeDLFileEntryAssetRendererFactory.equals("false")) {
                    portletPreferences.reset(name);
                    continue;
                }
                this.updateExportPortletPreferencesClassPKs(portletDataContext, portlet, portletPreferences, name, DLFileEntryType.class.getName());
                continue;
            }
            if (name.equals("anyClassTypeJournalArticleAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(JournalArticle.class.getName()) || name.equals("classTypeIdsJournalArticleAssetRendererFactory")) {
                String anyClassTypeJournalArticleAssetRendererFactory = portletPreferences.getValue("anyClassTypeJournalArticleAssetRendererFactory", null);
                String[] classTypeIdsJournalArticleAssetRendererFactory = portletPreferences.getValues("classTypeIdsJournalArticleAssetRendererFactory", StringPool.EMPTY_ARRAY);
                if (Validator.isNotNull((String)anyClassTypeJournalArticleAssetRendererFactory) && anyClassTypeJournalArticleAssetRendererFactory.equals("false") && classTypeIdsJournalArticleAssetRendererFactory.length == 1) {
                    portletPreferences.setValue("anyClassTypeJournalArticleAssetRendererFactory", classTypeIdsJournalArticleAssetRendererFactory[0]);
                    portletPreferences.reset("classTypeIdsJournalArticleAssetRendererFactory");
                    anyClassTypeJournalArticleAssetRendererFactory = portletPreferences.getValue("anyClassTypeJournalArticleAssetRendererFactory", null);
                }
                if (!anyAssetTypeClassName.equals(JournalArticle.class.getName()) || name.equals("classTypeIdsJournalArticleAssetRendererFactory") && Validator.isNotNull((String)anyClassTypeJournalArticleAssetRendererFactory) && !anyClassTypeJournalArticleAssetRendererFactory.equals("false")) {
                    portletPreferences.reset(name);
                    continue;
                }
                this.updateExportPortletPreferencesClassPKs(portletDataContext, portlet, portletPreferences, name, DDMStructure.class.getName());
                continue;
            }
            if (name.equals("assetVocabularyId")) {
                long assetVocabularyId = GetterUtil.getLong((String)value);
                AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(assetVocabularyId);
                if (assetVocabulary != null) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)assetVocabulary);
                }
                this.updateExportPortletPreferencesClassPKs(portletDataContext, portlet, portletPreferences, name, AssetVocabulary.class.getName());
                continue;
            }
            if (name.startsWith("orderByColumn") && StringUtil.startsWith((String)value, (String)"ddm__")) {
                this.updateExportOrderByColumnClassPKs(portletDataContext, portlet, portletPreferences, name);
                continue;
            }
            if (name.startsWith("queryName") && StringUtil.equalsIgnoreCase((String)value, (String)"assetCategories")) {
                String index = name.substring(9);
                long assetCategoryId = GetterUtil.getLong((String)portletPreferences.getValue("queryValues" + index, null));
                AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(assetCategoryId);
                if (assetCategory != null) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)assetCategory);
                }
                this.updateExportPortletPreferencesClassPKs(portletDataContext, portlet, portletPreferences, "queryValues" + index, AssetCategory.class.getName());
                continue;
            }
            if (!name.equals("scopeIds")) continue;
            this.updateExportScopeIds(portletDataContext, portletPreferences, name, portletDataContext.getPlid());
        }
        return portletPreferences;
    }

    protected void updateExportScopeIds(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, long plid) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Layout layout = this._layoutLocalService.getLayout(plid);
        String companyGroupScopeId = "Group_" + portletDataContext.getCompanyGroupId();
        String[] newValues = new String[oldValues.length];
        Element rootElement = portletDataContext.getExportDataRootElement();
        Element groupIdMappingsElement = rootElement.addElement("group-id-mappings");
        for (int i = 0; i < oldValues.length; ++i) {
            String oldValue = oldValues[i];
            if (oldValue.startsWith("Group_")) {
                newValues[i] = StringUtil.replace((String)oldValue, (String)companyGroupScopeId, (String)"[$COMPANY_GROUP_SCOPE_ID$]");
                if (newValues[i].contains("[$COMPANY_GROUP_SCOPE_ID$]")) {
                    continue;
                }
            } else if (oldValue.startsWith("Layout_")) {
                String scopeIdSuffix = oldValue.substring("Layout_".length());
                long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdSuffix);
                Layout scopeIdLayout = this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), scopeIdLayoutId);
                if (plid != scopeIdLayout.getPlid()) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)scopeIdLayout);
                }
                newValues[i] = "LayoutUuid_" + scopeIdLayout.getUuid();
            } else if (oldValue.startsWith("LayoutUuid_")) {
                String scopeLayoutUuid = oldValue.substring("LayoutUuid_".length());
                Layout scopeUuidLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
                if (plid != scopeUuidLayout.getPlid()) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)scopeUuidLayout);
                }
                newValues[i] = oldValue;
            } else {
                newValues[i] = oldValue;
            }
            long groupId = AssetPublisherUtil.getGroupIdFromScopeId(newValues[i], portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
            Group group = this._groupLocalService.fetchGroup(groupId);
            long liveGroupId = 0L;
            if (group != null) {
                liveGroupId = group.getLiveGroupId();
                if (group.isStagedRemotely()) {
                    liveGroupId = group.getRemoteLiveGroupId();
                }
            }
            if (groupId == 0L || liveGroupId == 0L) continue;
            newValues[i] = String.valueOf(groupId);
            Element groupIdMappingElement = groupIdMappingsElement.addElement("group-id-mapping");
            groupIdMappingElement.addAttribute("group-id", String.valueOf(groupId));
            groupIdMappingElement.addAttribute("live-group-id", String.valueOf(liveGroupId));
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportClassNameIds(PortletPreferences portletPreferences, String key) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i = 0;
        for (String oldValue : oldValues) {
            if (key.equals("anyAssetType") && (oldValue.equals("false") || oldValue.equals("true"))) {
                newValues[i++] = oldValue;
                continue;
            }
            try {
                long classNameId = this.portal.getClassNameId(oldValue);
                newValues[i++] = String.valueOf(classNameId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find class name ID for class name " + oldValue));
            }
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateImportOrderByColumnClassPKs(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, long companyGroupId) throws Exception {
        String[] ddmStructureFieldNameParts;
        String portletPreferencesOldValue;
        String oldValue = portletPreferences.getValue(key, null);
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        Long newPrimaryKey = this.getImportPortletPreferencesNewValue(portletDataContext, DDMStructure.class, companyGroupId, primaryKeys, portletPreferencesOldValue = (ddmStructureFieldNameParts = StringUtil.split((String)oldValue, (String)"__"))[2]);
        if (Validator.isNull((Long)newPrimaryKey)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to import portlet preferences value " + portletPreferencesOldValue));
            }
            return;
        }
        String newValue = StringUtil.replace((String)oldValue, (String)portletPreferencesOldValue, (String)newPrimaryKey.toString());
        portletPreferences.setValue(key, newValue);
    }

    protected PortletPreferences updateImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        Company company = this._companyLocalService.getCompanyById(portletDataContext.getCompanyId());
        Group companyGroup = company.getGroup();
        String anyAssetTypeClassName = portletPreferences.getValue("anyAssetType", "");
        Enumeration enu = portletPreferences.getNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = GetterUtil.getString((String)portletPreferences.getValue(name, null));
            if (name.equals("anyAssetType") || name.equals("classNameIds")) {
                this.updateImportClassNameIds(portletPreferences, name);
                continue;
            }
            if (name.equals("anyClassTypeDLFileEntryAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(DLFileEntry.class.getName()) || name.equals("classTypeIdsDLFileEntryAssetRendererFactory")) {
                this.updateImportPortletPreferencesClassPKs(portletDataContext, portletPreferences, name, DLFileEntryType.class, companyGroup.getGroupId());
                continue;
            }
            if (name.equals("anyClassTypeJournalArticleAssetRendererFactory") || name.equals("classTypeIds") && anyAssetTypeClassName.equals(JournalArticle.class.getName()) || name.equals("classTypeIdsJournalArticleAssetRendererFactory")) {
                this.updateImportPortletPreferencesClassPKs(portletDataContext, portletPreferences, name, DDMStructure.class, companyGroup.getGroupId());
                continue;
            }
            if (name.equals("assetVocabularyId")) {
                this.updateImportPortletPreferencesClassPKs(portletDataContext, portletPreferences, name, AssetVocabulary.class, companyGroup.getGroupId());
                continue;
            }
            if (name.startsWith("orderByColumn") && StringUtil.startsWith((String)value, (String)"ddm__")) {
                this.updateImportOrderByColumnClassPKs(portletDataContext, portletPreferences, name, companyGroup.getGroupId());
                continue;
            }
            if (name.startsWith("queryName") && StringUtil.equalsIgnoreCase((String)value, (String)"assetCategories")) {
                String index = name.substring(9);
                this.updateImportPortletPreferencesClassPKs(portletDataContext, portletPreferences, "queryValues" + index, AssetCategory.class, companyGroup.getGroupId());
                continue;
            }
            if (!name.equals("scopeIds")) continue;
            this.updateImportScopeIds(portletDataContext, portletPreferences, name, companyGroup.getGroupId(), portletDataContext.getPlid());
        }
        this.restorePortletPreference(portletDataContext, "notifiedAssetEntryIds", portletPreferences);
        return portletPreferences;
    }

    protected void updateImportScopeIds(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, long companyGroupId, long plid) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)StagedGroup.class.getName());
        Element rootElement = portletDataContext.getImportDataRootElement();
        Element groupIdMappingsElement = rootElement.element("group-id-mappings");
        for (Element groupIdMappingElement : groupIdMappingsElement.elements("group-id-mapping")) {
            stagedModelDataHandler.importMissingReference(portletDataContext, groupIdMappingElement);
        }
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        Layout layout = this._layoutLocalService.getLayout(plid);
        String companyGroupScopeId = "Group_" + companyGroupId;
        ArrayList<String> newValues = new ArrayList<String>(oldValues.length);
        for (String oldValue : oldValues) {
            Group group;
            String newValue = StringUtil.replace((String)oldValue, (String)"[$COMPANY_GROUP_SCOPE_ID$]", (String)companyGroupScopeId);
            if (Validator.isNumber((String)oldValue) && groupIds.containsKey(Long.valueOf(oldValue)) && (group = this._groupLocalService.fetchGroup(((Long)groupIds.get(Long.valueOf(oldValue))).longValue())) != null) {
                newValue = AssetPublisherUtil.getScopeId(group, portletDataContext.getScopeGroupId());
            }
            if (Validator.isNumber((String)newValue)) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((String[])new String[]{"Ignoring group ", newValue, " because it cannot ", "be converted to scope"}));
                continue;
            }
            try {
                if (!this.assetPublisherWebUtil.isScopeIdSelectable(PermissionThreadLocal.getPermissionChecker(), newValue, companyGroupId, layout, false)) continue;
                newValues.add(newValue);
            }
            catch (NoSuchGroupException nsge) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((String[])new String[]{"Ignoring scope ", newValue, " because the ", "referenced group was not found"}), (Throwable)nsge);
            }
            catch (NoSuchLayoutException nsle) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((String[])new String[]{"Ignoring scope ", newValue, " because the ", "referenced layout was not found"}), (Throwable)nsle);
            }
            catch (PrincipalException pe) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((String[])new String[]{"Ignoring scope ", newValue, " because the ", "referenced parent group no longer allows sharing ", "content with child sites"}), (Throwable)pe);
            }
        }
        portletPreferences.setValues(key, newValues.toArray(new String[newValues.size()]));
    }
}

