/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.internal.messaging;

import aQute.bnd.annotation.ProviderType;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.internal.util.AssetPublisherWebUtil;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portlet.asset.service.permission.AssetEntryPermission;
import com.liferay.portlet.configuration.kernel.util.PortletConfigurationUtil;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, service={AssetEntriesCheckerUtil.class})
@ProviderType
public class AssetEntriesCheckerUtil {
    private static AssetPublisherWebUtil _assetPublisherWebUtil;
    private static LayoutLocalService _layoutLocalService;
    private static PortletPreferencesLocalService _portletPreferencesLocalService;
    private static SubscriptionLocalService _subscriptionLocalService;
    private static final Accessor<AssetEntry, String> _titleAccessor;
    private static UserLocalService _userLocalService;
    @Reference
    private AssetHelper _assetHelper;
    @Reference
    private ConfigurationProvider _configurationProvider;

    public void checkAssetEntries() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = _portletPreferencesLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"portletId");
                dynamicQuery.add(property.like((Object)PortletIdCodec.encode((String)"com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", (String)"%")));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<PortletPreferences>(){

            public void performAction(PortletPreferences portletPreferences) throws PortalException {
                AssetEntriesCheckerUtil.this._checkAssetEntries(portletPreferences);
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Reference(unbind="-")
    protected void setAssetPublisherWebUtil(AssetPublisherWebUtil assetPublisherWebUtil) {
        _assetPublisherWebUtil = assetPublisherWebUtil;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        _layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletPreferencesLocalService(PortletPreferencesLocalService portletPreferencesLocalService) {
        _portletPreferencesLocalService = portletPreferencesLocalService;
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        _subscriptionLocalService = subscriptionLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        _userLocalService = userLocalService;
    }

    private static List<AssetEntry> _filterAssetEntries(long userId, List<AssetEntry> assetEntries) {
        User user = _userLocalService.fetchUser(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        PermissionChecker permissionChecker = null;
        try {
            permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            try {
                if (!AssetEntryPermission.contains((PermissionChecker)permissionChecker, (AssetEntry)assetEntry, (String)"VIEW")) continue;
                filteredAssetEntries.add(assetEntry);
            }
            catch (Exception e) {}
        }
        return filteredAssetEntries;
    }

    private static SubscriptionSender _getSubscriptionSender(javax.portlet.PortletPreferences portletPreferences, List<AssetEntry> assetEntries) {
        if (assetEntries.isEmpty()) {
            return null;
        }
        AssetEntry assetEntry = assetEntries.get(0);
        String fromName = _assetPublisherWebUtil.getEmailFromName(portletPreferences, assetEntry.getCompanyId());
        String fromAddress = _assetPublisherWebUtil.getEmailFromAddress(portletPreferences, assetEntry.getCompanyId());
        Map<Locale, String> localizedSubjectMap = _assetPublisherWebUtil.getEmailAssetEntryAddedSubjectMap(portletPreferences);
        Map<Locale, String> localizedBodyMap = _assetPublisherWebUtil.getEmailAssetEntryAddedBodyMap(portletPreferences);
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(assetEntry.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ASSET_ENTRIES$]", ListUtil.toString(assetEntries, _titleAccessor, (String)", ")});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedPortletTitleMap(PortletConfigurationUtil.getPortletTitleMap((javax.portlet.PortletPreferences)portletPreferences));
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("asset_entry", new Object[]{assetEntry.getEntryId()});
        subscriptionSender.setPortletId("com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet");
        subscriptionSender.setReplyToAddress(fromAddress);
        return subscriptionSender;
    }

    private static void _notifySubscribers(List<Subscription> subscriptions, javax.portlet.PortletPreferences portletPreferences, List<AssetEntry> assetEntries) {
        if (!_assetPublisherWebUtil.getEmailAssetEntryAddedEnabled(portletPreferences)) {
            return;
        }
        HashMap<List<AssetEntry>, LinkedList<User>> assetEntriesToUsersMap = new HashMap<List<AssetEntry>, LinkedList<User>>();
        for (Subscription subscription : subscriptions) {
            List<AssetEntry> filteredAssetEntries;
            long userId = subscription.getUserId();
            User user = _userLocalService.fetchUser(userId);
            if (user == null || !user.isActive() || (filteredAssetEntries = AssetEntriesCheckerUtil._filterAssetEntries(userId, assetEntries)).isEmpty()) continue;
            LinkedList<User> users = (LinkedList<User>)assetEntriesToUsersMap.get(filteredAssetEntries);
            if (users == null) {
                users = new LinkedList<User>();
                assetEntriesToUsersMap.put(filteredAssetEntries, users);
            }
            users.add(user);
        }
        for (Map.Entry entry : assetEntriesToUsersMap.entrySet()) {
            List filteredAssetEntries = (List)entry.getKey();
            List users = (List)entry.getValue();
            SubscriptionSender subscriptionSender = AssetEntriesCheckerUtil._getSubscriptionSender(portletPreferences, filteredAssetEntries);
            if (subscriptionSender == null) continue;
            for (User user : users) {
                subscriptionSender.addRuntimeSubscribers(user.getEmailAddress(), user.getFullName());
            }
            subscriptionSender.flushNotificationsAsync();
        }
    }

    private void _checkAssetEntries(PortletPreferences portletPreferencesModel) throws PortalException {
        Layout layout = _layoutLocalService.fetchLayout(portletPreferencesModel.getPlid());
        if (layout == null) {
            return;
        }
        javax.portlet.PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)layout.getCompanyId(), (long)portletPreferencesModel.getOwnerId(), (int)portletPreferencesModel.getOwnerType(), (long)portletPreferencesModel.getPlid(), (String)portletPreferencesModel.getPortletId(), (String)portletPreferencesModel.getPreferences());
        if (!_assetPublisherWebUtil.getEmailAssetEntryAddedEnabled(portletPreferences)) {
            return;
        }
        List<AssetEntry> assetEntries = this._getAssetEntries(portletPreferences, layout);
        if (assetEntries.isEmpty()) {
            return;
        }
        long[] notifiedAssetEntryIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("notifiedAssetEntryIds", null));
        ArrayList<AssetEntry> newAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            if (ArrayUtil.contains((long[])notifiedAssetEntryIds, (long)assetEntry.getEntryId())) continue;
            newAssetEntries.add(assetEntry);
        }
        List subscriptions = _subscriptionLocalService.getSubscriptions(portletPreferencesModel.getCompanyId(), PortletPreferences.class.getName(), _assetPublisherWebUtil.getSubscriptionClassPK(portletPreferencesModel.getPlid(), portletPreferencesModel.getPortletId()));
        AssetEntriesCheckerUtil._notifySubscribers(subscriptions, portletPreferences, newAssetEntries);
        try {
            portletPreferences.setValues("notifiedAssetEntryIds", StringUtil.split((String)ListUtil.toString(assetEntries, (Accessor)AssetEntry.ENTRY_ID_ACCESSOR)));
            portletPreferences.store();
        }
        catch (IOException | PortletException e) {
            throw new PortalException(e);
        }
    }

    private List<AssetEntry> _getAssetEntries(javax.portlet.PortletPreferences portletPreferences, Layout layout) throws PortalException {
        AssetPublisherWebConfiguration assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)this._configurationProvider.getCompanyConfiguration(AssetPublisherWebConfiguration.class, layout.getCompanyId());
        AssetEntryQuery assetEntryQuery = AssetPublisherUtil.getAssetEntryQuery(portletPreferences, layout.getGroupId(), layout, null, null);
        assetEntryQuery.setEnd(assetPublisherWebConfiguration.dynamicSubscriptionLimit());
        assetEntryQuery.setStart(0);
        try {
            SearchContext searchContext = SearchContextFactory.getInstance((long[])new long[0], (String[])new String[0], null, (long)layout.getCompanyId(), (String)"", (Layout)layout, (Locale)LocaleThreadLocal.getSiteDefaultLocale(), (long)layout.getGroupId(), (TimeZone)TimeZoneThreadLocal.getDefaultTimeZone(), (long)0L);
            BaseModelSearchResult baseModelSearchResult = this._assetHelper.searchAssetEntries(searchContext, assetEntryQuery, 0, assetPublisherWebConfiguration.dynamicSubscriptionLimit());
            return baseModelSearchResult.getBaseModels();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    static {
        _titleAccessor = new Accessor<AssetEntry, String>(){

            public String get(AssetEntry assetEntry) {
                return assetEntry.getTitle(LocaleUtil.getSiteDefault());
            }

            public Class<String> getAttributeClass() {
                return String.class;
            }

            public Class<AssetEntry> getTypeClass() {
                return AssetEntry.class;
            }
        };
    }
}

