/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.internal.portlet.layout.listener;

import com.liferay.asset.publisher.web.internal.util.AssetPublisherWebUtil;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletLayoutListenerException;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet"}, service={PortletLayoutListener.class})
public class AssetPublisherPortletLayoutListener
implements PortletLayoutListener {
    @Reference
    private AssetPublisherWebUtil _assetPublisherWebUtil;
    private JournalArticleLocalService _journalArticleLocalService;
    private LayoutLocalService _layoutLocalService;
    private SubscriptionLocalService _subscriptionLocalService;

    public void onAddToLayout(String portletId, long plid) {
    }

    public void onMoveInLayout(String portletId, long plid) {
    }

    public void onRemoveFromLayout(String portletId, long plid) throws PortletLayoutListenerException {
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            if (this._assetPublisherWebUtil.isDefaultAssetPublisher(layout, portletId, "")) {
                this._journalArticleLocalService.deleteLayoutArticleReferences(layout.getGroupId(), layout.getUuid());
            }
            long ownerId = 0L;
            int ownerType = 3;
            if (PortletIdCodec.hasUserId((String)portletId)) {
                ownerType = 4;
                ownerId = PortletIdCodec.decodeUserId((String)portletId);
            }
            this._subscriptionLocalService.deleteSubscriptions(layout.getCompanyId(), PortletPreferences.class.getName(), this._assetPublisherWebUtil.getSubscriptionClassPK(ownerId, ownerType, plid, portletId));
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void onSetup(String portletId, long plid) {
    }

    public void updatePropertiesOnRemoveFromLayout(String portletId, UnicodeProperties typeSettingsProperties) throws PortletLayoutListenerException {
        String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
        if (portletId.equals(defaultAssetPublisherPortletId)) {
            typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", "");
        }
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
    }
}

