/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.internal.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.util.AssetEntryResult;
import com.liferay.asset.publisher.util.AssetPublisherHelper;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.util.AssetHelper;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, service={AssetPublisherHelper.class})
public class AssetPublisherHelperImpl
implements AssetPublisherHelper {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetEntryService _assetEntryService;
    @Reference
    private AssetHelper _assetHelper;
    private AssetPublisherWebConfiguration _assetPublisherWebConfiguration;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public long[] getAssetCategoryIds(PortletPreferences portletPreferences) {
        Object[] queryValues;
        long[] assetCategoryIds = new long[]{};
        int i = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (Objects.equals(queryName, "assetCategories") && queryContains && (queryAndOperator || queryValues.length == 1)) {
                assetCategoryIds = ArrayUtil.append((long[][])new long[][]{assetCategoryIds, GetterUtil.getLongValues((String[])queryValues)});
            }
            ++i;
        }
        return assetCategoryIds;
    }

    public BaseModelSearchResult<AssetEntry> getAssetEntries(AssetEntryQuery assetEntryQuery, Layout layout, PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, Map<String, Serializable> attributes, int start, int end) throws Exception {
        if (this._isSearchWithIndex(portletName, assetEntryQuery)) {
            return this._assetHelper.searchAssetEntries(assetEntryQuery, this.getAssetCategoryIds(portletPreferences), this.getAssetTagNames(portletPreferences), attributes, companyId, assetEntryQuery.getKeywords(), layout, locale, scopeGroupId, timeZone, userId, start, end);
        }
        int total = this._assetEntryService.getEntriesCount(assetEntryQuery);
        assetEntryQuery.setEnd(end);
        assetEntryQuery.setStart(start);
        List results = this._assetEntryService.getEntries(assetEntryQuery);
        return new BaseModelSearchResult(results, total);
    }

    public List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, boolean deleteMissingAssetEntries, boolean checkPermission) throws Exception {
        return this.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, deleteMissingAssetEntries, checkPermission, false);
    }

    public List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, boolean deleteMissingAssetEntries, boolean checkPermission, boolean includeNonVisibleAssets) throws Exception {
        return this.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, deleteMissingAssetEntries, checkPermission, includeNonVisibleAssets, 1);
    }

    public List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, boolean deleteMissingAssetEntries, boolean checkPermission, boolean includeNonVisibleAssets, int type) throws Exception {
        String[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        ArrayList<String> missingAssetEntryUuids = new ArrayList<String>();
        for (String assetEntryXml : assetEntryXmls) {
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            String assetEntryType = rootElement.elementText("asset-entry-type");
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntryType);
            String portletId = null;
            if (assetRendererFactory != null) {
                portletId = assetRendererFactory.getPortletId();
            }
            AssetEntry assetEntry = null;
            for (long groupId : groupIds) {
                Group group = this._groupLocalService.fetchGroup(groupId);
                if (portletId != null && group.isStagingGroup() && !group.isStagedPortlet(portletId)) {
                    groupId = group.getLiveGroupId();
                }
                if ((assetEntry = this._assetEntryLocalService.fetchEntry(groupId, assetEntryUuid)) != null) break;
            }
            if (assetEntry == null) {
                if (!deleteMissingAssetEntries) continue;
                missingAssetEntryUuids.add(assetEntryUuid);
                continue;
            }
            if (!assetEntry.isVisible() && !includeNonVisibleAssets) continue;
            assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), type);
            if (!assetRendererFactory.isActive(permissionChecker.getCompanyId())) {
                if (!deleteMissingAssetEntries) continue;
                missingAssetEntryUuids.add(assetEntryUuid);
                continue;
            }
            if (checkPermission && (!assetRenderer.isDisplayable() && !includeNonVisibleAssets || !assetRenderer.hasViewPermission(permissionChecker) && !(assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), 1)).hasViewPermission(permissionChecker))) continue;
            assetEntries.add(assetEntry);
        }
        if (deleteMissingAssetEntries) {
            this._removeAndStoreSelection(missingAssetEntryUuids, portletPreferences);
            if (!missingAssetEntryUuids.isEmpty()) {
                SessionMessages.add((PortletRequest)portletRequest, (String)"deletedMissingAssetEntries", missingAssetEntryUuids);
            }
        }
        return assetEntries;
    }

    public List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, long[] allCategoryIds, String[] allTagNames, boolean deleteMissingAssetEntries, boolean checkPermission) throws Exception {
        List<AssetEntry> assetEntries = this.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, deleteMissingAssetEntries, checkPermission);
        if (assetEntries.isEmpty() || ArrayUtil.isEmpty((long[])allCategoryIds) && ArrayUtil.isEmpty((Object[])allTagNames)) {
            return assetEntries;
        }
        if (!ArrayUtil.isEmpty((long[])allCategoryIds)) {
            assetEntries = AssetPublisherHelperImpl._filterAssetCategoriesAssetEntries(assetEntries, allCategoryIds);
        }
        if (!ArrayUtil.isEmpty((Object[])allTagNames)) {
            assetEntries = AssetPublisherHelperImpl._filterAssetTagNamesAssetEntries(assetEntries, allTagNames);
        }
        return assetEntries;
    }

    public AssetEntryQuery getAssetEntryQuery(PortletPreferences portletPreferences, long groupId, Layout layout, long[] overrideAllAssetCategoryIds, String[] overrideAllAssetTagNames) throws PortalException {
        long[] groupIds = this.getGroupIds(portletPreferences, groupId, layout);
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        this._setCategoriesAndTags(assetEntryQuery, portletPreferences, groupIds, overrideAllAssetCategoryIds, overrideAllAssetTagNames);
        assetEntryQuery.setGroupIds(groupIds);
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", null), (boolean)true);
        if (!anyAssetType) {
            long[] availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)layout.getCompanyId());
            long[] classNameIds = this.getClassNameIds(portletPreferences, availableClassNameIds);
            assetEntryQuery.setClassNameIds(classNameIds);
        }
        long[] classTypeIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classTypeIds", null));
        assetEntryQuery.setClassTypeIds(classTypeIds);
        boolean enablePermissions = GetterUtil.getBoolean((String)portletPreferences.getValue("enablePermissions", null));
        assetEntryQuery.setEnablePermissions(enablePermissions);
        boolean excludeZeroViewCount = GetterUtil.getBoolean((String)portletPreferences.getValue("excludeZeroViewCount", null));
        assetEntryQuery.setExcludeZeroViewCount(excludeZeroViewCount);
        boolean showOnlyLayoutAssets = GetterUtil.getBoolean((String)portletPreferences.getValue("showOnlyLayoutAssets", null));
        if (showOnlyLayoutAssets) {
            assetEntryQuery.setLayout(layout);
        }
        String orderByColumn1 = GetterUtil.getString((String)portletPreferences.getValue("orderByColumn1", "modifiedDate"));
        assetEntryQuery.setOrderByCol1(orderByColumn1);
        String orderByColumn2 = GetterUtil.getString((String)portletPreferences.getValue("orderByColumn2", "title"));
        assetEntryQuery.setOrderByCol2(orderByColumn2);
        String orderByType1 = GetterUtil.getString((String)portletPreferences.getValue("orderByType1", "DESC"));
        assetEntryQuery.setOrderByType1(orderByType1);
        String orderByType2 = GetterUtil.getString((String)portletPreferences.getValue("orderByType2", "ASC"));
        assetEntryQuery.setOrderByType2(orderByType2);
        return assetEntryQuery;
    }

    public List<AssetEntryResult> getAssetEntryResults(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, Map<String, Serializable> attributes) throws Exception {
        if (!AssetPublisherHelperImpl._isShowAssetEntryResults(portletName, assetEntryQuery)) {
            return Collections.emptyList();
        }
        long assetVocabularyId = GetterUtil.getLong((String)portletPreferences.getValue("assetVocabularyId", null));
        if (assetVocabularyId > 0L) {
            return this._getAssetEntryResultsByVocabulary(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, assetVocabularyId, attributes);
        }
        if (assetVocabularyId <= -1L) {
            return this._getAssetEntryResultsByClassName(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, attributes);
        }
        return this._getAssetEntryResultsByDefault(searchContainer, assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, classNameIds, attributes);
    }

    public String[] getAssetTagNames(PortletPreferences portletPreferences) {
        Object[] queryValues;
        Object[] allAssetTagNames = new String[]{};
        int i = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (!Objects.equals(queryName, "assetCategories") && queryContains && (queryAndOperator || queryValues.length == 1)) {
                allAssetTagNames = queryValues;
            }
            ++i;
        }
        return allAssetTagNames;
    }

    public String getAssetViewURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetEntry assetEntry) {
        return this.getAssetViewURL(liferayPortletRequest, liferayPortletResponse, assetEntry, false);
    }

    public String getAssetViewURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetEntry assetEntry, boolean viewInContext) {
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        return this.getAssetViewURL(liferayPortletRequest, liferayPortletResponse, assetRenderer, assetEntry, viewInContext);
    }

    public String getAssetViewURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetRenderer<?> assetRenderer, AssetEntry assetEntry, boolean viewInContext) {
        PortletURL viewFullContentURL = liferayPortletResponse.createRenderURL();
        viewFullContentURL.setParameter("mvcPath", "/view_content.jsp");
        viewFullContentURL.setParameter("assetEntryId", String.valueOf(assetEntry.getEntryId()));
        PortletURL redirectURL = liferayPortletResponse.createRenderURL();
        int cur = ParamUtil.getInteger((PortletRequest)liferayPortletRequest, (String)"cur");
        int delta = ParamUtil.getInteger((PortletRequest)liferayPortletRequest, (String)"delta");
        boolean resetCur = ParamUtil.getBoolean((PortletRequest)liferayPortletRequest, (String)"resetCur");
        redirectURL.setParameter("cur", String.valueOf(cur));
        if (delta > 0) {
            redirectURL.setParameter("delta", String.valueOf(delta));
        }
        redirectURL.setParameter("resetCur", String.valueOf(resetCur));
        redirectURL.setParameter("assetEntryId", String.valueOf(assetEntry.getEntryId()));
        viewFullContentURL.setParameter("redirect", redirectURL.toString());
        AssetRendererFactory assetRendererFactory = assetRenderer.getAssetRendererFactory();
        viewFullContentURL.setParameter("type", assetRendererFactory.getType());
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (Validator.isNotNull((String)assetRenderer.getUrlTitle())) {
            if (assetRenderer.getGroupId() != themeDisplay.getScopeGroupId()) {
                viewFullContentURL.setParameter("groupId", String.valueOf(assetRenderer.getGroupId()));
            }
            viewFullContentURL.setParameter("urlTitle", assetRenderer.getUrlTitle());
        }
        String viewURL = null;
        if (viewInContext) {
            try {
                String noSuchEntryRedirect = viewFullContentURL.toString();
                viewURL = assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, noSuchEntryRedirect);
                if (Validator.isNotNull((String)viewURL) && !Objects.equals(viewURL, noSuchEntryRedirect)) {
                    viewURL = this._http.setParameter(viewURL, "redirect", this._portal.getCurrentURL((PortletRequest)liferayPortletRequest));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Validator.isNull(viewURL)) {
            viewURL = viewFullContentURL.toString();
        }
        return viewURL;
    }

    public long[] getClassNameIds(PortletPreferences portletPreferences, long[] availableClassNameIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", Boolean.TRUE.toString()));
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (anyAssetType || selectionStyle.equals("manual")) {
            return availableClassNameIds;
        }
        long defaultClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("anyAssetType", null));
        if (defaultClassNameId > 0L) {
            return new long[]{defaultClassNameId};
        }
        long[] classNameIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classNameIds", null));
        if (ArrayUtil.isNotEmpty((long[])classNameIds)) {
            return classNameIds;
        }
        return availableClassNameIds;
    }

    public long getGroupIdFromScopeId(String scopeId, long siteGroupId, boolean privateLayout) throws PortalException {
        if (scopeId.startsWith("ChildGroup_")) {
            String scopeIdSuffix = scopeId.substring("ChildGroup_".length());
            long childGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group childGroup = this._groupLocalService.getGroup(childGroupId);
            if (!childGroup.hasAncestor(siteGroupId)) {
                throw new PrincipalException();
            }
            return childGroupId;
        }
        if (scopeId.startsWith("Group_")) {
            String scopeIdSuffix = scopeId.substring("Group_".length());
            if (scopeIdSuffix.equals("default")) {
                return siteGroupId;
            }
            long scopeGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group scopeGroup = this._groupLocalService.getGroup(scopeGroupId);
            return scopeGroup.getGroupId();
        }
        if (scopeId.startsWith("LayoutUuid_")) {
            String layoutUuid = scopeId.substring("LayoutUuid_".length());
            Layout scopeIdLayout = this._layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, siteGroupId, privateLayout);
            Group scopeIdGroup = this._groupLocalService.checkScopeGroup(scopeIdLayout, PrincipalThreadLocal.getUserId());
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith("Layout_")) {
            String scopeIdSuffix = scopeId.substring("Layout_".length());
            long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdSuffix);
            Layout scopeIdLayout = this._layoutLocalService.getLayout(siteGroupId, privateLayout, scopeIdLayoutId);
            Group scopeIdGroup = scopeIdLayout.getScopeGroup();
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith("ParentGroup_")) {
            String scopeIdSuffix = scopeId.substring("ParentGroup_".length());
            long parentGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group parentGroup = this._groupLocalService.getGroup(parentGroupId);
            if (!SitesUtil.isContentSharingWithChildrenEnabled((Group)parentGroup)) {
                throw new PrincipalException();
            }
            Group group = this._groupLocalService.getGroup(siteGroupId);
            if (!group.hasAncestor(parentGroupId)) {
                throw new PrincipalException();
            }
            return parentGroupId;
        }
        throw new IllegalArgumentException("Invalid scope ID " + scopeId);
    }

    public long[] getGroupIds(PortletPreferences portletPreferences, long scopeGroupId, Layout layout) {
        String[] scopeIds = portletPreferences.getValues("scopeIds", new String[]{"Group_" + scopeGroupId});
        LinkedHashSet<Long> groupIds = new LinkedHashSet<Long>();
        for (String scopeId : scopeIds) {
            try {
                long groupId = this.getGroupIdFromScopeId(scopeId, scopeGroupId, layout.isPrivateLayout());
                groupIds.add(groupId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ArrayUtil.toLongArray(groupIds);
    }

    public String getScopeId(Group group, long scopeGroupId) {
        String key = null;
        if (group.isLayout()) {
            Layout layout = this._layoutLocalService.fetchLayout(group.getClassPK());
            key = "LayoutUuid_" + layout.getUuid();
        } else {
            Group scopeGroup;
            key = group.isLayoutPrototype() || group.getGroupId() == scopeGroupId ? "Group_default" : ((scopeGroup = this._groupLocalService.fetchGroup(scopeGroupId)).hasAncestor(group.getGroupId()) && SitesUtil.isContentSharingWithChildrenEnabled((Group)group) ? "ParentGroup_" + group.getGroupId() : (group.hasAncestor(scopeGroup.getGroupId()) ? "ChildGroup_" + group.getGroupId() : "Group_" + group.getGroupId()));
        }
        return key;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) throws ConfigurationException {
        this._assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)ConfigurableUtil.createConfigurable(AssetPublisherWebConfiguration.class, properties);
    }

    private static List<AssetEntry> _filterAssetCategoriesAssetEntries(List<AssetEntry> assetEntries, long[] assetCategoryIds) {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            if (!ArrayUtil.containsAll((long[])assetEntry.getCategoryIds(), (long[])assetCategoryIds)) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    private static List<AssetEntry> _filterAssetTagNamesAssetEntries(List<AssetEntry> assetEntries, String[] assetTagNames) {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            List assetTags = assetEntry.getTags();
            Object[] assetEntryAssetTagNames = new String[assetTags.size()];
            for (int i = 0; i < assetTags.size(); ++i) {
                AssetTag assetTag = (AssetTag)assetTags.get(i);
                assetEntryAssetTagNames[i] = assetTag.getName();
            }
            if (!ArrayUtil.containsAll((Object[])assetEntryAssetTagNames, (Object[])assetTagNames)) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    private static boolean _isShowAssetEntryResults(String portletName, AssetEntryQuery assetEntryQuery) {
        return !portletName.equals("com_liferay_asset_publisher_web_portlet_RelatedAssetsPortlet") || assetEntryQuery.getLinkedAssetEntryId() > 0L;
    }

    private long[] _filterAssetCategoryIds(long[] assetCategoryIds) {
        ArrayList<Long> assetCategoryIdsList = new ArrayList<Long>();
        for (long assetCategoryId : assetCategoryIds) {
            AssetCategory category = this._assetCategoryLocalService.fetchAssetCategory(assetCategoryId);
            if (category == null) continue;
            assetCategoryIdsList.add(assetCategoryId);
        }
        return ArrayUtil.toArray((Long[])assetCategoryIdsList.toArray(new Long[assetCategoryIdsList.size()]));
    }

    private List<AssetEntryResult> _getAssetEntryResultsByClassName(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, Map<String, Serializable> attributes) throws Exception {
        ArrayList<AssetEntryResult> assetEntryResults = new ArrayList<AssetEntryResult>();
        int end = searchContainer.getEnd();
        int start = searchContainer.getStart();
        int total = 0;
        for (long classNameId : classNameIds) {
            assetEntryQuery.setClassNameIds(new long[]{classNameId});
            BaseModelSearchResult<AssetEntry> baseModelSearchResult = this.getAssetEntries(assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, attributes, start, end);
            int groupTotal = baseModelSearchResult.getLength();
            total += groupTotal;
            List assetEntries = baseModelSearchResult.getBaseModels();
            if (!assetEntries.isEmpty() && start < groupTotal) {
                AssetRendererFactory groupAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)classNameId);
                String title = ResourceActionsUtil.getModelResource((Locale)locale, (String)groupAssetRendererFactory.getClassName());
                assetEntryResults.add(new AssetEntryResult(title, assetEntries));
            }
            if (portletName.equals("com_liferay_asset_publisher_web_portlet_RecentContentPortlet")) continue;
            if (groupTotal > 0) {
                end = end > 0 && end > groupTotal ? (end -= groupTotal) : 0;
                start = start > 0 && start > groupTotal ? (start -= groupTotal) : 0;
            }
            assetEntryQuery.setEnd(-1);
            assetEntryQuery.setStart(-1);
        }
        searchContainer.setTotal(total);
        return assetEntryResults;
    }

    private List<AssetEntryResult> _getAssetEntryResultsByDefault(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, Map<String, Serializable> attributes) throws Exception {
        ArrayList<AssetEntryResult> assetEntryResults = new ArrayList<AssetEntryResult>();
        int end = searchContainer.getEnd();
        int start = searchContainer.getStart();
        assetEntryQuery.setClassNameIds(classNameIds);
        BaseModelSearchResult<AssetEntry> baseModelSearchResult = this.getAssetEntries(assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, attributes, start, end);
        int total = baseModelSearchResult.getLength();
        searchContainer.setTotal(total);
        List assetEntries = baseModelSearchResult.getBaseModels();
        if (!assetEntries.isEmpty() && start < total) {
            assetEntryResults.add(new AssetEntryResult(assetEntries));
        }
        return assetEntryResults;
    }

    private List<AssetEntryResult> _getAssetEntryResultsByVocabulary(SearchContainer searchContainer, AssetEntryQuery assetEntryQuery, Layout layout, PortletPreferences portletPreferences, String portletName, Locale locale, TimeZone timeZone, long companyId, long scopeGroupId, long userId, long[] classNameIds, long assetVocabularyId, Map<String, Serializable> attributes) throws Exception {
        ArrayList<AssetEntryResult> assetEntryResults = new ArrayList<AssetEntryResult>();
        List assetCategories = this._assetCategoryLocalService.getVocabularyRootCategories(assetVocabularyId, -1, -1, null);
        assetEntryQuery.setClassNameIds(classNameIds);
        int end = searchContainer.getEnd();
        int start = searchContainer.getStart();
        int total = 0;
        for (AssetCategory assetCategory : assetCategories) {
            long[] oldAllCategoryIds = assetEntryQuery.getAllCategoryIds();
            long[] newAllAssetCategoryIds = ArrayUtil.append((long[])oldAllCategoryIds, (long)assetCategory.getCategoryId());
            assetEntryQuery.setAllCategoryIds(newAllAssetCategoryIds);
            BaseModelSearchResult<AssetEntry> baseModelSearchResult = this.getAssetEntries(assetEntryQuery, layout, portletPreferences, portletName, locale, timeZone, companyId, scopeGroupId, userId, attributes, start, end);
            int groupTotal = baseModelSearchResult.getLength();
            total += groupTotal;
            List assetEntries = baseModelSearchResult.getBaseModels();
            if (!assetEntries.isEmpty() && start < groupTotal) {
                String title = assetCategory.getTitle(locale);
                assetEntryResults.add(new AssetEntryResult(title, assetEntries));
            }
            if (groupTotal > 0) {
                end = end > 0 && end > groupTotal ? (end -= groupTotal) : 0;
                start = start > 0 && start > groupTotal ? (start -= groupTotal) : 0;
            }
            assetEntryQuery.setAllCategoryIds(oldAllCategoryIds);
            assetEntryQuery.setEnd(-1);
            assetEntryQuery.setStart(-1);
        }
        searchContainer.setTotal(total);
        return assetEntryResults;
    }

    private long[] _getSiteGroupIds(long[] groupIds) {
        LinkedHashSet<Long> siteGroupIds = new LinkedHashSet<Long>();
        for (long groupId : groupIds) {
            siteGroupIds.add(this._portal.getSiteGroupId(groupId));
        }
        return ArrayUtil.toLongArray(siteGroupIds);
    }

    private boolean _isSearchWithIndex(String portletName, AssetEntryQuery assetEntryQuery) {
        return this._assetPublisherWebConfiguration.searchWithIndex() && assetEntryQuery.getLinkedAssetEntryId() == 0L && !portletName.equals("com_liferay_asset_publisher_web_portlet_HighestRatedAssetsPortlet") && !portletName.equals("com_liferay_asset_publisher_web_portlet_MostViewedAssetsPortlet");
    }

    private void _removeAndStoreSelection(List<String> assetEntryUuids, PortletPreferences portletPreferences) throws Exception {
        if (assetEntryUuids.isEmpty()) {
            return;
        }
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        List assetEntryXmlsList = ListUtil.fromArray((Object[])assetEntryXmls);
        Iterator itr = assetEntryXmlsList.iterator();
        while (itr.hasNext()) {
            String assetEntryXml = (String)itr.next();
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            if (!assetEntryUuids.contains(assetEntryUuid)) continue;
            itr.remove();
        }
        portletPreferences.setValues("assetEntryXml", assetEntryXmlsList.toArray(new String[assetEntryXmlsList.size()]));
        portletPreferences.store();
    }

    private void _setCategoriesAndTags(AssetEntryQuery assetEntryQuery, PortletPreferences portletPreferences, long[] scopeGroupIds, long[] overrideAllAssetCategoryIds, String[] overrideAllAssetTagNames) {
        Object[] queryValues;
        long[] allAssetCategoryIds = new long[]{};
        long[] anyAssetCategoryIds = new long[]{};
        long[] notAllAssetCategoryIds = new long[]{};
        long[] notAnyAssetCategoryIds = new long[]{};
        Object[] allAssetTagNames = new String[]{};
        Object[] anyAssetTagNames = new String[]{};
        Object[] notAllAssetTagNames = new String[]{};
        Object[] notAnyAssetTagNames = new String[]{};
        int i = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i, null)))) {
            int queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (Objects.equals(queryName, "assetCategories")) {
                long[] lArray = GetterUtil.getLongValues((String[])queryValues);
                if (queryContains != 0 && queryAndOperator) {
                    allAssetCategoryIds = lArray;
                } else if (queryContains != 0 && !queryAndOperator) {
                    anyAssetCategoryIds = lArray;
                } else if (queryContains == 0 && queryAndOperator) {
                    notAllAssetCategoryIds = lArray;
                } else {
                    notAnyAssetCategoryIds = lArray;
                }
            } else if (queryContains != 0 && queryAndOperator) {
                allAssetTagNames = queryValues;
            } else if (queryContains != 0 && !queryAndOperator) {
                anyAssetTagNames = queryValues;
            } else if (queryContains == 0 && queryAndOperator) {
                notAllAssetTagNames = queryValues;
            } else {
                notAnyAssetTagNames = queryValues;
            }
            ++i;
        }
        if (overrideAllAssetCategoryIds != null) {
            allAssetCategoryIds = overrideAllAssetCategoryIds;
        }
        allAssetCategoryIds = this._filterAssetCategoryIds(allAssetCategoryIds);
        assetEntryQuery.setAllCategoryIds(allAssetCategoryIds);
        if (overrideAllAssetTagNames != null) {
            allAssetTagNames = overrideAllAssetTagNames;
        }
        long[] siteGroupIds = this._getSiteGroupIds(scopeGroupIds);
        for (Object assetTagName : allAssetTagNames) {
            long[] lArray = this._assetTagLocalService.getTagIds(siteGroupIds, (String)assetTagName);
            assetEntryQuery.addAllTagIdsArray(lArray);
        }
        assetEntryQuery.setAnyCategoryIds(anyAssetCategoryIds);
        long[] anyAssetTagIds = this._assetTagLocalService.getTagIds(siteGroupIds, (String[])anyAssetTagNames);
        assetEntryQuery.setAnyTagIds(anyAssetTagIds);
        assetEntryQuery.setNotAllCategoryIds(notAllAssetCategoryIds);
        for (String string : notAllAssetTagNames) {
            long[] notAllAssetTagIds = this._assetTagLocalService.getTagIds(siteGroupIds, string);
            assetEntryQuery.addNotAllTagIdsArray(notAllAssetTagIds);
        }
        assetEntryQuery.setNotAnyCategoryIds(notAnyAssetCategoryIds);
        long[] notAnyAssetTagIds = this._assetTagLocalService.getTagIds(siteGroupIds, (String[])notAnyAssetTagNames);
        assetEntryQuery.setNotAnyTagIds(notAnyAssetTagIds);
    }
}

