/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.internal.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.web.configuration.AssetPublisherPortletInstanceConfiguration;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.util.AssetEntryQueryProcessor;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={AssetPublisherWebUtil.class})
public class AssetPublisherWebUtil {
    private static final Log _log = LogFactoryUtil.getLog(AssetPublisherWebUtil.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    private final List<AssetEntryQueryProcessor> _assetEntryQueryProcessors = new CopyOnWriteArrayList<AssetEntryQueryProcessor>();
    private AssetPublisherPortletInstanceConfiguration _assetPublisherPortletInstanceConfiguration;
    @Reference
    private AssetPublisherUtil _assetPublisherUtil;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public void addAndStoreSelection(PortletRequest portletRequest, String className, long classPK, int assetEntryOrder) throws Exception {
        String portletId = this._portal.getPortletId(portletRequest);
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        if (!rootPortletId.equals("com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = this._layoutLocalService.fetchLayout(themeDisplay.getPlid());
        javax.portlet.PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            return;
        }
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            return;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(className, classPK);
        this.addSelection(portletPreferences, assetEntry.getEntryId(), assetEntryOrder, className);
        portletPreferences.store();
    }

    public void addSelection(javax.portlet.PortletPreferences portletPreferences, long assetEntryId, int assetEntryOrder, String assetEntryType) throws Exception {
        String assetEntryXml;
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryId);
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        if (!ArrayUtil.contains((Object[])assetEntryXmls, (Object)(assetEntryXml = this._getAssetEntryXml(assetEntryType, assetEntry.getClassUuid())))) {
            if (assetEntryOrder > -1) {
                assetEntryXmls[assetEntryOrder] = assetEntryXml;
            } else {
                assetEntryXmls = (String[])ArrayUtil.append((Object[])assetEntryXmls, (Object)assetEntryXml);
            }
            portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
        }
        try {
            portletPreferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addSelection(PortletRequest portletRequest, javax.portlet.PortletPreferences portletPreferences) throws Exception {
        long assetEntryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"assetEntryId");
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"assetEntryOrder");
        String assetEntryType = ParamUtil.getString((PortletRequest)portletRequest, (String)"assetEntryType");
        this.addSelection(portletPreferences, assetEntryId, assetEntryOrder, assetEntryType);
    }

    public String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        return this._ddmIndexer.encodeName(ddmStructureId, fieldName, locale);
    }

    public String filterAssetTagNames(long groupId, String assetTagNames) {
        long[] assetTagIds;
        ArrayList<String> filteredAssetTagNames = new ArrayList<String>();
        String[] assetTagNamesArray = StringUtil.split((String)assetTagNames);
        for (long assetTagId : assetTagIds = this._assetTagLocalService.getTagIds(groupId, assetTagNamesArray)) {
            AssetTag assetTag = this._assetTagLocalService.fetchAssetTag(assetTagId);
            if (assetTag == null) continue;
            filteredAssetTagNames.add(assetTag.getName());
        }
        return StringUtil.merge(filteredAssetTagNames);
    }

    public String getClassName(AssetRendererFactory<?> assetRendererFactory) {
        Class<?> clazz = assetRendererFactory.getClass();
        String className = clazz.getName();
        int pos = className.lastIndexOf(".");
        return className.substring(pos + 1);
    }

    public Long[] getClassTypeIds(javax.portlet.PortletPreferences portletPreferences, String className, List<ClassType> availableClassTypes) {
        Long[] availableClassTypeIds = new Long[availableClassTypes.size()];
        for (int i = 0; i < availableClassTypeIds.length; ++i) {
            ClassType classType = availableClassTypes.get(i);
            availableClassTypeIds[i] = classType.getClassTypeId();
        }
        return this._getClassTypeIds(portletPreferences, className, availableClassTypeIds);
    }

    public String getDefaultAssetPublisherId(Layout layout) {
        return layout.getTypeSettingsProperty("default-asset-publisher-portlet-id", "");
    }

    public Map<Locale, String> getEmailAssetEntryAddedBodyMap(javax.portlet.PortletPreferences portletPreferences) {
        Locale defaultLocale;
        LocalizedValuesMap emailAssetEntryAddedLocalizedBodyMap = this._assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedBody();
        Map emailAssetEntryAddedBodyMap = LocalizationUtil.getLocalizationMap((javax.portlet.PortletPreferences)portletPreferences, (String)"emailAssetEntryAddedBody", (String)"", (String)"", (ClassLoader)AssetPublisherWebUtil.class.getClassLoader());
        if (Validator.isNull((String)((String)emailAssetEntryAddedBodyMap.get(defaultLocale = LocaleUtil.getSiteDefault())))) {
            emailAssetEntryAddedBodyMap.put(defaultLocale, emailAssetEntryAddedLocalizedBodyMap.getDefaultValue());
        }
        return emailAssetEntryAddedBodyMap;
    }

    public boolean getEmailAssetEntryAddedEnabled(javax.portlet.PortletPreferences portletPreferences) {
        String emailAssetEntryAddedEnabled = portletPreferences.getValue("emailAssetEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailAssetEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailAssetEntryAddedEnabled);
        }
        return this._assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedEnabled();
    }

    public Map<Locale, String> getEmailAssetEntryAddedSubjectMap(javax.portlet.PortletPreferences portletPreferences) {
        Locale defaultLocale;
        LocalizedValuesMap emailAssetEntryAddedLocalizedSubjectMap = this._assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedSubject();
        Map emailAssetEntryAddedSubjectMap = LocalizationUtil.getLocalizationMap((javax.portlet.PortletPreferences)portletPreferences, (String)"emailAssetEntryAddedSubject", (String)"", (String)"", (ClassLoader)AssetPublisherWebUtil.class.getClassLoader());
        if (Validator.isNull((String)((String)emailAssetEntryAddedSubjectMap.get(defaultLocale = LocaleUtil.getSiteDefault())))) {
            emailAssetEntryAddedSubjectMap.put(defaultLocale, emailAssetEntryAddedLocalizedSubjectMap.getDefaultValue());
        }
        return emailAssetEntryAddedSubjectMap;
    }

    public Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$ASSET_ENTRIES$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-list-of-assets"));
        definitionTerms.put("[$COMPANY_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-id-associated-with-the-assets"));
        definitionTerms.put("[$COMPANY_MX$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-mx-associated-with-the-assets"));
        definitionTerms.put("[$COMPANY_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-company-name-associated-with-the-assets"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)this._portal.getPortletTitle("com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", themeDisplay.getLocale())));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_TITLE$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$SITE_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-site-name-associated-with-the-assets"));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public String getEmailFromAddress(javax.portlet.PortletPreferences portletPreferences, long companyId) {
        return this._portal.getEmailFromAddress(portletPreferences, companyId, this._assetPublisherPortletInstanceConfiguration.emailFromAddress());
    }

    public String getEmailFromName(javax.portlet.PortletPreferences portletPreferences, long companyId) {
        return this._portal.getEmailFromName(portletPreferences, companyId, this._assetPublisherPortletInstanceConfiguration.emailFromName());
    }

    public long getSubscriptionClassPK(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        if (PortletIdCodec.hasUserId((String)portletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)portletId);
            ownerType = 4;
        }
        PortletPreferences portletPreferencesModel = this._portletPreferencesLocalService.getPortletPreferences(ownerId, ownerType, plid, portletId);
        return portletPreferencesModel.getPortletPreferencesId();
    }

    public long getSubscriptionClassPK(long plid, String portletId) throws PortalException {
        return this.getSubscriptionClassPK(0L, 3, plid, portletId);
    }

    public boolean isDefaultAssetPublisher(Layout layout, String portletId, String portletResource) {
        String defaultAssetPublisherPortletId = this.getDefaultAssetPublisherId(layout);
        if (Validator.isNull((String)defaultAssetPublisherPortletId)) {
            return false;
        }
        return defaultAssetPublisherPortletId.equals(portletId) || defaultAssetPublisherPortletId.equals(portletResource);
    }

    public boolean isScopeIdSelectable(PermissionChecker permissionChecker, String scopeId, long companyGroupId, Layout layout, boolean checkPermission) throws PortalException {
        long groupId = AssetPublisherUtil.getGroupIdFromScopeId(scopeId, layout.getGroupId(), layout.isPrivateLayout());
        if (scopeId.startsWith("ChildGroup_")) {
            Group group = this._groupLocalService.getGroup(groupId);
            if (!group.hasAncestor(layout.getGroupId())) {
                return false;
            }
        } else if (scopeId.startsWith("ParentGroup_")) {
            Group siteGroup = layout.getGroup();
            if (!siteGroup.hasAncestor(groupId)) {
                return false;
            }
            Group group = this._groupLocalService.getGroup(groupId);
            if (SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) {
                return true;
            }
            if (!PrefsPropsUtil.getBoolean((long)layout.getCompanyId(), (String)"sites.content.sharing.through.administrators.enabled")) {
                return false;
            }
            if (checkPermission) {
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"UPDATE");
            }
        } else if (groupId != companyGroupId && checkPermission) {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE");
        }
        return true;
    }

    public boolean isSubscribed(long companyId, long userId, long plid, String portletId) throws PortalException {
        return this._subscriptionLocalService.isSubscribed(companyId, userId, PortletPreferences.class.getName(), this.getSubscriptionClassPK(plid, portletId));
    }

    public void processAssetEntryQuery(User user, javax.portlet.PortletPreferences portletPreferences, AssetEntryQuery assetEntryQuery) throws Exception {
        for (AssetEntryQueryProcessor assetEntryQueryProcessor : this._assetEntryQueryProcessors) {
            assetEntryQueryProcessor.processAssetEntryQuery(user, portletPreferences, assetEntryQuery);
        }
    }

    public void subscribe(PermissionChecker permissionChecker, long groupId, long plid, String portletId) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)0L, (Layout)layout, (String)portletId, (String)"SUBSCRIBE", (boolean)false, (boolean)false);
        this._subscriptionLocalService.addSubscription(permissionChecker.getUserId(), groupId, PortletPreferences.class.getName(), this.getSubscriptionClassPK(plid, portletId));
    }

    public void unsubscribe(PermissionChecker permissionChecker, long plid, String portletId) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)0L, (Layout)layout, (String)portletId, (String)"SUBSCRIBE", (boolean)false, (boolean)false);
        this._subscriptionLocalService.deleteSubscription(permissionChecker.getUserId(), PortletPreferences.class.getName(), this.getSubscriptionClassPK(plid, portletId));
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) throws ConfigurationException {
        this._assetPublisherPortletInstanceConfiguration = (AssetPublisherPortletInstanceConfiguration)ConfigurationProviderUtil.getSystemConfiguration(AssetPublisherPortletInstanceConfiguration.class);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAssetEntryQueryProcessor(AssetEntryQueryProcessor assetEntryQueryProcessor) {
        this._assetEntryQueryProcessors.add(assetEntryQueryProcessor);
    }

    protected void unsetAssetEntryQueryProcessor(AssetEntryQueryProcessor assetEntryQueryProcessor) {
        this._assetEntryQueryProcessors.remove(assetEntryQueryProcessor);
    }

    private String _getAssetEntryXml(String assetEntryType, String assetEntryUuid) {
        String xml;
        block2: {
            xml = null;
            try {
                Document document = SAXReaderUtil.createDocument((String)"UTF-8");
                Element assetEntryElement = document.addElement("asset-entry");
                Element assetEntryTypeElement = assetEntryElement.addElement("asset-entry-type");
                assetEntryTypeElement.addText(assetEntryType);
                Element assetEntryUuidElement = assetEntryElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(assetEntryUuid);
                xml = document.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)ioe, (Throwable)ioe);
            }
        }
        return xml;
    }

    private Long[] _getClassTypeIds(javax.portlet.PortletPreferences portletPreferences, String className, Long[] availableClassTypeIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyClassType" + className, Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassTypeIds;
        }
        long defaultClassTypeId = GetterUtil.getLong((String)portletPreferences.getValue("anyClassType" + className, null), (long)-1L);
        if (defaultClassTypeId > -1L) {
            return new Long[]{defaultClassTypeId};
        }
        Long[] classTypeIds = ArrayUtil.toArray((long[])StringUtil.split((String)portletPreferences.getValue("classTypeIds" + className, null), (long)0L));
        if (classTypeIds != null) {
            return classTypeIds;
        }
        return availableClassTypeIds;
    }
}

