/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.portlet;

import com.liferay.asset.publisher.web.configuration.AssetPublisherPortletInstanceConfiguration;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.internal.action.AssetEntryActionRegistry;
import com.liferay.asset.publisher.web.internal.util.AssetPublisherWebUtil;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizerRegistry;
import com.liferay.asset.publisher.web.util.AssetRSSUtil;
import com.liferay.asset.util.AssetHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, property={"com.liferay.fragment.entry.processor.portlet.alias=asset-list", "com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-asset-publisher", "com.liferay.portlet.display-category=category.cms", "com.liferay.portlet.display-category=category.highlighted", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/asset_publisher.png", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.scopeable=false", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Asset Publisher", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user", "javax.portlet.supported-public-render-parameter=categoryId", "javax.portlet.supported-public-render-parameter=resetCur", "javax.portlet.supported-public-render-parameter=tag", "javax.portlet.supported-public-render-parameter=tags", "javax.portlet.supports.mime-type=text/html"}, service={AssetPublisherPortlet.class, Portlet.class})
public class AssetPublisherPortlet
extends MVCPortlet {
    @Reference
    protected AssetEntryActionRegistry assetEntryActionRegistry;
    @Reference
    protected AssetHelper assetHelper;
    @Reference
    protected AssetPublisherCustomizerRegistry assetPublisherCustomizerRegistry;
    protected AssetPublisherWebConfiguration assetPublisherWebConfiguration;
    @Reference
    protected AssetPublisherWebUtil assetPublisherWebUtil;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(AssetPublisherPortlet.class);

    public void getFieldValue(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)resourceRequest);
            long structureId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"structureId");
            Fields fields = (Fields)serviceContext.getAttribute(Fields.class.getName() + structureId);
            if (fields == null) {
                String fieldsNamespace = ParamUtil.getString((PortletRequest)resourceRequest, (String)"fieldsNamespace");
                fields = DDMUtil.getFields((long)structureId, (String)fieldsNamespace, (ServiceContext)serviceContext);
            }
            String fieldName = ParamUtil.getString((PortletRequest)resourceRequest, (String)"name");
            Field field = fields.get(fieldName);
            Serializable fieldValue = field.getValue(themeDisplay.getLocale(), 0);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            if (fieldValue == null) {
                jsonObject.put("success", false);
                this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
                return;
            }
            jsonObject.put("success", true);
            DDMStructure ddmStructure = field.getDDMStructure();
            String type = ddmStructure.getFieldType(fieldName);
            Serializable displayValue = DDMUtil.getDisplayFieldValue((ThemeDisplay)themeDisplay, (Serializable)fieldValue, (String)type);
            jsonObject.put("displayValue", String.valueOf(displayValue));
            if (fieldValue instanceof Boolean) {
                jsonObject.put("value", (Object)((Boolean)fieldValue));
            } else if (fieldValue instanceof Date) {
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMM ddHHmmss");
                jsonObject.put("value", dateFormat.format(fieldValue));
            } else if (fieldValue instanceof Double) {
                jsonObject.put("value", (Object)((Double)fieldValue));
            } else if (fieldValue instanceof Float) {
                jsonObject.put("value", (Object)((Float)fieldValue));
            } else if (fieldValue instanceof Integer) {
                jsonObject.put("value", (Object)((Integer)fieldValue));
            } else if (fieldValue instanceof Number) {
                jsonObject.put("value", String.valueOf(fieldValue));
            } else {
                jsonObject.put("value", (String)((Object)fieldValue));
            }
            this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void getRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        PortletPreferences portletPreferences = resourceRequest.getPreferences();
        boolean enableRss = GetterUtil.getBoolean((String)portletPreferences.getValue("enableRss", null));
        if (!this.portal.isRSSFeedsEnabled() || !enableRss) {
            try {
                this.portal.sendRSSFeedsDisabledError((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
            }
            catch (ServletException servletException) {
                // empty catch block
            }
            return;
        }
        resourceResponse.setContentType("text/xml; charset=UTF-8");
        try (OutputStream outputStream = resourceResponse.getPortletOutputStream();){
            String rootPortletId = PortletIdCodec.decodePortletName((String)this.portal.getPortletId((PortletRequest)resourceRequest));
            AssetPublisherCustomizer assetPublisherCustomizer = this.assetPublisherCustomizerRegistry.getAssetPublisherCustomizer(rootPortletId);
            resourceRequest.setAttribute("ASSET_PUBLISHER_CUSTOMIZER", (Object)assetPublisherCustomizer);
            resourceRequest.setAttribute("ASSET_PUBLISHER_WEB_UTIL", (Object)this.assetPublisherWebUtil);
            byte[] bytes = AssetRSSUtil.getRSS(resourceRequest, resourceResponse);
            outputStream.write(bytes);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get RSS feed", (Throwable)e);
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("ASSET_PUBLISHER_WEB_UTIL", (Object)this.assetPublisherWebUtil);
        super.render(renderRequest, renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String resourceID = GetterUtil.getString((String)resourceRequest.getResourceID());
        if (resourceID.equals("getFieldValue")) {
            this.getFieldValue(resourceRequest, resourceResponse);
        } else if (resourceID.equals("getRSS")) {
            this.getRSS(resourceRequest, resourceResponse);
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    public void subscribe(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.assetPublisherWebUtil.subscribe(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), themeDisplay.getPlid(), themeDisplay.getPpid());
    }

    public void unsubscribe(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.assetPublisherWebUtil.unsubscribe(themeDisplay.getPermissionChecker(), themeDisplay.getPlid(), themeDisplay.getPpid());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)ConfigurableUtil.createConfigurable(AssetPublisherWebConfiguration.class, properties);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            renderRequest.setAttribute("ASSET_ENTRY_ACTION_REGISTRY", (Object)this.assetEntryActionRegistry);
            renderRequest.setAttribute("ASSET_HELPER", (Object)this.assetHelper);
            String rootPortletId = PortletIdCodec.decodePortletName((String)this.portal.getPortletId((PortletRequest)renderRequest));
            AssetPublisherCustomizer assetPublisherCustomizer = this.assetPublisherCustomizerRegistry.getAssetPublisherCustomizer(rootPortletId);
            renderRequest.setAttribute("ASSET_PUBLISHER_CUSTOMIZER", (Object)assetPublisherCustomizer);
            renderRequest.setAttribute("ASSET_PUBLISHER_WEB_CONFIGURATION", (Object)this.assetPublisherWebConfiguration);
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            AssetPublisherPortletInstanceConfiguration assetPublisherPortletInstanceConfiguration = (AssetPublisherPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(AssetPublisherPortletInstanceConfiguration.class);
            renderRequest.setAttribute("ASSET_PUBLISHER_PORTLET_INSTANCE_CONFIGURATION", (Object)assetPublisherPortletInstanceConfiguration);
            renderRequest.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get asset publisher customizer", (Throwable)e);
        }
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchGroupException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof NoSuchGroupException || cause instanceof PrincipalException;
    }
}

