/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.portlet;

import com.liferay.asset.display.contributor.AssetDisplayContributor;
import com.liferay.asset.display.contributor.AssetDisplayContributorTracker;
import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.InheritableMap;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FriendlyURLResolver.class})
public class DisplayPageFriendlyURLResolver
implements FriendlyURLResolver {
    private static final Log _log = LogFactoryUtil.getLog(DisplayPageFriendlyURLResolver.class);
    @Reference
    private AssetDisplayContributorTracker _assetDisplayContributorTracker;
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    private JournalArticleLocalService _journalArticleLocalService;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getActualURL(long companyId, long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String urlTitle = friendlyURL.substring("/-/".length());
        JournalArticle journalArticle = this._journalArticleLocalService.getLatestArticleByUrlTitle(groupId, FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle), 0);
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        if (this._isShowDisplayPageEntry(assetEntry)) {
            return this._getDisplayPageURL(assetEntry, mainPath, requestContext);
        }
        return this._getBasicLayoutURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext, urlTitle, journalArticle);
    }

    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long companyId, long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        Layout layout = this.getJournalArticleLayout(groupId, privateLayout, friendlyURL);
        return new LayoutFriendlyURLComposite(layout, friendlyURL);
    }

    public String getURLSeparator() {
        return "/-/";
    }

    protected Layout getJournalArticleLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        JournalArticle journalArticle;
        block3: {
            String urlTitle = friendlyURL.substring("/-/".length());
            String normalizedUrlTitle = FriendlyURLNormalizerUtil.normalizeWithEncoding((String)urlTitle);
            journalArticle = this._journalArticleLocalService.getArticleByUrlTitle(groupId, normalizedUrlTitle);
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
            try {
                Layout layout = this._getAssetDisplayPageEntryLayout(assetEntry);
                if (layout != null) {
                    return layout;
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return this._layoutLocalService.getLayoutByUuidAndGroupId(journalArticle.getLayoutUuid(), groupId, privateLayout);
    }

    @Reference(unbind="-")
    protected void setAssetTagLocalService(AssetTagLocalService assetTagLocalService) {
        this._assetTagLocalService = assetTagLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    private Layout _createAssetDisplayLayout(long groupId) throws PortalException {
        Group group = this._groupLocalService.fetchGroup(groupId);
        long defaultUserId = this._userLocalService.getDefaultUserId(group.getCompanyId());
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(locale, "Asset Display Page");
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("visible", Boolean.FALSE.toString());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        return this._layoutLocalService.addLayout(defaultUserId, groupId, false, 0L, nameMap, null, null, null, null, "asset_display", typeSettingsProperties.toString(), true, new HashMap(), serviceContext);
    }

    private Layout _getAssetDisplayLayout(long groupId) throws PortalException {
        List layouts = this._layoutLocalService.getLayouts(groupId, false, "asset_display");
        if (!ListUtil.isEmpty((List)layouts)) {
            return (Layout)layouts.get(0);
        }
        return this._createAssetDisplayLayout(groupId);
    }

    private Layout _getAssetDisplayPageEntryLayout(AssetEntry assetEntry) throws PortalException {
        if (this._isShowDisplayPageEntry(assetEntry)) {
            return this._getAssetDisplayLayout(assetEntry.getGroupId());
        }
        return null;
    }

    private String _getBasicLayoutURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext, String urlTitle, JournalArticle journalArticle) throws PortalException {
        String defaultAssetPublisherPortletId;
        Layout layout = this.getJournalArticleLayout(groupId, privateLayout, friendlyURL);
        String layoutActualURL = this._portal.getLayoutActualURL(layout, mainPath);
        InheritableMap actualParams = new InheritableMap();
        if (params != null) {
            actualParams.setParentMap(params);
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        String currentDefaultAssetPublisherPortletId = defaultAssetPublisherPortletId = (String)typeSettingsProperties.get((Object)"default-asset-publisher-portlet-id");
        if (Validator.isNull((String)defaultAssetPublisherPortletId)) {
            defaultAssetPublisherPortletId = PortletIdCodec.encode((String)"com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet");
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        if (Validator.isNull((String)currentDefaultAssetPublisherPortletId)) {
            String actualPortletAuthenticationToken = AuthTokenUtil.getToken((HttpServletRequest)request, (long)layout.getPlid(), (String)defaultAssetPublisherPortletId);
            actualParams.put((Object)"p_p_auth", (Object)new String[]{actualPortletAuthenticationToken});
        }
        actualParams.put((Object)"p_p_id", (Object)new String[]{defaultAssetPublisherPortletId});
        actualParams.put((Object)"p_p_lifecycle", (Object)new String[]{"0"});
        if (Validator.isNull((String)currentDefaultAssetPublisherPortletId)) {
            actualParams.put((Object)"p_p_state", (Object)new String[]{WindowState.MAXIMIZED.toString()});
        }
        actualParams.put((Object)"p_p_mode", (Object)new String[]{"view"});
        actualParams.put((Object)"p_j_a_id", (Object)new String[]{String.valueOf(journalArticle.getId())});
        String namespace = this._portal.getPortletNamespace(defaultAssetPublisherPortletId);
        actualParams.put((Object)(namespace + "mvcPath"), (Object)new String[]{"/view_content.jsp"});
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)JournalArticle.class.getName());
        actualParams.put((Object)(namespace + "type"), (Object)new String[]{assetRendererFactory.getType()});
        actualParams.put((Object)(namespace + "urlTitle"), (Object)new String[]{journalArticle.getUrlTitle()});
        Locale locale = this._portal.getLocale(request);
        FriendlyURLEntryLocalization friendlyURLEntryLocalization = this._friendlyURLEntryLocalService.fetchFriendlyURLEntryLocalization(groupId, this._classNameLocalService.getClassNameId(JournalArticle.class), urlTitle);
        if (friendlyURLEntryLocalization != null) {
            locale = LocaleUtil.fromLanguageId((String)friendlyURLEntryLocalization.getLanguageId());
            request.setAttribute("I18N_LANGUAGE_ID", (Object)friendlyURLEntryLocalization.getLanguageId());
            actualParams.put((Object)(namespace + "languageId"), (Object)new String[]{friendlyURLEntryLocalization.getLanguageId()});
        }
        String queryString = this._http.parameterMapToString((Map)actualParams, false);
        layoutActualURL = layoutActualURL.contains("?") ? layoutActualURL + "&" + queryString : layoutActualURL + "?" + queryString;
        this._portal.addPageSubtitle(journalArticle.getTitle(locale), request);
        this._portal.addPageDescription(journalArticle.getDescription(locale), request);
        List assetTags = this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getPrimaryKey());
        if (!assetTags.isEmpty()) {
            this._portal.addPageKeywords(ListUtil.toString((List)assetTags, (Accessor)AssetTag.NAME_ACCESSOR), request);
        }
        return layoutActualURL;
    }

    private String _getDisplayPageURL(AssetEntry assetEntry, String mainPath, Map<String, Object> requestContext) throws PortalException {
        AssetDisplayContributor assetDisplayContributor = this._assetDisplayContributorTracker.getAssetDisplayContributor(assetEntry.getClassName());
        if (assetDisplayContributor == null) {
            throw new PortalException();
        }
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        request.setAttribute("ASSET_DISPLAY_CONTRIBUTOR", (Object)assetDisplayContributor);
        request.setAttribute("ASSET_ENTRY", (Object)assetEntry);
        Locale locale = this._portal.getLocale(request);
        this._portal.addPageSubtitle(assetEntry.getTitle(locale), request);
        this._portal.addPageDescription(assetEntry.getDescription(locale), request);
        Layout layout = this._getAssetDisplayPageEntryLayout(assetEntry);
        return this._portal.getLayoutActualURL(layout, mainPath);
    }

    private boolean _isShowDisplayPageEntry(AssetEntry assetEntry) {
        AssetDisplayPageEntry assetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(assetEntry.getGroupId(), assetEntry.getClassNameId(), assetEntry.getClassPK());
        if (assetDisplayPageEntry == null || assetDisplayPageEntry.getType() == 0) {
            return false;
        }
        if (assetDisplayPageEntry.getType() == 2) {
            return true;
        }
        LayoutPageTemplateEntry defaultLayoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(assetEntry.getGroupId(), assetEntry.getClassNameId(), assetEntry.getClassTypeId());
        return defaultLayoutPageTemplateEntry != null;
    }
}

