/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.publisher.web.portlet.action;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.asset.kernel.exception.DuplicateQueryRuleException;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.publisher.web.configuration.AssetPublisherPortletInstanceConfiguration;
import com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration;
import com.liferay.asset.publisher.web.internal.util.AssetPublisherWebUtil;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizer;
import com.liferay.asset.publisher.web.util.AssetPublisherCustomizerRegistry;
import com.liferay.asset.publisher.web.util.AssetPublisherUtil;
import com.liferay.asset.publisher.web.util.AssetQueryRule;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.item.selector.ItemSelector;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortletPreferencesImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.asset.publisher.web.configuration.AssetPublisherWebConfiguration"}, immediate=true, property={"javax.portlet.name=com_liferay_asset_publisher_web_portlet_AssetPublisherPortlet"}, service={ConfigurationAction.class})
public class AssetPublisherConfigurationAction
extends DefaultConfigurationAction {
    @Reference
    protected AssetPublisherCustomizerRegistry assetPublisherCustomizerRegistry;
    protected AssetPublisherWebConfiguration assetPublisherWebConfiguration;
    @Reference
    protected AssetPublisherWebUtil assetPublisherWebUtil;
    protected AssetTagLocalService assetTagLocalService;
    protected GroupLocalService groupLocalService;
    protected ItemSelector itemSelector;
    protected LayoutLocalService layoutLocalService;
    protected LayoutRevisionLocalService layoutRevisionLocalService;
    @Reference
    protected Portal portal;
    @Reference
    protected Staging staging;

    public String getJspPath(HttpServletRequest request) {
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (Objects.equals(cmd, "edit_query_rule")) {
            return "/edit_query_rule.jsp";
        }
        return "/configuration.jsp";
    }

    public void include(PortletConfig portletConfig, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletResource = ParamUtil.getString((HttpServletRequest)request, (String)"portletResource");
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletResource);
        AssetPublisherCustomizer assetPublisherCustomizer = this.assetPublisherCustomizerRegistry.getAssetPublisherCustomizer(rootPortletId);
        request.setAttribute("ASSET_PUBLISHER_CUSTOMIZER", (Object)assetPublisherCustomizer);
        request.setAttribute("ASSET_PUBLISHER_WEB_CONFIGURATION", (Object)this.assetPublisherWebConfiguration);
        request.setAttribute("ASSET_PUBLISHER_WEB_UTIL", (Object)this.assetPublisherWebUtil);
        request.setAttribute("ITEM_SELECTOR", (Object)this.itemSelector);
        request.setAttribute("ASSET_PUBLISHER_PORTLET_INSTANCE_CONFIGURATION", (Object)this._getAssetPublisherPortletInstanceConfiguration(request));
        super.include(portletConfig, request, response);
    }

    public void postProcess(long companyId, PortletRequest portletRequest, PortletPreferences portletPreferences) throws ConfigurationException {
        AssetPublisherPortletInstanceConfiguration assetPublisherPortletInstanceConfiguration = (AssetPublisherPortletInstanceConfiguration)ConfigurationProviderUtil.getSystemConfiguration(AssetPublisherPortletInstanceConfiguration.class);
        String languageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        LocalizedValuesMap emailAssetEntryAddedBodyMap = assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedBody();
        this.removeDefaultValue(portletRequest, portletPreferences, "emailAssetEntryAddedBody_" + languageId, emailAssetEntryAddedBodyMap.get(LocaleUtil.getSiteDefault()));
        LocalizedValuesMap emailAssetEntryAddedSubjectMap = assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedSubject();
        this.removeDefaultValue(portletRequest, portletPreferences, "emailAssetEntryAddedSubject_" + languageId, emailAssetEntryAddedSubjectMap.get(LocaleUtil.getSiteDefault()));
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = actionRequest.getPreferences();
        if (cmd.equals("translate")) {
            super.processAction(portletConfig, actionRequest, actionResponse);
        } else if (cmd.equals("update")) {
            try {
                HttpServletRequest request = this.portal.getHttpServletRequest((PortletRequest)actionRequest);
                AssetPublisherPortletInstanceConfiguration assetPublisherPortletInstanceConfiguration = this._getAssetPublisherPortletInstanceConfiguration(request);
                boolean emailAssetEntryAddedEnabled = GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "emailAssetEntryAddedEnabled"), (boolean)assetPublisherPortletInstanceConfiguration.emailAssetEntryAddedEnabled());
                if (emailAssetEntryAddedEnabled) {
                    this.validateEmail(actionRequest, "emailAssetEntryAdded");
                    this.validateEmailFrom(actionRequest);
                }
                this.updateDisplaySettings(actionRequest);
                String selectionStyle = this.getParameter((PortletRequest)actionRequest, "selectionStyle");
                if (selectionStyle.equals("dynamic")) {
                    this.updateQueryLogic(actionRequest, preferences);
                }
                this.updateDefaultAssetPublisher(actionRequest);
                super.processAction(portletConfig, actionRequest, actionResponse);
            }
            catch (Exception e) {
                if (e instanceof AssetTagException || e instanceof DuplicateQueryRuleException) {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                throw e;
            }
        } else {
            String redirect;
            if (cmd.equals("add-scope")) {
                this.addScope(actionRequest, preferences);
            } else if (cmd.equals("add-selection")) {
                this.assetPublisherWebUtil.addSelection((PortletRequest)actionRequest, preferences);
            } else if (cmd.equals("move-selection-down")) {
                this.moveSelectionDown(actionRequest, preferences);
            } else if (cmd.equals("move-selection-up")) {
                this.moveSelectionUp(actionRequest, preferences);
            } else if (cmd.equals("remove-selection")) {
                this.removeSelection(actionRequest, preferences);
            } else if (cmd.equals("remove-scope")) {
                this.removeScope(actionRequest, preferences);
            } else if (cmd.equals("select-scope")) {
                this.setScopes(actionRequest, preferences);
            } else if (cmd.equals("selection-style")) {
                this.setSelectionStyle(actionRequest, preferences);
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                preferences.store();
                SessionMessages.add((PortletRequest)actionRequest, (String)(this.portal.getPortletId((PortletRequest)actionRequest) + ".refreshPortlet"), (Object)portletResource);
                SessionMessages.add((PortletRequest)actionRequest, (String)(this.portal.getPortletId((PortletRequest)actionRequest) + ".updatedConfiguration"));
            }
            if (Validator.isNotNull((String)(redirect = this.portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.asset.publisher.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this.assetPublisherWebConfiguration = (AssetPublisherWebConfiguration)ConfigurableUtil.createConfigurable(AssetPublisherWebConfiguration.class, properties);
    }

    protected void addScope(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Object[] scopeIds = preferences.getValues("scopeIds", new String[]{"Group_default"});
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Group selectedGroup = this.groupLocalService.fetchGroup(groupId);
        String scopeId = AssetPublisherUtil.getScopeId(selectedGroup, themeDisplay.getScopeGroupId());
        this.checkPermission(actionRequest, scopeId);
        if (!ArrayUtil.contains((Object[])scopeIds, (Object)scopeId)) {
            scopeIds = (String[])ArrayUtil.append((Object[])scopeIds, (Object)scopeId);
        }
        preferences.setValues("scopeIds", (String[])scopeIds);
    }

    protected void checkPermission(ActionRequest actionRequest, String scopeId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!this.assetPublisherWebUtil.isScopeIdSelectable(themeDisplay.getPermissionChecker(), scopeId, themeDisplay.getCompanyGroupId(), layout, true)) {
            throw new PrincipalException();
        }
    }

    protected String getAssetClassName(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        String anyAssetTypeString = this.getParameter((PortletRequest)actionRequest, "anyAssetType");
        boolean anyAssetType = GetterUtil.getBoolean((String)anyAssetTypeString);
        if (anyAssetType) {
            return null;
        }
        long defaultAssetTypeId = GetterUtil.getLong((String)anyAssetTypeString);
        if (defaultAssetTypeId == 0L && classNameIds.length == 1) {
            defaultAssetTypeId = GetterUtil.getLong((String)classNameIds[0]);
        }
        if (defaultAssetTypeId <= 0L) {
            return null;
        }
        String className = this.portal.getClassName(defaultAssetTypeId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        String assetClassName = this.assetPublisherWebUtil.getClassName(assetRendererFactory);
        return assetClassName;
    }

    protected String[] getClassTypeIds(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        String assetClassName = this.getAssetClassName(actionRequest, classNameIds);
        if (assetClassName == null) {
            return null;
        }
        String anyAssetClassTypeString = this.getParameter((PortletRequest)actionRequest, "anyClassType" + assetClassName);
        boolean anyAssetClassType = GetterUtil.getBoolean((String)anyAssetClassTypeString);
        if (anyAssetClassType) {
            return null;
        }
        long defaultAssetClassTypeId = GetterUtil.getLong((String)anyAssetClassTypeString, (long)-1L);
        if (defaultAssetClassTypeId > -1L) {
            return new String[]{String.valueOf(defaultAssetClassTypeId)};
        }
        return StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "classTypeIds" + assetClassName));
    }

    protected AssetQueryRule getQueryRule(ActionRequest actionRequest, int index) {
        boolean contains = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryContains" + index));
        boolean andOperator = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryAndOperator" + index));
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)("queryName" + index));
        String[] values = null;
        values = name.equals("assetTags") ? StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryTagNames" + index))) : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryCategoryIds" + index)));
        return new AssetQueryRule(contains, andOperator, name, values);
    }

    protected boolean getSubtypesFieldsFilterEnabled(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        String assetClassName = this.getAssetClassName(actionRequest, classNameIds);
        if (assetClassName == null) {
            return false;
        }
        return GetterUtil.getBoolean((String)this.getParameter((PortletRequest)actionRequest, "subtypeFieldsFilterEnabled" + assetClassName));
    }

    protected void moveSelectionDown(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length - 1 || assetEntryOrder < 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder + 1];
        manualEntries[assetEntryOrder + 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("assetEntryXml", manualEntries);
    }

    protected void moveSelectionUp(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length || assetEntryOrder <= 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder - 1];
        manualEntries[assetEntryOrder - 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("assetEntryXml", manualEntries);
    }

    protected void removeScope(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] scopeIds = preferences.getValues("scopeIds", new String[]{"Group_default"});
        String scopeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"scopeId");
        scopeIds = ArrayUtil.remove((String[])scopeIds, (String)scopeId);
        if (scopeId.startsWith("ParentGroup_")) {
            scopeId = scopeId.substring("Parent".length());
            scopeIds = ArrayUtil.remove((String[])scopeIds, (String)scopeId);
        }
        preferences.setValues("scopeIds", scopeIds);
    }

    protected void removeSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length) {
            return;
        }
        String[] newEntries = new String[manualEntries.length - 1];
        int j = 0;
        for (int i = 0; i < manualEntries.length; ++i) {
            if (i == assetEntryOrder) continue;
            newEntries[j++] = manualEntries[i];
        }
        preferences.setValues("assetEntryXml", newEntries);
    }

    @Reference(unbind="-")
    protected void setAssetTagLocalService(AssetTagLocalService assetTagLocalService) {
        this.assetTagLocalService = assetTagLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setItemSelector(ItemSelector itemSelector) {
        this.itemSelector = itemSelector;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this.layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutRevisionLocalService(LayoutRevisionLocalService layoutRevisionLocalService) {
        this.layoutRevisionLocalService = layoutRevisionLocalService;
    }

    protected void setScopes(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] scopeIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "scopeIds"));
        preferences.setValues("scopeIds", scopeIds);
    }

    protected void setSelectionStyle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String selectionStyle = this.getParameter((PortletRequest)actionRequest, "selectionStyle");
        String displayStyle = this.getParameter((PortletRequest)actionRequest, "displayStyle");
        preferences.setValue("selectionStyle", selectionStyle);
        if (selectionStyle.equals("manual") || selectionStyle.equals("view-count")) {
            preferences.setValue("enableRss", Boolean.FALSE.toString());
            preferences.setValue("showQueryLogic", Boolean.FALSE.toString());
            preferences.reset("rssDelta");
            preferences.reset("rssDisplayStyle");
            preferences.reset("rssFormat");
            preferences.reset("rssName");
        }
        if (!selectionStyle.equals("view-count") && displayStyle.equals("view-count-details")) {
            preferences.setValue("displayStyle", "full-content");
        }
    }

    protected void updateDefaultAssetPublisher(ActionRequest actionRequest) throws Exception {
        boolean defaultAssetPublisher = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"defaultAssetPublisher");
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        if (defaultAssetPublisher) {
            typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", portletResource);
        } else {
            String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
            if (Validator.isNotNull((String)defaultAssetPublisherPortletId) && defaultAssetPublisherPortletId.equals(portletResource)) {
                typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", "");
            }
        }
        layout = this.layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            HttpServletRequest request = this.portal.getHttpServletRequest((PortletRequest)actionRequest);
            LayoutSetBranch layoutSetBranch = LayoutStagingUtil.getLayoutSetBranch((LayoutSet)layout.getLayoutSet());
            long layoutSetBranchId = layoutSetBranch.getLayoutSetBranchId();
            long layoutRevisionId = this.staging.getRecentLayoutRevisionId(request, layoutSetBranchId, layout.getPlid());
            LayoutRevision layoutRevision = this.layoutRevisionLocalService.getLayoutRevision(layoutRevisionId);
            PortletPreferencesImpl portletPreferences = (PortletPreferencesImpl)actionRequest.getPreferences();
            if (layoutRevision != null) {
                portletPreferences.setPlid(layoutRevision.getLayoutRevisionId());
            }
        }
    }

    protected void updateDisplaySettings(ActionRequest actionRequest) throws Exception {
        String[] classNameIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "classNameIds"));
        String[] classTypeIds = this.getClassTypeIds(actionRequest, classNameIds);
        Object[] extensions = actionRequest.getParameterValues("extensions");
        if (ArrayUtil.isNotEmpty((Object[])extensions) && extensions.length == 1 && ((String)extensions[0]).equals(Boolean.FALSE.toString())) {
            extensions = new String[]{};
        }
        boolean subtypeFieldsFilterEnabled = this.getSubtypesFieldsFilterEnabled(actionRequest, classNameIds);
        this.setPreference((PortletRequest)actionRequest, "classNameIds", classNameIds);
        this.setPreference((PortletRequest)actionRequest, "classTypeIds", classTypeIds);
        this.setPreference((PortletRequest)actionRequest, "extensions", (String[])extensions);
        this.setPreference((PortletRequest)actionRequest, "subtypeFieldsFilterEnabled", String.valueOf(subtypeFieldsFilterEnabled));
    }

    protected void updateQueryLogic(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        long groupId = themeDisplay.getSiteGroupId();
        int[] queryRulesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"queryLogicIndexes"), (int)0);
        int i = 0;
        ArrayList<AssetQueryRule> queryRules = new ArrayList<AssetQueryRule>();
        for (int queryRulesIndex : queryRulesIndexes) {
            AssetQueryRule queryRule = this.getQueryRule(actionRequest, queryRulesIndex);
            this.validateQueryRule(userId, groupId, queryRules, queryRule);
            queryRules.add(queryRule);
            this.setPreference((PortletRequest)actionRequest, "queryContains" + i, String.valueOf(queryRule.isContains()));
            this.setPreference((PortletRequest)actionRequest, "queryAndOperator" + i, String.valueOf(queryRule.isAndOperator()));
            this.setPreference((PortletRequest)actionRequest, "queryName" + i, queryRule.getName());
            this.setPreference((PortletRequest)actionRequest, "queryValues" + i, queryRule.getValues());
            ++i;
        }
        String[] values = preferences.getValues("queryValues" + i, new String[0]);
        while (values.length > 0) {
            this.setPreference((PortletRequest)actionRequest, "queryContains" + i, "");
            this.setPreference((PortletRequest)actionRequest, "queryAndOperator" + i, "");
            this.setPreference((PortletRequest)actionRequest, "queryName" + i, "");
            this.setPreference((PortletRequest)actionRequest, "queryValues" + i, new String[0]);
            values = preferences.getValues("queryValues" + ++i, new String[0]);
        }
    }

    protected void validateQueryRule(long userId, long groupId, List<AssetQueryRule> queryRules, AssetQueryRule queryRule) throws Exception {
        String name = queryRule.getName();
        if (name.equals("assetTags")) {
            this.assetTagLocalService.checkTags(userId, groupId, queryRule.getValues());
        }
        if (queryRules.contains(queryRule)) {
            throw new DuplicateQueryRuleException(queryRule.isContains(), queryRule.isAndOperator(), queryRule.getName());
        }
    }

    private AssetPublisherPortletInstanceConfiguration _getAssetPublisherPortletInstanceConfiguration(HttpServletRequest request) throws ConfigurationException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return (AssetPublisherPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(AssetPublisherPortletInstanceConfiguration.class);
    }
}

